/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3i;
import java.util.Iterator;
import java.util.Objects;
import mythruna.client.ui.item.Item;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSection
extends VersionedList<Item> {
    static Logger log = LoggerFactory.getLogger(ContainerSection.class);
    private final EntityId entityId;
    private final VersionedHolder<String> name = new VersionedHolder();

    public ContainerSection(EntityId entityId) {
        this(entityId, "Section");
    }

    public ContainerSection(EntityId entityId, String name) {
        this.entityId = entityId;
        this.name.setObject((Object)name);
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return (String)this.name.getObject();
    }

    public void setName(String name) {
        this.name.updateObject((Object)name);
    }

    public VersionedReference<String> createNameRef() {
        return this.name.createReference();
    }

    public boolean isEmpty(int xSlot, int ySlot, int width, int height) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Item child = (Item)iterator.next();
            if (!child.intersects(xSlot, ySlot, width, height)) continue;
            return false;
        }
        return true;
    }

    public Vec3i findEmptySlot(Item item, InventorySize2d containerSize) {
        int xSlots = containerSize.getXSlots();
        int ySlots = containerSize.getYSlots();
        int width = item.getItemSize().getXSlots();
        int height = item.getItemSize().getYSlots();
        if (width > xSlots || height > ySlots) {
            return null;
        }
        for (int x = 0; x < xSlots; ++x) {
            for (int y = 0; y < ySlots; ++y) {
                if (x + width > xSlots || y + height > ySlots || !this.isEmpty(x, y, width, height)) continue;
                return new Vec3i(x, y, 0);
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.name, super.hashCode());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ContainerSection other = (ContainerSection)((Object)o);
        if (!Objects.equals(other.entityId, this.entityId)) {
            return false;
        }
        if (!Objects.equals(other.name.getObject(), this.name.getObject())) {
            return false;
        }
        return super.equals(o);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)((Object)((Object)this)).getClass().getSimpleName()).add("entityId", (Object)this.entityId).add("name", (Object)this.getName()).add("items", (Object)super.toString()).toString();
    }
}

