/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.geom.FanMeshBuilder;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.MaterialFactories;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.sim.Blackboard;
import com.simsilica.state.BlackboardState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarTerrainState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(FarTerrainState.class);
    private static final double MIN_WORK = 9.765625E-4;
    private Node root = new Node("terrainRoot");
    private JobState workers;
    private Blackboard blackboard;
    private World world;
    private Geometry test;
    private Vector3f original;
    private VersionedReference<Vec3d> posRef;
    private LoresLayer nearLayer;
    private LoresLayer farLayer;
    private LoresLayer nearFluid;
    private LoresLayer farFluid;
    private int radials = 1440;
    private boolean wireframe = false;
    private byte[] fill = new byte[]{0, 0, 0, 0};
    private boolean lightingEnabled = true;
    private FogSettings fogSettings;
    private VersionedReference<FogSettings> fogSettingsRef;
    private double minStep = 1.0;
    private double growth = 1.5;
    private Function<TerrainImageType, Material> materialFactory;
    private boolean xzLockedCamera = false;
    private boolean cellDebug = false;
    private VersionedHolder<Integer> terrainTriangleCount = new VersionedHolder();
    private VersionedHolder<Integer> fluidTriangleCount = new VersionedHolder();
    private float horizontalLimit = 0.2f;
    private float verticalLimit = 0.65f;

    public FarTerrainState() {
        this(false);
    }

    public FarTerrainState(Blackboard blackboard) {
        this(false);
        this.blackboard = blackboard;
    }

    public FarTerrainState(boolean xzLockedCamera) {
        this.setEnabled(true);
        this.xzLockedCamera = xzLockedCamera;
    }

    public VersionedReference<Integer> getTerrainTriangleCount() {
        return this.terrainTriangleCount.createReference();
    }

    public VersionedReference<Integer> getFluidTriangleCount() {
        return this.fluidTriangleCount.createReference();
    }

    public void setMaterialFactory(Function<TerrainImageType, Material> materialFactory) {
        this.materialFactory = materialFactory;
        if (this.nearLayer != null) {
            this.nearLayer.updateMaterial(materialFactory);
            this.farLayer.updateMaterial(materialFactory);
            this.nearFluid.updateMaterial(materialFactory);
            this.farFluid.updateMaterial(materialFactory);
        }
    }

    public Function<TerrainImageType, Material> getMaterialFactory() {
        return this.materialFactory;
    }

    public void setXzLockedCamera(boolean f) {
        this.xzLockedCamera = f;
    }

    public boolean isXzLockedCamera() {
        return this.xzLockedCamera;
    }

    public void setCellDebug(boolean f) {
        this.cellDebug = f;
    }

    public boolean getCellDebug() {
        return this.cellDebug;
    }

    public void setRadials(int radials) {
        if (this.radials == radials) {
            return;
        }
        this.radials = radials;
        this.regenerateGeometry();
    }

    public int getRadials() {
        return this.radials;
    }

    public void setMinStep(double minStep) {
        if (this.minStep == minStep) {
            return;
        }
        this.minStep = minStep;
        this.regenerateGeometry();
    }

    public double getMinStep() {
        return this.minStep;
    }

    public void setGrowth(double growth) {
        if (this.growth == growth) {
            return;
        }
        this.growth = growth;
        this.regenerateGeometry();
    }

    public double getGrowth() {
        return this.growth;
    }

    public Texture getFarTerrainTexture() {
        return this.farLayer.getTexture();
    }

    public Texture getNearTerrainTexture() {
        return this.nearLayer.getTexture();
    }

    public Texture getFarFluidTexture() {
        return this.farFluid.getTexture();
    }

    public Texture getNearFluidTexture() {
        return this.nearFluid.getTexture();
    }

    protected void regenerateGeometry() {
        this.nearLayer.setRadials(this.radials);
        this.nearLayer.setMinStep(this.minStep);
        this.nearLayer.setGrowth(this.growth);
        this.farLayer.setRadials(this.radials);
        this.farLayer.setMinStep(this.minStep);
        this.farLayer.setGrowth(this.growth);
        this.nearLayer.regenerateMesh();
        this.farLayer.regenerateMesh();
        this.terrainTriangleCount.setObject((Object)(this.nearLayer.getTriangleCount() + this.farLayer.getTriangleCount()));
        this.nearFluid.setRadials(this.radials);
        this.nearFluid.setMinStep(this.minStep);
        this.nearFluid.setGrowth(this.growth);
        this.farFluid.setRadials(this.radials);
        this.farFluid.setMinStep(this.minStep);
        this.farFluid.setGrowth(this.growth);
        this.nearFluid.regenerateMesh();
        this.farFluid.regenerateMesh();
        this.fluidTriangleCount.setObject((Object)(this.nearFluid.getTriangleCount() + this.farFluid.getTriangleCount()));
    }

    public void setLightingEnabled(boolean lightingEnabled) {
        if (this.lightingEnabled == lightingEnabled) {
            return;
        }
        this.lightingEnabled = lightingEnabled;
        this.nearLayer.setLightingEnabled(lightingEnabled);
        this.farLayer.setLightingEnabled(lightingEnabled);
        this.nearFluid.setLightingEnabled(lightingEnabled);
        this.farFluid.setLightingEnabled(lightingEnabled);
    }

    public boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setFogSettings(FogSettings fogSettings) {
        this.fogSettings = fogSettings;
        this.fogSettingsRef = fogSettings == null ? null : fogSettings.createReference();
        this.resetFog();
    }

    public FogSettings getFogSettings() {
        return this.fogSettings;
    }

    protected int getFogDistance() {
        return this.fogSettings == null ? 0 : this.fogSettings.getFogDistance();
    }

    protected void resetFog() {
        TerrainState.updateFogDistance((Spatial)this.root, this.getFogDistance(), -1.0f);
    }

    public void setWireframe(boolean wireframe) {
        if (this.wireframe == wireframe) {
            return;
        }
        this.wireframe = wireframe;
        if (this.nearLayer != null) {
            this.nearLayer.setWireframe(wireframe);
        }
        if (this.farLayer != null) {
            this.farLayer.setWireframe(wireframe);
        }
        if (this.nearFluid != null) {
            this.nearFluid.setWireframe(wireframe);
        }
        if (this.farFluid != null) {
            this.farFluid.setWireframe(wireframe);
        }
    }

    public boolean getWireframe() {
        return this.wireframe;
    }

    public void setHorizontalLimit(float limit) {
        if (this.horizontalLimit == limit) {
            return;
        }
        this.horizontalLimit = limit;
        if (this.nearLayer != null) {
            this.nearLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.farLayer != null) {
            this.farLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.nearFluid != null) {
            this.nearFluid.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.farFluid != null) {
            this.farFluid.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
    }

    public float getHorizontalLimit() {
        return this.horizontalLimit;
    }

    public void setVerticalLimit(float limit) {
        if (this.verticalLimit == limit) {
            return;
        }
        this.verticalLimit = limit;
        if (this.nearLayer != null) {
            this.nearLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.farLayer != null) {
            this.farLayer.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.nearFluid != null) {
            this.nearFluid.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
        if (this.farFluid != null) {
            this.farFluid.setUpnessRange(this.horizontalLimit, this.verticalLimit);
        }
    }

    public float getVerticalLimit() {
        return this.verticalLimit;
    }

    protected void initialize(Application app) {
        if (this.blackboard == null) {
            this.blackboard = ((BlackboardState)this.getState(BlackboardState.class, true)).getBlackboard();
        }
        this.world = (World)this.blackboard.get(World.class);
        this.blackboard.onInitialize(FogSettings.class, fogSettings -> this.setFogSettings((FogSettings)fogSettings));
        this.workers = (JobState)this.getState("regularWorkers", JobState.class);
        if (this.workers == null) {
            this.workers = (JobState)this.getState(JobState.class, true);
        }
        this.posRef = ((VersionedObject)this.blackboard.get("position")).createReference();
        if (this.getMaterialFactory() == null) {
            log.warn("No material factory configured.  Using a default coloredTerrainMaterial()");
            ColorRGBA groundColor = new ColorRGBA(0.15f, 0.25f, 0.1f, 1.0f);
            ColorRGBA waterColor = new ColorRGBA(0.41960785f, 0.5529412f, 0.8509804f, 0.9f);
            this.setMaterialFactory(MaterialFactories.coloredFarTerrainMaterial(this.getApplication(), groundColor, waterColor));
        }
        int nearScale = 1024 / Resolution.Medium.getSamples();
        int farScale = 1024 / Resolution.Low.getSamples();
        int outerRadius = (nearScale / 2 - 1) * 1024 / nearScale;
        int nearBasePriority = 10000;
        int farBasePriority = 100000;
        this.nearLayer = new LoresLayer(TerrainImageType.Terrain, nearBasePriority, this.radials, (int)(512.0f / (float)nearScale), outerRadius, this.minStep, this.growth, Resolution.Medium);
        int farOuterRadius = (farScale / 2 - 1) * 1024 / farScale;
        this.farLayer = new LoresLayer(TerrainImageType.Terrain, farBasePriority, this.radials, (int)((float)outerRadius * (float)nearScale / (float)farScale), farOuterRadius, this.minStep, this.growth, Resolution.Low);
        this.terrainTriangleCount.setObject((Object)(this.nearLayer.getTriangleCount() + this.farLayer.getTriangleCount()));
        this.world.addTileListener(this.nearLayer);
        this.world.addTileListener(this.farLayer);
        this.nearFluid = new LoresLayer(TerrainImageType.Fluid, nearBasePriority, this.radials, (int)(512.0f / (float)nearScale), outerRadius, this.minStep, this.growth, Resolution.Medium);
        this.farFluid = new LoresLayer(TerrainImageType.Fluid, farBasePriority, this.radials, (int)((float)outerRadius * (float)nearScale / (float)farScale), farOuterRadius, this.minStep, this.growth, Resolution.Low);
        this.fluidTriangleCount.setObject((Object)(this.nearFluid.getTriangleCount() + this.farFluid.getTriangleCount()));
        this.nearFluid.setSpatialOffset(-0.25f);
        this.farFluid.setSpatialOffset(-0.25f);
    }

    private void fill(ByteBuffer data, byte ... bytes) {
        data.position(0);
        while (data.remaining() > 0) {
            data.put(bytes);
        }
    }

    private void writeTerrainLayerToImage(TerrainImage tile, ByteBuffer data, int xTarget, int yTarget) {
        int pos = xTarget + yTarget * 1024;
        for (int y = 0; y < tile.getSize(); ++y) {
            data.position(pos * 4);
            for (int x = 0; x < tile.getSize(); ++x) {
                short val = tile.getElevation(x, y);
                int elev = val & 0x3FF;
                int type = tile.getType(x, y);
                if (this.cellDebug && (x == 0 || y == 0)) {
                    type = 96;
                }
                int hi = elev / 255;
                int lo = elev % 255;
                byte r = (byte)type;
                byte light = tile.getLight(x, y);
                byte g = (byte)((0.5 + (double)light / 32.0) * 255.0);
                byte b = (byte)hi;
                byte a = (byte)lo;
                data.put(a).put(r).put(g).put(b);
                ++pos;
            }
            pos += 1024 - tile.getSize();
        }
    }

    private void writeBlankTerrainLayerToImage(int size, ByteBuffer data, int xTarget, int yTarget) {
        int pos = xTarget + yTarget * 1024;
        for (int y = 0; y < size; ++y) {
            data.position(pos * 4);
            for (int x = 0; x < size; ++x) {
                data.put((byte)0).put((byte)0).put((byte)0).put((byte)0);
                ++pos;
            }
            pos += 1024 - size;
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.root);
    }

    protected void onDisable() {
        this.root.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            Vec3d pos = (Vec3d)this.posRef.get();
            this.nearLayer.setPosition(pos);
            this.farLayer.setPosition(pos);
            this.nearFluid.setPosition(pos);
            this.farFluid.setPosition(pos);
        }
        if (this.fogSettingsRef != null && this.fogSettingsRef.update()) {
            this.resetFog();
        }
        this.nearLayer.processUpdates();
        this.farLayer.processUpdates();
        this.nearFluid.processUpdates();
        this.farFluid.processUpdates();
    }

    private class ImageTile
    implements Job {
        TerrainImageType type;
        TileId id;
        int priority;
        long version;
        int xCorner;
        int zCorner;
        Resolution res;
        Image image;
        ByteBuffer imageData;
        volatile TerrainImage terrainImage;
        int xImage;
        int yImage;
        volatile boolean visible = true;
        volatile boolean queued;

        public ImageTile(TerrainImageType type, TileId id, int xCorner, int zCorner, Resolution res, Image image, ByteBuffer imageData) {
            this.type = type;
            this.id = id;
            this.xCorner = xCorner;
            this.zCorner = zCorner;
            this.res = res;
            this.image = image;
            this.imageData = imageData;
        }

        public void setImagePosition(int xImage, int yImage) {
            this.xImage = xImage;
            this.yImage = yImage;
            if (!this.visible) {
                log.warn("Setting image position to invisible tile:" + this);
                return;
            }
            if (this.terrainImage != null) {
                FarTerrainState.this.writeTerrainLayerToImage(this.terrainImage, this.imageData, xImage, yImage);
            } else {
                FarTerrainState.this.writeBlankTerrainLayerToImage(this.res.getSamples(), this.imageData, xImage, yImage);
            }
            this.image.setUpdateNeeded();
        }

        public void release() {
            this.visible = false;
        }

        public void runOnWorker() {
            this.queued = false;
            if (!this.visible) {
                return;
            }
            long start = System.nanoTime();
            this.terrainImage = FarTerrainState.this.world.getTerrainImage(this.id, this.type, this.res);
            long end = System.nanoTime();
            if (log.isTraceEnabled()) {
                log.trace("tile time, resolution:" + (Object)((Object)this.res) + "  in:" + (double)(end - start) / 1000000.0 + " ms");
            }
        }

        public double runOnUpdate() {
            if (!this.visible) {
                return 0.0;
            }
            this.version = this.terrainImage.getVersion().getVersion();
            FarTerrainState.this.writeTerrainLayerToImage(this.terrainImage, this.imageData, this.xImage, this.yImage);
            this.image.setUpdateNeeded();
            return (double)this.res.getSamples() * 9.765625E-4;
        }

        public String toString() {
            return "ImageTile[" + this.id + ", resolution=" + (Object)((Object)this.res) + "]";
        }
    }

    private class TileChange {
        TileId id;
        long version;

        public TileChange(TileId id, long version) {
            this.id = id;
            this.version = version;
        }
    }

    private class ImagePositioner
    implements Runnable {
        ImageTile tile;
        int xImage;
        int yImage;

        public ImagePositioner(ImageTile tile, int xImage, int yImage) {
            this.tile = tile;
            this.xImage = xImage;
            this.yImage = yImage;
        }

        @Override
        public void run() {
            this.tile.setImagePosition(this.xImage, this.yImage);
        }
    }

    private class LoresLayer
    implements TileListener {
        private TerrainImageType type;
        private boolean water;
        private int basePriority;
        private Material material;
        private Geometry geom;
        private Vector3f baseGeomOffset;
        private float spatialOffset;
        private Texture texture;
        private Image image;
        private Vector2f terrainOffset = new Vector2f();
        private Grid terrainGrid = new Grid(1024, 1024, 1024);
        private Vec3i gridCenter = new Vec3i();
        private Vec3i centerWorld = new Vec3i();
        private Resolution res;
        private int scale;
        private int size;
        private int radius;
        private int tileSize;
        private int radials;
        private int innerRadius;
        private int outerRadius;
        private double minStep = 1.0;
        private double growth = 1.0;
        private ByteBuffer imageData;
        private ImageTile[][] tiles;
        private Map<TileId, ImageTile> tileCache = new HashMap<TileId, ImageTile>();
        private ConcurrentLinkedQueue<TileChange> changed = new ConcurrentLinkedQueue();
        private ConcurrentLinkedQueue<Runnable> imageWriters = new ConcurrentLinkedQueue();

        public LoresLayer(TerrainImageType type, int basePriority, int radials, int innerRadius, int outerRadius, double minStep, double growth, Resolution res) {
            this.type = type;
            this.water = this.water;
            this.basePriority = basePriority;
            this.res = res;
            this.scale = 1024 / res.getSamples();
            this.radials = radials;
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            this.minStep = minStep;
            this.growth = growth;
            boolean water = type == TerrainImageType.Fluid;
            ColliderlessMesh fan = new FanMeshBuilder().near(innerRadius).far(outerRadius).radials(radials).minStep(minStep).growthFactor(growth).skirtSize(water ? 0.0 : 20.0).build();
            this.geom = new Geometry("fan" + this.scale, (Mesh)fan);
            LayerComparator.setLayer((Spatial)this.geom, (int)(water ? 2 : 1));
            this.geom.setLocalScale((float)this.scale, 1.0f, (float)this.scale);
            this.geom.center();
            this.geom.move(0.0f, -this.geom.getLocalTranslation().y, 0.0f);
            this.baseGeomOffset = this.geom.getLocalTranslation().clone();
            this.geom.setModelBound((BoundingVolume)new BoundingBox(new Vector3f(-10000.0f, -100.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f)));
            FarTerrainState.this.root.attachChild((Spatial)this.geom);
            ByteBuffer data = this.imageData = BufferUtils.createByteBuffer((int)0x400000);
            FarTerrainState.this.fill(data, FarTerrainState.this.fill);
            this.radius = this.scale / 2 - 1;
            this.size = this.radius * 2 + 1;
            this.tiles = new ImageTile[this.size][this.size];
            this.tileSize = 1024 / this.scale;
            this.image = new Image(Image.Format.ARGB8, 1024, 1024, data, ColorSpace.Linear);
            this.texture = new Texture2D(this.image);
            this.updateMaterial(FarTerrainState.this.getMaterialFactory());
        }

        public void setSpatialOffset(float spatialOffset) {
            this.spatialOffset = spatialOffset;
        }

        public void updateMaterial(Function<TerrainImageType, Material> materialFactory) {
            Material mat = this.material = FarTerrainState.this.getMaterialFactory().apply(this.type);
            if (FarTerrainState.this.fogSettings != null) {
                FarTerrainState.this.fogSettings.apply(mat);
            }
            mat.setVector2("TerrainOffset", this.terrainOffset);
            this.material.setFloat("TerrainSize", this.res == Resolution.Medium ? 8192.0f : 16384.0f);
            mat.getAdditionalRenderState().setWireframe(FarTerrainState.this.wireframe);
            mat.setTexture("DiffuseMap", this.texture);
            this.setUpnessRange(FarTerrainState.this.horizontalLimit, FarTerrainState.this.verticalLimit);
            this.geom.setMaterial(mat);
        }

        public void setLightingEnabled(boolean lightingEnabled) {
            this.geom.getMaterial().setFloat("LocalLightStrength", lightingEnabled ? 0.8f : 0.0f);
        }

        public void setWireframe(boolean wireframe) {
            this.geom.getMaterial().getAdditionalRenderState().setWireframe(wireframe);
        }

        public void setUpnessRange(float min, float max) {
            if (min < max) {
                this.material.setFloat("HorizontalLimit", min);
                this.material.setFloat("VerticalLimit", max);
            } else {
                this.material.setFloat("HorizontalLimit", min);
                this.material.setFloat("VerticalLimit", min + 0.001f);
            }
        }

        public void setRadials(int radials) {
            this.radials = radials;
        }

        public void setMinStep(double minStep) {
            this.minStep = minStep;
        }

        public void setGrowth(double growth) {
            this.growth = growth;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public void regenerateMesh() {
            ColliderlessMesh fan = new FanMeshBuilder().near(this.innerRadius).far(this.outerRadius).radials(this.radials).minStep(this.minStep).growthFactor(this.growth).skirtSize(this.water ? 0.0 : 20.0).build();
            this.geom.setMesh((Mesh)fan);
        }

        public int getTriangleCount() {
            return this.geom.getMesh().getTriangleCount();
        }

        @Override
        public void tileChanged(TileChangeEvent event) {
            if (event.getDataVersion() == 0L) {
                return;
            }
            if (event.getResolution().isLowerThan(this.res)) {
                return;
            }
            this.changed.add(new TileChange(event.getTileId(), event.getDataVersion()));
        }

        public void setPosition(Vec3d pos) {
            this.updateTerrainTiles(pos, false);
            boolean continuous = false;
            if (continuous) {
                this.terrainOffset.x = (float)(pos.x % 1024.0 / (double)this.scale);
                if (this.terrainOffset.x < 0.0f) {
                    this.terrainOffset.x += (float)(1024 / this.scale);
                }
                this.terrainOffset.y = (float)(pos.z % 1024.0 / (double)this.scale);
                if (this.terrainOffset.y < 0.0f) {
                    this.terrainOffset.y += (float)(1024 / this.scale);
                }
            } else {
                Vec3d columnPos = ColumnId.fromWorld(pos).getWorld(null).toVec3d();
                columnPos.x += 16.0;
                columnPos.z += 16.0;
                if (FarTerrainState.this.xzLockedCamera) {
                    Vec3d offset = pos.subtract(columnPos);
                    this.geom.setLocalTranslation(this.baseGeomOffset.add((float)(-offset.x), this.spatialOffset, (float)(-offset.z)));
                } else {
                    this.geom.setLocalTranslation(this.baseGeomOffset.add(16.0f, this.spatialOffset, 16.0f));
                }
                this.terrainOffset.x = (float)(columnPos.x % 1024.0 / (double)this.scale);
                if (this.terrainOffset.x < 0.0f) {
                    this.terrainOffset.x += (float)(1024 / this.scale);
                }
                this.terrainOffset.y = (float)(columnPos.z % 1024.0 / (double)this.scale);
                if (this.terrainOffset.y < 0.0f) {
                    this.terrainOffset.y += (float)(1024 / this.scale);
                }
            }
        }

        public void processUpdates() {
            Runnable todo = this.imageWriters.poll();
            if (todo != null) {
                todo.run();
            }
            TileChange change = null;
            while ((change = this.changed.poll()) != null) {
                ImageTile it;
                if (log.isTraceEnabled()) {
                    log.trace("Checking change:" + change.id + "  " + change.version);
                }
                if ((it = this.tileCache.get(change.id)) == null) {
                    log.trace("no tile");
                    continue;
                }
                if (it.version > change.version) {
                    log.trace("Already newer");
                    continue;
                }
                it.queued = true;
                FarTerrainState.this.workers.execute((Job)it, it.priority);
            }
        }

        protected void updateTerrainTiles(Vec3d pos, boolean immediate) {
            Vec3i center = this.terrainGrid.worldToCell(pos, null);
            if (!this.tileCache.isEmpty() && center.x == this.gridCenter.x && center.y == this.gridCenter.y && center.z == this.gridCenter.z) {
                return;
            }
            this.gridCenter.set(center.x, center.y, center.z);
            this.centerWorld = this.terrainGrid.cellToWorld(this.gridCenter, this.centerWorld);
            this.imageWriters.clear();
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    int x = i - this.radius;
                    int z = j - this.radius;
                    TileId tileId = TileId.fromWorld(this.centerWorld.x + x * 1024, this.centerWorld.y, this.centerWorld.z + z * 1024);
                    ImageTile tile = this.tileCache.remove(tileId);
                    int priority = this.basePriority + x * x + z * z;
                    if (tile == null) {
                        if (log.isTraceEnabled()) {
                            log.trace("Creating tile for:" + tileId);
                        }
                        tile = new ImageTile(this.type, tileId, this.centerWorld.x + x * 1024, this.centerWorld.z + z * 1024, this.res, this.image, this.imageData);
                        tile.priority = priority;
                        if (!immediate) {
                            tile.queued = true;
                            FarTerrainState.this.workers.execute((Job)tile, tile.priority);
                        }
                    } else {
                        tile.priority = priority;
                    }
                    this.tiles[i][j] = tile;
                    tile.setImagePosition(512 + x * this.tileSize, 512 + z * this.tileSize);
                    if (!immediate) continue;
                    tile.runOnWorker();
                    tile.runOnUpdate();
                }
            }
            for (ImageTile tile : this.tileCache.values()) {
                tile.release();
                if (!tile.queued) continue;
                if (!FarTerrainState.this.workers.cancel((Job)tile)) {
                    log.debug("Tile job not canceled for:" + tile.id);
                    continue;
                }
                tile.queued = false;
            }
            this.tileCache.clear();
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    ImageTile tile = this.tiles[i][j];
                    this.tileCache.put(tile.id, tile);
                }
            }
        }
    }
}

