/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class LocalZoneIndex {
    private ZoneGrid grid;
    private int xExtent;
    private int xSize;
    private int yExtent;
    private int ySize;
    private int zExtent;
    private int zSize;
    private final int minZoneId = 1;
    private ZoneKey center;
    private ZoneKey[] keyIndex;
    private final Set<ZoneKey> keySet = new HashSet<ZoneKey>();

    public LocalZoneIndex(ZoneGrid grid, int gridRadius) {
        this(grid, gridRadius, gridRadius, gridRadius);
    }

    public LocalZoneIndex(ZoneGrid grid, Vec3i zoneExtents) {
        this(grid, zoneExtents.x, zoneExtents.y, zoneExtents.z);
    }

    public LocalZoneIndex(ZoneGrid grid, int xRadius, int yRadius, int zRadius) {
        this.grid = grid;
        if (grid.getZoneSize().x == 0) {
            xRadius = 0;
        }
        if (grid.getZoneSize().y == 0) {
            yRadius = 0;
        }
        if (grid.getZoneSize().z == 0) {
            zRadius = 0;
        }
        this.xExtent = xRadius;
        this.yExtent = yRadius;
        this.zExtent = zRadius;
        this.xSize = xRadius * 2 + 1;
        this.ySize = yRadius * 2 + 1;
        this.zSize = zRadius * 2 + 1;
        this.keyIndex = new ZoneKey[this.xSize * this.ySize * this.zSize];
    }

    public int getIndexSize() {
        return this.keyIndex.length;
    }

    public int getMinimumZoneId() {
        return 1;
    }

    public ZoneGrid getGrid() {
        return this.grid;
    }

    public ZoneKey getZone(int zoneId) {
        return this.getZone(zoneId, null);
    }

    public ZoneKey getZone(int zoneId, ZoneKey defaultValue) {
        if (zoneId <= 0) {
            return defaultValue;
        }
        if (this.center == null) {
            return defaultValue;
        }
        int index = zoneId - 1;
        if (index >= this.keyIndex.length) {
            throw new IllegalArgumentException("ZoneID out of bounds:" + zoneId + " keyIndex size:" + this.keyIndex.length);
        }
        return this.keyIndex[index];
    }

    public int getZoneId(ZoneKey zone) {
        if (this.center == null) {
            return -1;
        }
        int xBase = this.center.x - this.xExtent;
        int yBase = this.center.y - this.yExtent;
        int zBase = this.center.z - this.zExtent;
        int x = zone.x - xBase;
        int y = zone.y - yBase;
        int z = zone.z - zBase;
        return 1 + z * (this.xSize * this.ySize) + y * this.xSize + x;
    }

    public ZoneKey getCenter() {
        return this.center;
    }

    public boolean setCenter(Vec3d pos, List<ZoneKey> entered, List<ZoneKey> exited) {
        ZoneKey key = this.grid.worldToKey(pos.x, pos.y, pos.z);
        return this.setCenter(key, entered, exited);
    }

    public boolean setCenter(ZoneKey center, List<ZoneKey> entered, List<ZoneKey> exited) {
        if (Objects.equals(this.center, center)) {
            return false;
        }
        exited.clear();
        entered.clear();
        if (this.center != null) {
            exited.addAll(this.keySet);
        }
        this.center = center;
        int index = 0;
        for (int z = center.z - this.zExtent; z <= center.z + this.zExtent; ++z) {
            for (int y = center.y - this.yExtent; y <= center.y + this.yExtent; ++y) {
                for (int x = center.x - this.xExtent; x <= center.x + this.xExtent; ++x) {
                    ZoneKey k;
                    this.keyIndex[index] = k = new ZoneKey(this.grid, x, y, z);
                    ++index;
                    if (!this.keySet.add(k)) continue;
                    entered.add(k);
                }
            }
        }
        this.keySet.clear();
        this.keySet.addAll(Arrays.asList(this.keyIndex));
        Iterator<ZoneKey> it = exited.iterator();
        while (it.hasNext()) {
            if (!this.keySet.contains(it.next())) continue;
            it.remove();
        }
        return true;
    }

    public static void main(String ... args) {
        ZoneGrid grid = new ZoneGrid(32, 32, 32);
        LocalZoneIndex zones = new LocalZoneIndex(grid, 1);
        ArrayList<ZoneKey> entered = new ArrayList<ZoneKey>();
        ArrayList<ZoneKey> exited = new ArrayList<ZoneKey>();
        ZoneKey center = new ZoneKey(grid, 2, 2, 2);
        zones.setCenter(center, entered, exited);
        System.out.println("Entered:" + entered);
        System.out.println("Exited:" + exited);
        for (int i = 0; i < zones.keyIndex.length; ++i) {
            ZoneKey k = zones.keyIndex[i];
            System.out.println("  key[" + i + "] = " + k);
            int zoneId = zones.getZoneId(k);
            System.out.println("      id:" + zoneId + "   relookup:" + zones.getZone(zoneId));
        }
        center = new ZoneKey(grid, 3, 2, 2);
        zones.setCenter(center, entered, exited);
        System.out.println("Entered:" + entered);
        System.out.println("Exited:" + exited);
    }
}

