/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.CheckboxModel;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultCheckboxModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.client.GameSessionState;
import mythruna.client.MythrunaConfig;
import mythruna.client.ui.MapRootComponent;
import mythruna.client.ui.MapViewState;
import mythruna.client.view.AvatarState;
import mythruna.es.MapMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMarkerState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MapMarkerState.class);
    private EntityData ed;
    private EntityId avatarId;
    private MapViewState map;
    private VersionedReference<Vec3d> posRef;
    private VersionedReference<Double> mapRadiusRef;
    private TileId centerId;
    private Label layersLabel;
    private Container layerToggles;
    private boolean layersInvalid;
    private Button cheat;
    private MarkerContainer markers;
    private MapRootComponent mapLayer;
    private Map<String, MarkerLayer> markerLayers = new TreeMap<String, MarkerLayer>();
    private ConcurrentLinkedQueue<Marker> dirty = new ConcurrentLinkedQueue();
    private Quad iconTemplate;
    private boolean showAllMarkers;

    protected void initialize(Application app) {
        log.info("initialize()");
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.map = (MapViewState)this.getState(MapViewState.class);
        log.info("map:" + this.map);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.avatarId = sessionState.getGameSession().getAvatar();
        this.markers = new MarkerContainer(this.ed);
        this.mapLayer = new MapRootComponent("markers");
        this.map.addLayer(this.mapLayer);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.mapRadiusRef = this.map.getWorldRadiusRef();
        this.centerId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()));
        float iconSize = 2.0f;
        float halfSize = iconSize * 0.5f;
        this.iconTemplate = new Quad(iconSize, iconSize);
        this.iconTemplate.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-halfSize, -halfSize, 0.0f, halfSize, -halfSize, 0.0f, halfSize, halfSize, 0.0f, -halfSize, halfSize, 0.0f});
        this.layersLabel = new Label("Layers:");
        this.layerToggles = new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.First));
        this.map.addRightPanel((Panel)this.layerToggles);
        this.cheat = new Button("Debug");
        this.cheat.addClickCommands(s -> {
            this.showAllMarkers = !this.showAllMarkers;
            this.updateFilters();
        });
        this.showAllMarkers = MythrunaConfig.getInstance().getStartupSetting("markers.cheat", false);
        this.updateFilters();
    }

    protected void cleanup(Application app) {
        log.info("cleanup()");
        this.map.removeRightPanel((Panel)this.layerToggles);
    }

    protected void onEnable() {
        log.info("onEnable()");
        this.markers.start();
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.markers.stop();
    }

    public void update(float tpf) {
        TileId tileId;
        boolean viewChanged = false;
        if (this.posRef.update() && (tileId = TileId.fromWorld((Vec3d)((Vec3d)this.posRef.get()))).getId() != this.centerId.getId()) {
            this.centerId = tileId;
            viewChanged = true;
        }
        if (this.mapRadiusRef.update()) {
            viewChanged = true;
        }
        if (viewChanged) {
            this.updateFilters();
        }
        this.markers.update();
        if (this.map.isEnabled()) {
            this.updatePositions();
        }
        if (this.layersInvalid) {
            this.updateLayers();
        }
    }

    protected void updateLayers() {
        this.layerToggles.clearChildren();
        this.layerToggles.addChild((Node)this.layersLabel, new Object[0]);
        for (MarkerLayer layer : this.markerLayers.values()) {
            this.layerToggles.addChild((Node)layer.checkbox, new Object[0]);
        }
        this.layerToggles.addChild((Node)this.cheat, new Object[0]);
    }

    protected void updateFilters() {
        ComponentFilter tileFilter;
        log.info("updateFilters() tile:" + this.centerId + "  radius:" + this.mapRadiusRef.get());
        Vec3i center = this.centerId.getWorld(null);
        int radius = (int)Math.round((Double)this.mapRadiusRef.get() / 1024.0);
        int size = radius * 2 + 1;
        log.info(" filter array size:" + size * size);
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int index = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Vec3i loc = center.add(x * 1024, 0, z * 1024);
                TileId neighbor = TileId.fromWorld((Vec3i)loc);
                ComponentFilter filter = Filters.fieldEquals(MapMarker.class, (String)"tileId", (Object)neighbor.getId());
                filters[index++] = filter;
            }
        }
        ComponentFilter finalFilter = tileFilter = Filters.or(MapMarker.class, (ComponentFilter[])filters);
        if (!this.showAllMarkers) {
            this.cheat.setText("Enable Markers Cheat");
            ComponentFilter us = Filters.fieldEquals(MapMarker.class, (String)"owner", (Object)this.avatarId);
            ComponentFilter empty = Filters.fieldEquals(MapMarker.class, (String)"owner", null);
            int townId = this.ed.getStrings().getStringId("Town", false);
            ComponentFilter towns = Filters.fieldEquals(MapMarker.class, (String)"typeId", (Object)townId);
            finalFilter = Filters.and(MapMarker.class, (ComponentFilter[])new ComponentFilter[]{tileFilter, Filters.or(MapMarker.class, (ComponentFilter[])new ComponentFilter[]{us, empty, towns})});
        } else {
            this.cheat.setText("Disable Markers Cheat");
        }
        this.markers.setFilter(finalFilter);
    }

    protected void updatePositions() {
        Vec3d worldCenter = (Vec3d)this.posRef.get();
        double radius = (Double)this.mapRadiusRef.get();
        double scale = this.mapLayer.getWorldToLocalScale();
        for (Marker m : this.markers.getArray()) {
            m.updatePosition(worldCenter, radius, scale);
        }
    }

    protected Icon getIcon(String type) {
        String resource = "Interface/markers/marker-round.png";
        ColorRGBA color = ColorRGBA.Blue;
        float labelScale = 0.075f;
        float iconScale = 1.0f;
        if ("spawn".equals(type)) {
            color = new ColorRGBA(0.8f, 0.8f, 0.2f, 1.0f);
            labelScale = 0.4f;
            iconScale = 4.0f;
        } else if ("claim".equals(type)) {
            color = new ColorRGBA(0.8f, 0.7f, 0.2f, 1.0f);
            labelScale = 0.1f;
        } else if ("dungeon-entrance".equals(type)) {
            color = new ColorRGBA(0.8f, 0.2f, 0.2f, 1.0f);
            labelScale = 0.025f;
        } else if ("quest-area".equals(type)) {
            resource = "Interface/markers/drawn-ring.png";
            labelScale = 0.0125f;
            color = new ColorRGBA(0.6f, 0.5f, 0.5f, 1.0f);
        }
        Texture texture = this.getApplication().getAssetManager().loadTexture(resource);
        GuiMaterial material = GuiGlobals.getInstance().createMaterial(color, false);
        material.setTexture(texture);
        Mesh quad = this.iconTemplate.clone();
        Geometry geom = new Geometry(type, quad);
        Material mat = material.getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setMaterial(mat);
        geom.setLocalScale(iconScale);
        Node node = new Node(type + ":holder");
        node.attachChild((Spatial)geom);
        return new Icon(this, (Spatial)node, labelScale);
    }

    protected MarkerLayer getMarkerLayer(String type, boolean create) {
        MarkerLayer result = this.markerLayers.get(type);
        if (result == null && create) {
            result = new MarkerLayer(type, true);
            this.markerLayers.put(type, result);
            this.layersInvalid = true;
        }
        return result;
    }

    private class MarkerContainer
    extends EntityContainer<Marker> {
        public MarkerContainer(EntityData ed) {
            super(ed, new Class[]{MapMarker.class, Name.class, SpawnPosition.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public Marker[] getArray() {
            return (Marker[])super.getArray();
        }

        protected Marker addObject(Entity entity) {
            Marker result = new Marker(entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(Marker marker, Entity entity) {
            marker.update(entity);
        }

        protected void removeObject(Marker marker, Entity entity) {
            marker.release();
        }
    }

    private class MarkerLayer
    extends DefaultCheckboxModel {
        private String type;
        private boolean visible;
        private Node root;
        private List<Marker> list = new ArrayList<Marker>();
        private Checkbox checkbox;

        public MarkerLayer(String type, boolean visible) {
            this.type = type;
            this.visible = visible;
            this.root = new Node("layer:" + type);
            this.resetVisible();
            this.checkbox = new Checkbox(type + " (0)", (CheckboxModel)this);
            super.setChecked(visible);
        }

        protected void resetLabel() {
            this.checkbox.setText(this.type + " (" + this.list.size() + ")");
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
            this.setVisible(checked);
        }

        public void setVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            this.resetVisible();
        }

        protected void resetVisible() {
            if (this.visible) {
                MapMarkerState.this.mapLayer.getLayerRoot().attachChild((Spatial)this.root);
            } else {
                this.root.removeFromParent();
            }
        }

        public void addMarker(Marker marker) {
            this.list.add(marker);
            this.root.attachChild((Spatial)marker.node);
            this.resetLabel();
        }

        public void removeMarker(Marker marker) {
            if (this.list.remove(marker)) {
                this.root.detachChild((Spatial)marker.node);
                this.resetLabel();
            }
        }
    }

    private class Marker {
        private Entity entity;
        private MapMarker info;
        private String type;
        private Node node;
        private Label label;
        private Icon icon;
        private Vec3d pos;
        private Quatd orientation;

        public Marker(Entity entity) {
            this.entity = entity;
            this.node = new Node("marker:" + entity.getId());
            this.label = new Label("NA", new ElementId("map.marker.label"));
            this.node.attachChild((Spatial)this.label);
        }

        public void update(Entity entity) {
            this.pos = ((SpawnPosition)entity.get(SpawnPosition.class)).getLocation();
            this.orientation = ((SpawnPosition)entity.get(SpawnPosition.class)).getOrientation();
            String name = ((Name)entity.get(Name.class)).getName();
            if (!Objects.equals(name, this.label.getText())) {
                this.label.setText(name);
                Vector3f size = this.label.getSize();
                this.label.setLocalTranslation(-size.x * 0.5f, 0.0f, 0.0f);
            }
            this.info = (MapMarker)entity.get(MapMarker.class);
            this.updateType(this.info.getTypeName(MapMarkerState.this.ed));
        }

        protected void updateType(String type) {
            MarkerLayer layer;
            if (Objects.equals(this.type, type)) {
                return;
            }
            if (this.icon != null) {
                this.icon.spatial.removeFromParent();
            }
            if (this.type != null && (layer = MapMarkerState.this.getMarkerLayer(this.type, false)) != null) {
                layer.removeMarker(this);
            }
            this.type = type;
            this.icon = MapMarkerState.this.getIcon(type);
            this.node.attachChild(this.icon.spatial);
            MapMarkerState.this.getMarkerLayer(type, true).addMarker(this);
        }

        public void updatePosition(Vec3d worldCenter, double radius, double worldToLocalScale) {
            if (this.pos == null) {
                return;
            }
            double guiScale = worldToLocalScale;
            Vec3d local = this.pos.subtract(worldCenter);
            local.multLocal(worldToLocalScale);
            this.node.setLocalTranslation((float)local.x, (float)(-local.z), 10.0f);
            double labelScale = (double)this.info.getSize() * guiScale * (double)this.icon.labelScale;
            double iconScale = (double)this.info.getSize() * guiScale;
            if (labelScale > 2.0) {
                labelScale = 2.0;
            }
            Vector3f size = this.label.getSize();
            float labelExtent = this.icon != null ? (float)((double)size.x * labelScale * 0.5) : (float)((double)size.x * guiScale * 0.5);
            this.label.setLocalTranslation(-labelExtent, 0.0f, 0.0f);
            if (this.icon != null) {
                this.label.setLocalScale((float)labelScale);
                this.icon.spatial.setLocalScale((float)iconScale);
            } else {
                this.label.setLocalScale((float)guiScale);
            }
            Vector3f v = this.node.getLocalTranslation();
            boolean labelVisible = true;
            boolean iconVisible = true;
            float viewRadius = MapMarkerState.this.mapLayer.getLayerSize().x * 0.5f;
            if (v.x - labelExtent < -viewRadius) {
                labelVisible = false;
            }
            if (v.x < -viewRadius) {
                iconVisible = false;
            }
            if (v.x + labelExtent > viewRadius) {
                labelVisible = false;
            }
            if (v.x > viewRadius) {
                iconVisible = false;
            }
            if (v.y < -viewRadius) {
                labelVisible = false;
                iconVisible = false;
            }
            if (v.y > viewRadius) {
                labelVisible = false;
                iconVisible = false;
            }
            if (labelVisible) {
                this.label.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.label.setCullHint(Spatial.CullHint.Always);
            }
            if (iconVisible) {
                this.icon.spatial.setCullHint(Spatial.CullHint.Inherit);
            } else {
                this.icon.spatial.setCullHint(Spatial.CullHint.Always);
            }
        }

        public void release() {
            MarkerLayer layer;
            this.node.removeFromParent();
            if (this.type != null && (layer = MapMarkerState.this.getMarkerLayer(this.type, false)) != null) {
                layer.removeMarker(this);
            }
        }
    }

    private class Icon {
        Spatial spatial;
        float labelScale;

        public Icon(MapMarkerState mapMarkerState, Spatial spatial, float labelScale) {
            this.spatial = spatial;
            this.labelScale = labelScale;
        }
    }

    private class MarkerType {
        private MarkerType(MapMarkerState mapMarkerState) {
        }
    }
}

