/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mythruna.es.EncounterTrigger;
import mythruna.sim.GameActionSystem;
import mythruna.sim.ai.ActivationZoneListener;
import mythruna.sim.ai.AgentActivationSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobEncounterSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MobEncounterSystem.class);
    private EntityData ed;
    private AgentActivationSystem activationSystem;
    private ZoneObserver zoneObserver = new ZoneObserver();
    private GameActionSystem gameActions;
    private Map<EntityId, Encounter> encounterIndex = new HashMap<EntityId, Encounter>();
    private EncounterTriggerContainer triggers;
    private Set<Long> activeZones = new HashSet<Long>();
    private boolean filterInvalid = true;
    private Thread gameThread;

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.activationSystem = (AgentActivationSystem)((Object)this.getSystem(AgentActivationSystem.class, true));
        this.activationSystem.addActivationZoneListener(this.zoneObserver);
        this.gameActions = (GameActionSystem)((Object)this.getSystem(GameActionSystem.class, true));
        this.gameThread = Thread.currentThread();
    }

    protected void terminate() {
        this.activationSystem.removeActivationZoneListener(this.zoneObserver);
    }

    public void start() {
        this.triggers = new EncounterTriggerContainer(this.ed);
        this.triggers.start();
    }

    public void update(SimTime time) {
        if (this.filterInvalid) {
            this.recalculateFilter();
        }
        this.triggers.update();
    }

    public void stop() {
        this.triggers.stop();
        this.triggers = null;
    }

    protected Encounter getEncounter(EntityId entityId, boolean create) {
        Encounter result = this.encounterIndex.get(entityId);
        if (result == null && create) {
            result = new Encounter(entityId);
            this.encounterIndex.put(entityId, result);
        }
        return result;
    }

    protected Encounter acquireEncounter(EntityId entityId) {
        Encounter encounter = this.getEncounter(entityId, true);
        encounter.acquire();
        return encounter;
    }

    protected void releaseEncounter(EntityId entityId) {
        Encounter encounter = this.encounterIndex.get(entityId);
        if (encounter == null) {
            return;
        }
        if (encounter.release()) {
            this.encounterIndex.remove(entityId);
        }
    }

    protected void addActiveZone(long zoneId) {
        if (log.isTraceEnabled()) {
            log.trace("activateZone(" + zoneId + ")");
        }
        assert (Thread.currentThread() == this.gameThread);
        if (this.activeZones.add(zoneId)) {
            this.filterInvalid = true;
        }
    }

    protected void removeActiveZone(long zoneId) {
        if (log.isTraceEnabled()) {
            log.trace("deactivateZone(" + zoneId + ")");
        }
        assert (Thread.currentThread() == this.gameThread);
        if (this.activeZones.remove(zoneId)) {
            this.filterInvalid = true;
        }
    }

    protected void recalculateFilter() {
        if (log.isTraceEnabled()) {
            log.trace("recalculateFilter() zone count:" + this.activeZones.size());
        }
        this.filterInvalid = false;
        if (this.activeZones.isEmpty()) {
            ComponentFilter<EncounterTrigger> f1 = EncounterTrigger.zoneFilter(1L);
            ComponentFilter<EncounterTrigger> f2 = EncounterTrigger.zoneFilter(0L);
            this.triggers.setFilter(Filters.and(EncounterTrigger.class, (ComponentFilter[])new ComponentFilter[]{f1, f2}));
            return;
        }
        ComponentFilter[] filterArray = new ComponentFilter[this.activeZones.size()];
        int index = 0;
        for (Long zoneId : this.activeZones) {
            filterArray[index++] = EncounterTrigger.zoneFilter(zoneId);
        }
        this.triggers.setFilter(Filters.or(EncounterTrigger.class, (ComponentFilter[])filterArray));
    }

    private class ZoneObserver
    implements ActivationZoneListener {
        private ZoneObserver() {
        }

        @Override
        public void activateZone(long zoneId) {
            MobEncounterSystem.this.gameActions.spool(() -> MobEncounterSystem.this.addActiveZone(zoneId));
        }

        @Override
        public void deactivateZone(long zoneId) {
            MobEncounterSystem.this.gameActions.spool(() -> MobEncounterSystem.this.removeActiveZone(zoneId));
        }
    }

    private class EncounterTriggerContainer
    extends EntityContainer<Trigger> {
        public EncounterTriggerContainer(EntityData ed) {
            super(ed, new Class[]{EncounterTrigger.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected Trigger addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("addTrigger(" + e + ")");
            }
            Trigger trigger = new Trigger(e);
            this.updateObject(trigger, e);
            return trigger;
        }

        protected void updateObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateTrigger(" + object + ", " + e + ")");
            }
            object.update();
        }

        protected void removeObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("removeTrigger(" + object + ", " + e + ")");
            }
            object.release();
        }
    }

    private class Encounter {
        private EntityId entityId;
        private int useCount;
        private boolean valid;

        public Encounter(EntityId entityId) {
            this.entityId = entityId;
            boolean bl = this.valid = MobEncounterSystem.this.gameActions.getType(entityId).findAction("activateEncounter", new Object[0]) != null;
            if (!this.valid) {
                log.warn("Encounter entity:" + entityId + " is not a valid encounter type:" + MobEncounterSystem.this.gameActions.getType(entityId));
            }
        }

        public void acquire() {
            if (log.isTraceEnabled()) {
                log.trace("acquire():" + this.entityId);
            }
            ++this.useCount;
            if (this.useCount == 1 && this.valid) {
                MobEncounterSystem.this.gameActions.runAction(this.entityId, "activateEncounter", new Object[0]);
            }
        }

        public boolean release() {
            if (log.isTraceEnabled()) {
                log.trace("release():" + this.entityId);
            }
            --this.useCount;
            if (this.useCount < 0) {
                log.warn("Use count went below 0 for:" + this.entityId);
            }
            if (this.useCount == 0 && this.valid) {
                MobEncounterSystem.this.gameActions.runAction(this.entityId, "deactivateEncounter", new Object[0]);
            }
            return this.useCount <= 0;
        }
    }

    private class Trigger {
        private Entity entity;
        private EncounterTrigger lastTrigger;
        private Encounter encounter;

        public Trigger(Entity entity) {
            this.entity = entity;
        }

        public void update() {
            EncounterTrigger t = (EncounterTrigger)this.entity.get(EncounterTrigger.class);
            if (Objects.equals(t, this.lastTrigger)) {
                return;
            }
            if (this.lastTrigger != null) {
                MobEncounterSystem.this.releaseEncounter(this.lastTrigger.getEncounterId());
            }
            this.lastTrigger = t;
            if (this.lastTrigger != null) {
                this.encounter = MobEncounterSystem.this.acquireEncounter(this.lastTrigger.getEncounterId());
            }
        }

        public void release() {
            if (this.lastTrigger != null) {
                MobEncounterSystem.this.releaseEncounter(this.lastTrigger.getEncounterId());
            }
        }
    }
}

