/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.encounter;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.DynArray;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.World;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import mythruna.sim.encounter.Encounter;
import mythruna.sim.encounter.EncounterGenerator;
import mythruna.sim.encounter.Zone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncounterSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(EncounterSystem.class);
    private World world;
    private EntityData ed;
    private int userRadius = 1;
    private ConcurrentLinkedQueue<EntityId> toAdd = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<EntityId> toRemove = new ConcurrentLinkedQueue();
    private Map<EntityId, ZoneUser> userIndex = new HashMap<EntityId, ZoneUser>();
    private DynArray<ZoneUser> users = new DynArray(ZoneUser.class);
    private Map<LeafId, ZoneImpl> zoneIndex = new HashMap<LeafId, ZoneImpl>();
    private DynArray<ZoneImpl> zones = new DynArray(ZoneImpl.class);
    private DynArray<Consumer> zoneInitializers = new DynArray(Consumer.class);

    public Consumer<Zone> addZoneInitializer(Consumer<Zone> initializer) {
        this.zoneInitializers.add(initializer);
        return initializer;
    }

    public void removeZoneInitializer(Consumer<Zone> initializer) {
        this.zoneInitializers.remove(initializer);
    }

    protected void initialize() {
        this.world = (World)this.getSystem(World.class, true);
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
    }

    protected void terminate() {
    }

    public void start() {
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{PlayerEntityEvent.playerEntityJoined, PlayerEntityEvent.playerEntityLeft});
    }

    public void stop() {
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{PlayerEntityEvent.playerEntityJoined, PlayerEntityEvent.playerEntityLeft});
    }

    public void update(SimTime time) {
        this.updateZoneUsers(time);
        this.expireZones();
        for (ZoneImpl zone : (ZoneImpl[])this.zones.getArray()) {
            zone.update(time);
        }
    }

    protected void playerEntityJoined(PlayerEntityEvent event) {
        log.info("playerEntityJoined(" + event + ")");
        this.toAdd.add(event.getPlayer());
    }

    protected void playerEntityLeft(PlayerEntityEvent event) {
        log.info("playerEntityLeft(" + event + ")");
        this.toRemove.add(event.getPlayer());
    }

    protected void addZoneUser(EntityId entityId) {
        log.info("addZoneUser(" + entityId + ")");
        ZoneUser existing = this.userIndex.get(entityId);
        if (existing != null) {
            this.removeZoneUser(entityId);
        }
        ZoneUser user = new ZoneUser(entityId);
        this.userIndex.put(entityId, user);
        this.users.add((Object)user);
    }

    protected void removeZoneUser(EntityId entityId) {
        log.info("removeZoneUser(" + entityId + ")");
        ZoneUser user = this.userIndex.remove(entityId);
        if (user == null) {
            log.info("No zone user found for:" + entityId);
            return;
        }
        this.users.remove((Object)user);
        user.release();
    }

    protected void updateZoneUsers(SimTime time) {
        EntityId id;
        while (!this.toAdd.isEmpty()) {
            id = this.toAdd.poll();
            this.addZoneUser(id);
        }
        while (!this.toRemove.isEmpty()) {
            id = this.toRemove.poll();
            this.removeZoneUser(id);
        }
        for (ZoneUser user : (ZoneUser[])this.users.getArray()) {
            user.update(time);
        }
    }

    protected Collection<LeafId> getNeighbors(LeafId center, int radius) {
        ArrayList<LeafId> results = new ArrayList<LeafId>();
        Vec3i loc = center.getWorld(null);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    double elevation = loc.y - y * 32;
                    if (elevation < 0.0 || elevation >= (double)this.world.getMaxY()) continue;
                    results.add(LeafId.fromWorld((double)(loc.x - x * 32), (double)elevation, (double)(loc.z - z * 32)));
                }
            }
        }
        return results;
    }

    protected ZoneImpl getZone(LeafId zoneId, boolean create) {
        ZoneImpl zone = this.zoneIndex.get(zoneId);
        if (zone == null && create) {
            zone = new ZoneImpl(zoneId);
            this.zoneIndex.put(zoneId, zone);
            this.zones.add((Object)zone);
        }
        return zone;
    }

    protected void expireZones() {
        for (ZoneImpl zone : (ZoneImpl[])this.zones.getArray()) {
            if (!zone.isInactive()) continue;
            zone.release();
        }
    }

    private class ZoneUser {
        EntityId entityId;
        BodyPosition pos;
        LeafId zoneId;
        Set<LeafId> neighbors = new HashSet<LeafId>();

        public ZoneUser(EntityId entityId) {
            this.entityId = entityId;
        }

        public void update(SimTime time) {
            if (this.pos == null) {
                this.pos = (BodyPosition)EncounterSystem.this.ed.getComponent(this.entityId, BodyPosition.class);
            }
            if (this.pos == null) {
                log.warn(this.entityId + " has no BodyPosition");
                return;
            }
            boolean zoneChanged = false;
            Vec3d loc = this.pos.getLastLocation();
            if (loc == null) {
                log.warn(this.entityId + " has no location");
                return;
            }
            LeafId locZone = LeafId.fromWorld((Vec3d)loc);
            if (!Objects.equals(locZone, this.zoneId)) {
                this.updateZone(locZone);
            }
        }

        protected void updateZone(LeafId newZone) {
            if (log.isTraceEnabled()) {
                log.trace(this.entityId + " -> zone:" + newZone);
            }
            this.zoneId = newZone;
            HashSet<LeafId> removed = new HashSet<LeafId>(this.neighbors);
            for (LeafId n : EncounterSystem.this.getNeighbors(this.zoneId, EncounterSystem.this.userRadius)) {
                removed.remove(n);
                if (!this.neighbors.add(n)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("new zone:" + n);
                }
                EncounterSystem.this.getZone(n, true).addUser(this);
            }
            for (LeafId n : removed) {
                if (log.isTraceEnabled()) {
                    log.trace("left zone:" + n);
                }
                this.neighbors.remove(n);
                ZoneImpl zone = EncounterSystem.this.getZone(n, false);
                if (zone != null) {
                    zone.removeUser(this);
                    continue;
                }
                log.warn("User:" + this.entityId + " refers to unloaded zone:" + n);
            }
        }

        public void release() {
            for (LeafId n : this.neighbors) {
                ZoneImpl zone = EncounterSystem.this.getZone(n, false);
                if (zone != null) {
                    zone.removeUser(this);
                    continue;
                }
                log.warn("User:" + this.entityId + " refers to unloaded zone:" + n);
            }
        }
    }

    private class ZoneImpl
    implements Zone {
        private LeafId zoneId;
        private Set<ZoneUser> zoneUsers = new HashSet<ZoneUser>();
        private DynArray<EncounterGenerator> generators;
        private Map<Class, Object> attributes = new HashMap<Class, Object>();
        private Map<String, Encounter> active = new HashMap<String, Encounter>();

        public ZoneImpl(LeafId zoneId) {
            this.zoneId = zoneId;
        }

        protected void initialize() {
            this.generators = new DynArray(EncounterGenerator.class);
            for (Consumer init : (Consumer[])EncounterSystem.this.zoneInitializers.getArray()) {
                init.accept(this);
            }
        }

        @Override
        public void activate(String encounterId, Encounter encounter) {
            this.active.put(encounterId, encounter);
        }

        @Override
        public void deactivate(String encounterId) {
            this.active.remove(encounterId);
        }

        @Override
        public boolean isActive(String encounterId, int radius) {
            if (this.active.containsKey(encounterId)) {
                return true;
            }
            if (radius <= 0) {
                return false;
            }
            for (LeafId id : EncounterSystem.this.getNeighbors(this.zoneId, radius)) {
                ZoneImpl neighbor;
                if (Objects.equals(id, this.zoneId) || (neighbor = EncounterSystem.this.getZone(id, false)) == null || !neighbor.active.containsKey(encounterId)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Encounter getActiveNeighbor(String encounterId, int radius) {
            Encounter result = this.active.get(encounterId);
            if (result != null) {
                return result;
            }
            if (radius <= 0) {
                return null;
            }
            for (LeafId id : EncounterSystem.this.getNeighbors(this.zoneId, radius)) {
                ZoneImpl neighbor;
                if (Objects.equals(id, this.zoneId) || (neighbor = EncounterSystem.this.getZone(id, false)) == null || (result = neighbor.active.get(encounterId)) == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public LeafId getZoneId() {
            return this.zoneId;
        }

        @Override
        public void addGenerator(EncounterGenerator gen) {
            this.generators.add((Object)gen);
        }

        @Override
        public void removeGenerator(EncounterGenerator gen) {
            this.generators.remove((Object)gen);
        }

        @Override
        public <T> T get(Class<T> type) {
            return type.cast(this.attributes.get(type));
        }

        @Override
        public <T> void set(Class<T> type, T value) {
            this.attributes.put(type, value);
        }

        protected void addUser(ZoneUser user) {
            this.zoneUsers.add(user);
        }

        protected void removeUser(ZoneUser user) {
            this.zoneUsers.remove(user);
        }

        protected boolean isInactive() {
            return this.zoneUsers.isEmpty();
        }

        public void release() {
            if (log.isTraceEnabled()) {
                log.trace("Releasing zone:" + this.zoneId);
            }
            EncounterSystem.this.zoneIndex.remove(this.zoneId);
            EncounterSystem.this.zones.remove((Object)this);
            for (EncounterGenerator gen : (EncounterGenerator[])this.generators.getArray()) {
                gen.release();
            }
        }

        protected void update(SimTime time) {
            if (this.generators == null) {
                this.initialize();
            }
            for (EncounterGenerator gen : (EncounterGenerator[])this.generators.getArray()) {
                try {
                    gen.update(time);
                }
                catch (RuntimeException e) {
                    log.info("all active zones:" + EncounterSystem.this.zones);
                    throw e;
                }
            }
        }

        public String toString() {
            return "Zone[" + this.zoneId + "]";
        }
    }
}

