/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.db.ObjectDb;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.Initializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mythruna.world.tile.FeatureRegistry;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.Workspace;
import mythruna.world.tile.WorkspaceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedectileManager {
    static Logger log = LoggerFactory.getLogger(SedectileManager.class);
    private FeatureRegistry features;
    private SedectileDb sedectileDb;
    private List<WorkspaceFunction> sedectileFunctions = new ArrayList<WorkspaceFunction>();
    private WorkspaceFunction[] functionArray;
    private boolean initialized;
    private LoadingCache<SedectileId, Sedectile> cache;

    public SedectileManager(File root, WorkspaceFunction ... functions) {
        this.features = new FeatureRegistry(root);
        this.sedectileDb = new SedectileDb(this, root);
        this.sedectileFunctions.addAll(Arrays.asList(functions));
        this.cache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<SedectileId, Sedectile>(this){

            public void onRemoval(RemovalNotification<SedectileId, Sedectile> notification) {
                if (log.isTraceEnabled()) {
                    log.trace("cacheRemoval(" + notification + ") reason:" + notification.getCause());
                }
            }
        }).build((CacheLoader)new CacheLoader<SedectileId, Sedectile>(){

            public Sedectile load(SedectileId id) {
                return SedectileManager.this.loadSedectile(id);
            }
        });
    }

    public void addWorkspaceFunction(WorkspaceFunction f) {
        this.sedectileFunctions.add(f);
        this.functionArray = null;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        log.info("initialize()");
        this.features.initialize();
        this.sedectileDb.initialize();
        for (WorkspaceFunction f : this.getFunctions()) {
            if (!(f instanceof Initializer)) continue;
            try {
                ((Initializer)f).initialize();
            }
            catch (Exception e) {
                log.error("Error closing:" + f, (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public void terminate() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        log.info("terminate()");
        for (WorkspaceFunction f : this.getFunctions()) {
            if (!(f instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)f)).close();
            }
            catch (Exception e) {
                log.error("Error closing:" + f, (Throwable)e);
            }
        }
        this.sedectileDb.terminate();
        this.features.terminate();
        this.initialized = false;
    }

    public Sedectile getSedectile(SedectileId id) {
        if (log.isTraceEnabled()) {
            log.trace("getSedectile(" + id + ")");
        }
        return (Sedectile)this.cache.getUnchecked((Object)id);
    }

    public Sedectile getSedectileIfExists(SedectileId id) {
        if (log.isTraceEnabled()) {
            log.trace("getSedectile(" + id + ")");
        }
        return (Sedectile)this.cache.getIfPresent((Object)id);
    }

    public FeatureRegistry getFeatures() {
        return this.features;
    }

    protected WorkspaceFunction[] getFunctions() {
        if (this.functionArray != null) {
            return this.functionArray;
        }
        this.functionArray = this.sedectileFunctions.toArray(new WorkspaceFunction[0]);
        return this.functionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sedectile loadSedectile(SedectileId id) {
        Sedectile result;
        if (log.isTraceEnabled()) {
            log.trace("loadSedectile(" + id + "):" + id.getWorld(null));
        }
        if ((result = (Sedectile)this.sedectileDb.get(id)).isComplete()) {
            if (log.isTraceEnabled()) {
                log.trace("Sedectile is already complete:" + id);
            }
            return result;
        }
        SedectileManager sedectileManager = this;
        synchronized (sedectileManager) {
            if (result.isComplete()) {
                return result;
            }
            log.info("Building sedectile with new workspace centered on:" + id + "  loc:" + id.getWorld(null));
            Workspace workspace = new Workspace(result, 2, this.features, (ObjectDb<SedectileId, Sedectile>)this.sedectileDb);
            for (WorkspaceFunction f : this.getFunctions()) {
                f.accept(workspace);
            }
            workspace.close();
        }
        return result;
    }

    private class SedectileDb
    extends SpoolingObjectDb<SedectileId, Sedectile> {
        private File root;
        private byte zipMarker = (byte)66;
        private int version = 0;

        public SedectileDb(SedectileManager sedectileManager, File root) {
            super("Sedectiles");
            this.root = root;
        }

        protected File getFile(SedectileId key) {
            String name;
            File result;
            Vec3i cell = key.getCell(null);
            String path = cell.y + "/" + cell.x + "/" + cell.z;
            File dir = new File(this.root, path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(result = new File(dir, name = key.getId() + ".sedectile")).getParentFile().exists()) {
                result.getParentFile().mkdirs();
            }
            return result;
        }

        protected ObjectOutputStream createOutputStream(File f) throws IOException {
            FileOutputStream fOut = new FileOutputStream(f);
            fOut.write(this.zipMarker);
            BufferedOutputStream bos = new BufferedOutputStream(new GZIPOutputStream(fOut));
            return new ObjectOutputStream(bos);
        }

        protected ObjectInputStream createInputStream(File f) throws IOException {
            FileInputStream fIn = new FileInputStream(f);
            int marker = fIn.read();
            if (marker != this.zipMarker) {
                throw new RuntimeException("Marker mismatch in:" + f + " Expected:" + this.zipMarker + " Found:" + marker);
            }
            BufferedInputStream bin = new BufferedInputStream(new GZIPInputStream(fIn));
            return new ObjectInputStream(bin);
        }

        protected void storeObject(SedectileId key, Sedectile value) {
            try (ObjectOutputStream out = this.createOutputStream(this.getFile(key));){
                out.writeInt(this.version);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Error storing value for:" + key, e);
            }
        }

        protected Sedectile loadObject(SedectileId key) {
            Sedectile sedectile;
            block10: {
                File f = this.getFile(key);
                if (!f.exists()) {
                    return new Sedectile(key);
                }
                ObjectInputStream in = this.createInputStream(f);
                try {
                    int fileVersion = in.readInt();
                    if (fileVersion != this.version) {
                        throw new RuntimeException("Version mismatch for:" + key + " read:" + fileVersion + " expected:" + this.version);
                    }
                    sedectile = (Sedectile)in.readObject();
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException("Error reading value for:" + key + " from:" + f, e);
                    }
                }
                in.close();
            }
            return sedectile;
        }
    }
}

