/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.state.AppState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateTiming {
    private static final Logger logger = Logger.getLogger(StateTiming.class.getName());
    private final Map<AppState, TimingInfo> timingIndex = new LinkedHashMap<AppState, TimingInfo>();
    private long frameStart;
    private long frameEnd;
    private long timingCheckThresholdNanos = 50000000L;

    public void setTimingCheckThreshold(long checkMs) {
        this.timingCheckThresholdNanos = checkMs * 1000000L;
    }

    public long getTimingCheckThreshold() {
        return this.timingCheckThresholdNanos / 1000000L;
    }

    public void startFrame() {
        this.frameStart = System.nanoTime();
    }

    public void endFrame() {
        this.frameEnd = System.nanoTime();
        this.checkTiming(this.frameStart, this.frameEnd);
    }

    protected void checkTiming(long start, long end) {
        long delta = end - start;
        if (delta > this.timingCheckThresholdNanos) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<AppState, TimingInfo> e : this.timingIndex.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getValue() + " : " + e.getKey());
            }
            logger.log(Level.WARNING, String.format("Update loop exceeds %d ms, at: %.03f ms  System info: %s", this.getTimingCheckThreshold(), (double)delta / 1000000.0, sb));
        }
    }

    public TimingInfo trackUpdate(AppState state) {
        return this.getTiming(state, true).open();
    }

    public Map<AppState, TimingInfo> getAllTimingInfo() {
        return this.timingIndex;
    }

    public void remove(AppState state) {
        this.timingIndex.remove(state);
    }

    protected TimingInfo getTiming(AppState state, boolean create) {
        TimingInfo result = this.timingIndex.get(state);
        if (result == null && create) {
            result = new TimingInfo(state);
            this.timingIndex.put(state, result);
        }
        return result;
    }

    public static class TimingInfo
    implements AutoCloseable {
        private final AppState state;
        private long start;
        private long stop;

        public TimingInfo(AppState state) {
            this.state = state;
        }

        protected TimingInfo open() {
            this.start = System.nanoTime();
            return this;
        }

        @Override
        public void close() {
            this.stop = System.nanoTime();
        }

        public long getDurationNanos() {
            return this.stop - this.start;
        }

        public double getDurationMillis() {
            return (double)this.getDurationNanos() / 1000000.0;
        }

        public String toString() {
            return String.format("%.03f ms", this.getDurationMillis());
        }
    }
}

