/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.MemoryUtils;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.state.DebugHudState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDebugState
extends BaseAppState {
    public static String HEAP = "Heap";
    public static String DIRECT = "Direct";
    private static float BYTE_TO_MB = 9.536743E-7f;
    static Logger log = LoggerFactory.getLogger(MemoryDebugState.class);
    private DebugHudState hud;
    private DebugHudState.Location location = DebugHudState.Location.Right;
    private boolean detailedStats;
    private boolean includeDirectMem;
    private float updateInterval;
    private float nextUpdate;
    private VersionedHolder<String> heap;
    private long lastHeapUsage;
    private long lastHeapTotal;
    private VersionedHolder<String> direct;
    private long lastDirectUsage;
    private long lastDirectTotal;

    public MemoryDebugState() {
        this(DebugHudState.Location.Right, 1.0f, false, false);
    }

    public MemoryDebugState(DebugHudState.Location location, float updateInterval, boolean detailedStats, boolean includeDirectMem) {
        this.location = location;
        this.updateInterval = updateInterval;
        this.detailedStats = detailedStats;
        this.includeDirectMem = includeDirectMem;
    }

    public void setDetailedStats(boolean detailedStats) {
        this.detailedStats = detailedStats;
        this.lastHeapUsage = 0L;
        this.lastDirectUsage = 0L;
        this.nextUpdate = 0.0f;
    }

    public boolean getDetailedStats() {
        return this.detailedStats;
    }

    protected void initialize(Application app) {
        this.hud = (DebugHudState)this.getState(DebugHudState.class);
        if (this.hud == null) {
            throw new RuntimeException("MemoryDebugState requires the DebugHudState");
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.heap = this.hud.createDebugValue(HEAP, this.location);
        if (this.includeDirectMem) {
            this.direct = this.hud.createDebugValue(DIRECT, this.location);
        }
    }

    protected void updateMemoryStats() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long max = rt.maxMemory();
        long used = total - free;
        if (this.lastHeapUsage != used || this.lastHeapTotal != max) {
            this.lastHeapUsage = used;
            this.lastHeapTotal = max;
            float percent = 100.0f * (float)used / (float)max;
            String p = String.format("%.2f%%", Float.valueOf(percent));
            if (this.detailedStats) {
                String mb = String.format("%.2f/%.2f mb", Float.valueOf((float)used * BYTE_TO_MB), Float.valueOf((float)max * BYTE_TO_MB));
                this.heap.setObject((Object)(p + " (" + mb + ")"));
            } else {
                this.heap.setObject((Object)p);
            }
        }
        if (this.includeDirectMem) {
            long directTotal = MemoryUtils.getDirectMemoryTotalCapacity();
            long directUsage = MemoryUtils.getDirectMemoryUsage();
            if (this.lastDirectUsage != directUsage || this.lastDirectTotal != directTotal) {
                this.lastDirectUsage = directUsage;
                this.lastDirectTotal = directTotal;
                float percent = 100.0f * (float)directUsage / (float)directTotal;
                String p = String.format("%.2f%%", Float.valueOf(percent));
                if (this.detailedStats) {
                    String mb = String.format("%.2f/%.2f mb", Float.valueOf((float)directUsage * BYTE_TO_MB), Float.valueOf((float)directTotal * BYTE_TO_MB));
                    this.direct.setObject((Object)(p + " (" + mb + ")"));
                } else {
                    this.direct.setObject((Object)p);
                }
            }
        }
    }

    public void update(float tpf) {
        this.nextUpdate -= tpf;
        if (this.nextUpdate <= 0.0f) {
            this.updateMemoryStats();
            this.nextUpdate = this.updateInterval;
        }
    }

    protected void onDisable() {
        this.hud.removeDebugValue(HEAP);
        if (this.includeDirectMem) {
            this.hud.removeDebugValue(DIRECT);
        }
    }
}

