/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.BallJoint;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.RigidBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicHingeJoint<K, S extends AbstractShape>
implements Joint<K, S> {
    static Logger log = LoggerFactory.getLogger(DynamicHingeJoint.class);
    K id;
    RigidBody<K, S> altBody;
    Vec3d altOffset;
    Vec3d altAxis;
    RigidBody<K, S> mainBody;
    Vec3d mainOffset;
    Vec3d mainAxis;
    Quatd relativeRotation;
    double damping;
    double test1;
    private Contact<K, S> contact1 = new Contact();
    private Contact<K, S> contact2 = new Contact();
    private Accumulator accumulator1 = new Accumulator();
    private Accumulator accumulator2 = new Accumulator();
    private BallJoint ball1;
    private BallJoint ball2;

    public DynamicHingeJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, Quatd mainRot, RigidBody<K, S> altBody, Vec3d altOffset, Quatd altRotation, double damping, double test1) {
        this(id, mainBody, mainOffset, mainRot.mult(Vec3d.UNIT_X), altBody, altOffset, altRotation.mult(Vec3d.UNIT_X), damping, test1);
    }

    public DynamicHingeJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, Vec3d mainAxis, RigidBody<K, S> altBody, Vec3d altOffset, Vec3d altAxis, double damping, double test1) {
        this.id = id;
        this.altBody = altBody;
        this.altOffset = altOffset;
        this.altAxis = altAxis;
        this.mainBody = mainBody;
        this.mainOffset = mainOffset;
        this.mainAxis = mainAxis;
        this.damping = damping;
        this.test1 = test1;
        this.contact1.setBodies(mainBody, altBody);
        this.contact2.setBodies(mainBody, altBody);
        this.contact1.friction = -0.7;
        this.contact2.friction = -0.7;
        this.ball1 = new BallJoint<K, S>(id, mainBody, mainOffset.subtract(mainAxis.mult(0.5)), altBody, altOffset.subtract(altAxis.mult(0.5)), this.relativeRotation, damping, test1);
        this.ball2 = new BallJoint<K, S>(id, mainBody, mainOffset.add(mainAxis.mult(0.5)), altBody, altOffset.add(altAxis.mult(0.5)), this.relativeRotation, damping, test1);
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public RigidBody<K, S> getMainBody() {
        return this.mainBody;
    }

    @Override
    public RigidBody<K, S> getAltBody() {
        return this.altBody;
    }

    @Override
    public RigidBody<K, S> getOtherBody(RigidBody<K, S> body) {
        if (this.mainBody == body) {
            return this.altBody;
        }
        if (this.altBody == body) {
            return this.mainBody;
        }
        throw new IllegalArgumentException("Specified body:" + body.id + " is not part of this joint:" + this.id);
    }

    @Override
    public boolean isSleepy() {
        return this.ball1.isSleepy() && this.ball2.isSleepy();
    }

    @Override
    public void calculateInternals(double step) {
    }

    @Override
    public void calculatePositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2) {
    }

    @Override
    public void calculateVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
    }

    private void calculateInternalsUnconstrainedTwoBody(double step, Contact contact, double axisOffset) {
        Vec3d world1 = this.mainBody.localToWorld(this.mainOffset.add(this.mainAxis.mult(axisOffset)));
        Vec3d world2 = this.altBody.localToWorld(this.altOffset.add(this.altAxis.mult(axisOffset)));
        Vec3d delta = world2.subtract(world1);
        Vec3d normal = null;
        double length = delta.length();
        normal = length != 0.0 ? delta.mult(1.0 / length) : new Vec3d(0.0, 1.0, 0.0);
        Vec3d cp = world1.add(world2).multLocal(0.5);
        log.info("cp:" + cp);
        contact.setContactInfo(cp, normal, delta.length());
        contact.matchLocalTemperature();
        contact.calculateInternals(step);
    }

    @Override
    public void resolve(double step) {
        log.info("resolve(" + step + ")");
        int count = 5;
        for (int i = 0; i < count; ++i) {
            this.doResolve(step / (double)count);
        }
    }

    public void doResolve(double step) {
        boolean useTwoBalls = true;
        if (useTwoBalls) {
            this.ball1.resolve(step);
            this.ball2.resolve(step);
            return;
        }
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.calculateInternalsUnconstrainedTwoBody(step, this.contact1, -0.5);
        this.contact1.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact1.penetration);
        log.info("contact1 pos1:" + this.contact1.relativeContactPosition1 + "  pos2:" + this.contact1.relativeContactPosition2);
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        this.mainBody.calculateDerivedData();
        this.altBody.position.addLocal(linear2);
        this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
        this.altBody.calculateDerivedData();
        this.contact1.calculateVelocityChange(linear1, linear2, angular1, angular2);
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular2);
        this.altBody.addLinearVelocity(linear2);
        this.altBody.addRotationalVelocity(angular2);
        this.calculateInternalsUnconstrainedTwoBody(step, this.contact2, 0.5);
        this.contact2.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact2.penetration);
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        this.mainBody.calculateDerivedData();
        this.altBody.position.addLocal(linear2);
        this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
        this.altBody.calculateDerivedData();
        this.contact2.calculateVelocityChange(linear1, linear2, angular1, angular2);
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular2);
        this.altBody.addLinearVelocity(linear2);
        this.altBody.addRotationalVelocity(angular2);
    }

    public void resolve2(double step) {
        log.info("resolve(" + step + ")");
        boolean useTwoBalls = false;
        if (useTwoBalls) {
            this.ball1.resolve(step);
            this.ball2.resolve(step);
            return;
        }
        this.calculateInternalsUnconstrainedTwoBody(step, this.contact1, -0.5);
        this.calculateInternalsUnconstrainedTwoBody(step, this.contact2, 0.5);
        boolean applySeparate = true;
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.accumulator1.clear();
        this.accumulator2.clear();
        this.contact1.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact1.penetration);
        log.info("contact1 pos1:" + this.contact1.relativeContactPosition1 + "  pos2:" + this.contact1.relativeContactPosition2);
        if (applySeparate) {
            this.mainBody.position.addLocal(linear1);
            this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
            this.mainBody.calculateDerivedData();
            this.altBody.position.addLocal(linear2);
            this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
            this.altBody.calculateDerivedData();
        } else {
            this.accumulator1.accumulate(linear1, angular1);
            this.accumulator2.accumulate(linear2, angular2);
            log.info("linear1:" + linear1 + "  linear2:" + linear2);
        }
        this.contact2.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact2.penetration);
        log.info("contact2 pos1:" + this.contact2.relativeContactPosition1 + "  pos2:" + this.contact2.relativeContactPosition2);
        if (applySeparate) {
            this.mainBody.position.addLocal(linear1);
            this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
            this.mainBody.calculateDerivedData();
            this.altBody.position.addLocal(linear2);
            this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
            this.altBody.calculateDerivedData();
        } else {
            this.accumulator1.accumulate(linear1, angular1);
            this.accumulator2.accumulate(linear2, angular2);
            log.info("linear1:" + linear1 + "  linear2:" + linear2);
        }
        if (!applySeparate) {
            this.mainBody.position.addLocal(this.accumulator1.getLinear(linear1));
            this.mainBody.orientation.addScaledVectorLocal(this.accumulator1.getAngular(angular1), 1.0);
            this.mainBody.calculateDerivedData();
            this.altBody.position.addLocal(this.accumulator2.getLinear(linear2));
            this.altBody.orientation.addScaledVectorLocal(this.accumulator2.getAngular(angular2), 1.0);
            this.altBody.calculateDerivedData();
            log.info("accum linear1:" + linear1 + "  accum linear2:" + linear2);
        }
        this.accumulator1.clear();
        this.accumulator2.clear();
        this.contact1.calculateVelocityChange(linear1, linear2, angular1, angular2);
        if (applySeparate) {
            this.mainBody.addLinearVelocity(linear1);
            this.mainBody.addRotationalVelocity(angular2);
            this.altBody.addLinearVelocity(linear2);
            this.altBody.addRotationalVelocity(angular2);
        } else {
            this.accumulator1.accumulate(linear1, angular1);
            this.accumulator2.accumulate(linear2, angular2);
        }
        this.contact2.calculateVelocityChange(linear1, linear2, angular1, angular2);
        if (applySeparate) {
            this.mainBody.addLinearVelocity(linear1);
            this.mainBody.addRotationalVelocity(angular2);
            this.altBody.addLinearVelocity(linear2);
            this.altBody.addRotationalVelocity(angular2);
        } else {
            this.accumulator1.accumulate(linear1, angular1);
            this.accumulator2.accumulate(linear2, angular2);
        }
        if (!applySeparate) {
            this.mainBody.addLinearVelocity(this.accumulator1.getLinear(linear1));
            this.mainBody.addRotationalVelocity(this.accumulator2.getAngular(angular2));
            this.altBody.addLinearVelocity(this.accumulator2.getLinear(linear2));
            this.altBody.addRotationalVelocity(this.accumulator2.getAngular(angular2));
        }
    }

    protected static class Accumulator {
        Vec3d linMin = new Vec3d();
        Vec3d linMax = new Vec3d();
        Vec3d angMin = new Vec3d();
        Vec3d angMax = new Vec3d();

        protected Accumulator() {
        }

        public void accumulate(Vec3d lin, Vec3d ang) {
            this.linMin.minLocal(lin);
            this.linMax.maxLocal(lin);
            this.angMin.minLocal(ang);
            this.angMax.maxLocal(ang);
        }

        public final Vec3d getLinear(Vec3d store) {
            store.x = this.linMin.x + this.linMax.x;
            store.y = this.linMin.y + this.linMax.y;
            store.z = this.linMin.z + this.linMax.z;
            return store;
        }

        public final Vec3d getAngular(Vec3d store) {
            store.x = this.angMin.x + this.angMax.x;
            store.y = this.angMin.y + this.angMax.y;
            store.z = this.angMin.z + this.angMax.z;
            return store;
        }

        public final void clear() {
            this.linMin.set(0.0, 0.0, 0.0);
            this.linMax.set(0.0, 0.0, 0.0);
            this.angMin.set(0.0, 0.0, 0.0);
            this.angMax.set(0.0, 0.0, 0.0);
        }
    }
}

