/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import java.util.Objects;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.object.ClaimViewState;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimType;
import mythruna.es.OwnedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManagementState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PropertyManagementState.class);
    private GameSessionState sessionState;
    private EntityData ed;
    private Container window;
    private Checkbox showClaims;
    private VersionedReference<Boolean> visEnabled;
    private PropertyInfoContainer properties;
    private VersionedList<PropertyInfo> propertyModel = new VersionedList();
    private ListBox<PropertyInfo> propertyList;
    private VersionedReference<Integer> selectionRef;
    private PropertyInfo selectedProperty;
    private WatchedEntity watchedProperty;
    private Label propertyName;
    private Label areaLabel;
    private Label sizeLabel;
    private Label localMap;
    private Container actions;
    private HelpPopup help;

    public PropertyManagementState() {
        this.setEnabled(false);
    }

    protected void showError(String error) {
        ((GuiState)this.getState(GuiState.class)).showError("Property Error", error);
    }

    protected void initialize(Application app) {
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Property", (AppState)this);
        this.window = new Container(new ElementId("window"));
        this.window.addChild((Node)new Label("Property Management", new ElementId("window.title")), new Object[0]);
        Container centered = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        Container col = (Container)centered.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[0]);
        this.showClaims = (Checkbox)col.addChild((Node)new Checkbox("Show property areas"), new Object[0]);
        this.visEnabled = this.showClaims.getModel().createReference();
        col.addChild((Node)new Label("Your properties:"), new Object[0]);
        this.propertyList = (ListBox)col.addChild((Node)new ListBox(this.propertyModel), new Object[0]);
        this.selectionRef = this.propertyList.getSelectionModel().createSelectionReference();
        col.addChild((Node)new Label(""), new Object[0]);
        centered.addChild((Node)new Panel(new ElementId("spacer")), new Object[0]);
        col = (Container)centered.addChild((Node)new Container(), new Object[0]);
        col.addChild((Node)new Label("Property Details:", new ElementId("column.title.label")), new Object[0]);
        Container props = (Container)col.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        props.addChild((Node)new Label("Name:", new ElementId("info.name.label")), new Object[0]);
        this.propertyName = (Label)props.addChild((Node)new Label("Unknown", new ElementId("info.value.label")), new Object[]{1});
        props.addChild((Node)new Label("Area:", new ElementId("info.name.label")), new Object[0]);
        this.areaLabel = (Label)props.addChild((Node)new Label("Unknown", new ElementId("info.value.label")), new Object[]{1});
        props.addChild((Node)new Label("Size:", new ElementId("info.name.label")), new Object[0]);
        this.sizeLabel = (Label)props.addChild((Node)new Label("Unknown", new ElementId("info.value.label")), new Object[]{1});
        this.localMap = (Label)col.addChild((Node)new Label("", new ElementId("map.label")), new Object[0]);
        this.localMap.setPreferredSize(new Vector3f(384.0f, 384.0f, 1.0f));
        this.actions = (Container)col.addChild((Node)new Container(), new Object[0]);
        this.updateDetails();
        this.help = new HelpPopup((Spatial)this.window, loc -> loc, "Property");
        this.help.setText("Property claims allow players to protect areas", "of the world that only they can edit.", "", "Check 'Show property areas' to toggle on", "property visualization. This view will show", "the color-coded claimed areas of the world.", "  Red = Cannot edit", "  Blue = Can edit", "", "Select a property to view its details", "and manage it.", "", "Click 'Place Property' to equip the", "property marker for placement in the world.", "", "If the property is already placed in the", "world then clicking 'Retrieve Property'", "will remove it and get it ready for placing", "somewhere else.");
        this.properties = new PropertyInfoContainer(((AvatarState)this.getState(AvatarState.class)).getAvatarId(), this.ed);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.updateDialogPosition();
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.window);
        this.showClaims.setChecked(((ClaimViewState)this.getState(ClaimViewState.class)).isEnabled());
        this.help.attach();
        this.properties.start();
    }

    public void update(float tpf) {
        this.properties.update();
        if (this.selectionRef.update()) {
            this.setSelectedProperty((PropertyInfo)this.propertyList.getSelectedItem());
        }
        if (this.watchedProperty != null && this.watchedProperty.applyChanges()) {
            this.updateDetails();
        }
        this.updateDialogPosition();
        if (this.visEnabled.update()) {
            ((ClaimViewState)this.getState(ClaimViewState.class)).setEnabled((Boolean)this.visEnabled.get());
        }
    }

    protected void onDisable() {
        this.help.detach();
        this.window.removeFromParent();
        this.properties.stop();
        this.propertyModel.clear();
        this.setSelectedProperty(null);
        this.propertyList.getSelectionModel().clear();
    }

    protected void updateDialogPosition() {
        Vector2f screen = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        Vector3f pref = this.window.getSize();
        float y = Math.max(screen.y * 0.5f, pref.y + screen.y * 0.05f);
        this.window.setLocalTranslation(screen.x * 0.05f, y, 10.0f);
    }

    protected void setSelectedProperty(PropertyInfo info) {
        if (Objects.equals(this.selectedProperty, info)) {
            return;
        }
        this.selectedProperty = info;
        if (this.watchedProperty != null) {
            this.watchedProperty.release();
        }
        if (info != null) {
            this.watchedProperty = this.ed.watchEntity(info.entity.getId(), new Class[]{Name.class, ClaimArea.class, ClaimType.class});
        }
        this.updateDetails();
    }

    protected void updateDetails() {
        ClaimArea area;
        log.info("updateDetails()");
        this.actions.clearChildren();
        if (this.selectedProperty == null) {
            this.areaLabel.setText("");
            this.sizeLabel.setText("");
            this.propertyName.setText("");
            this.localMap.setText("< No property selected. >");
            return;
        }
        this.propertyName.setText(this.selectedProperty.name);
        ClaimType type = (ClaimType)this.watchedProperty.get(ClaimType.class);
        String max = type == null ? "Unknown" : String.valueOf(type.getMaxArea());
        ClaimArea claimArea = area = this.watchedProperty == null ? null : (ClaimArea)this.watchedProperty.get(ClaimArea.class);
        if (area == null) {
            this.areaLabel.setText("?/" + max + " sq. meters");
            this.sizeLabel.setText("Unknown");
            this.localMap.setText("< Property not placed. >");
            this.actions.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "placeProperty")), new Object[0]);
        } else {
            this.areaLabel.setText(area.getArea() + "/" + max + " sq. meters");
            this.sizeLabel.setText(area.getSizeX() + " x " + area.getSizeZ() + " sq. meters");
            this.localMap.setText("< Map feature not yet implemented >");
            this.actions.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "retrieveProperty")), new Object[0]);
        }
    }

    protected void placeProperty() {
        ClaimArea area;
        PropertyInfo info = (PropertyInfo)this.propertyList.getSelectedItem();
        if (info == null) {
            this.showError("No property selected.");
        }
        if ((area = (ClaimArea)this.ed.getComponent(info.entity.getId(), ClaimArea.class)) != null) {
            this.showError("Property already placed.");
        }
        this.sessionState.getGameSession().runAction(info.entity.getId(), "prepareToPlace", new Object[0]);
        ((ClaimViewState)this.getState(ClaimViewState.class)).setEnabled(true);
        ((GameSessionState)this.getState(GameSessionState.class)).closePlayerMenu();
    }

    protected void retrieveProperty() {
        PropertyInfo info = (PropertyInfo)this.propertyList.getSelectedItem();
        if (info == null) {
            this.showError("No property selected.");
        }
        ((OptionPanelState)this.getState(OptionPanelState.class)).show("Retrieve Property?", "Really remove property:\"" + info.name + "\"\nfrom the world?", new Action[]{new CallMethodAction("Yes", (Object)this, "doRetrieveProperty"), new EmptyAction("No"), new EmptyAction("Cancel")});
    }

    protected void doRetrieveProperty() {
        ClaimArea area;
        PropertyInfo info = (PropertyInfo)this.propertyList.getSelectedItem();
        if (info == null) {
            this.showError("No property selected.");
        }
        if ((area = (ClaimArea)this.ed.getComponent(info.entity.getId(), ClaimArea.class)) == null) {
            this.showError("Property is not placed.");
        }
        this.sessionState.getGameSession().runAction(info.entity.getId(), "retrieve", new Object[0]);
    }

    private class PropertyInfoContainer
    extends EntityContainer<PropertyInfo> {
        public PropertyInfoContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{OwnedBy.class, ClaimType.class, Name.class});
            ComponentFilter filter = Filters.fieldEquals(OwnedBy.class, (String)"owner", (Object)player);
            this.setFilter(filter);
        }

        protected PropertyInfo addObject(Entity e) {
            PropertyInfo object = new PropertyInfo(PropertyManagementState.this, e);
            this.updateObject(object, e);
            PropertyManagementState.this.propertyModel.add((Object)object);
            return object;
        }

        protected void updateObject(PropertyInfo object, Entity e) {
            object.update();
        }

        protected void removeObject(PropertyInfo object, Entity e) {
            PropertyManagementState.this.propertyModel.add((Object)object);
        }
    }

    private class PropertyInfo {
        private Entity entity;
        private String name;

        public PropertyInfo(PropertyManagementState propertyManagementState, Entity entity) {
            this.entity = entity;
        }

        public void update() {
            Name n = (Name)this.entity.get(Name.class);
            this.name = n == null ? "Unknown" : n.getName();
        }

        public String toString() {
            return this.name;
        }
    }
}

