/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mblock.CellArray;
import mythruna.client.ui.clothing.ClothingBuilder;
import mythruna.client.ui.edit.Edit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCellsEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(AddCellsEdit.class);
    private ClothingBuilder builder;
    private String name;
    private CellArray values;
    private CellArray undo;

    public AddCellsEdit(ClothingBuilder builder, String name, CellArray values) {
        this.builder = builder;
        this.name = name;
        this.values = values;
    }

    @Override
    public String toDisplay() {
        return "add:" + this.name;
    }

    @Override
    public void doEdit() {
        this.undo = this.builder.getCells().clone();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 32; ++k) {
                    int value = this.values.getCell(i, j, k);
                    if (value == 0) continue;
                    this.builder.addValue(i, j, value);
                }
            }
        }
    }

    @Override
    public void undoEdit() {
        if (this.undo != null) {
            this.builder.setCells(this.undo);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

