/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.detail;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.simsilica.mathd.Vec3d;
import com.simsilica.state.CameraState;
import mythruna.client.GameSessionState;
import mythruna.client.PostProcessingState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.DepthOfField;
import mythruna.client.view.PickState;
import mythruna.client.view.WorldHit;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(DetailViewState.class);
    private GameSession session;
    private float originalFov;
    private boolean originalThirdPerson;
    private DepthOfField dof = new DepthOfField(1.0f, 5.0f, 3.0f, 0.1f);
    private AvatarState avatar;
    private PickState pick;
    float timer = 0.0f;

    public DetailViewState() {
        this.setEnabled(false);
    }

    protected void initialize(Application app) {
        this.pick = (PickState)this.getState(PickState.class, true);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.session = sessionState.getGameSession();
        this.avatar = (AvatarState)this.getState(AvatarState.class, true);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("enabled");
        this.originalFov = ((CameraState)this.getState(CameraState.class, true)).getFieldOfView();
        ((CameraState)this.getState(CameraState.class, true)).setFieldOfView(50.0f);
        ((PostProcessingState)this.getState(PostProcessingState.class)).setDepthOfField(this.dof);
        this.originalThirdPerson = ((AvatarState)this.getState(AvatarState.class)).isThirdPerson();
        this.avatar.setThirdPerson(false);
    }

    protected void onDisable() {
        log.info("disabled");
        ((CameraState)this.getState(CameraState.class, true)).setFieldOfView(this.originalFov);
        ((PostProcessingState)this.getState(PostProcessingState.class)).setDepthOfField(null);
        this.avatar.setThirdPerson(this.originalThirdPerson);
    }

    public void update(float tpf) {
        this.timer += tpf;
        if (this.timer < 0.1f) {
            return;
        }
        this.timer = 0.0f;
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        Camera cam = this.getApplication().getCamera();
        log.info("cursor:" + cursor);
        Vector2f adjustedCursor = new Vector2f(cursor.x, cursor.y);
        Vector3f clickFar = cam.getWorldCoordinates(adjustedCursor, 1.0f);
        Vector3f clickNear = cam.getWorldCoordinates(adjustedCursor, 0.0f);
        Vector3f clickDir = clickFar.subtract(clickNear).normalizeLocal();
        if (clickDir.isUnitVector()) {
            Vec3d offset = new Vec3d(clickNear).subtract(new Vec3d(cam.getLocation()));
            WorldHit hit = this.pick.pickWorld(offset, new Vec3d(clickDir), 10);
            log.info("hit object:" + hit.object + " hit block:" + hit.block);
            this.session.runAction(this.avatar.getAvatarId(), "detailTest", new Object[]{hit.block, hit.object});
        } else {
            log.warn("Non-unit view vector:" + clickDir);
        }
    }
}

