/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterRelationship
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(CharacterRelationship.class);
    @IndexedField
    private EntityId source;
    @IndexedField
    private EntityId target;
    private byte level;
    private byte type;
    private double updatedTime;

    private CharacterRelationship() {
    }

    public CharacterRelationship(EntityId source, EntityId target, int level, int type, double updatedTime) {
        this.source = source;
        this.target = target;
        this.level = (byte)level;
        this.updatedTime = updatedTime;
    }

    public CharacterRelationship(EntityId source, EntityId target, int level, int type, WorldTime updatedTime) {
        this(source, target, level, type, updatedTime.getGameTime());
    }

    public static ComponentFilter<CharacterRelationship> sourceFilter(EntityId source) {
        return Filters.fieldEquals(CharacterRelationship.class, (String)"source", (Object)source);
    }

    public static ComponentFilter<CharacterRelationship> targetFilter(EntityId target) {
        return Filters.fieldEquals(CharacterRelationship.class, (String)"target", (Object)target);
    }

    public static ComponentFilter<CharacterRelationship> connectionFilter(EntityId sourceOrTarget) {
        return Filters.or(CharacterRelationship.class, (ComponentFilter[])new ComponentFilter[]{CharacterRelationship.sourceFilter(sourceOrTarget), CharacterRelationship.targetFilter(sourceOrTarget)});
    }

    public static ComponentFilter<CharacterRelationship> linkFilter(EntityId source, EntityId target) {
        return Filters.and(CharacterRelationship.class, (ComponentFilter[])new ComponentFilter[]{CharacterRelationship.sourceFilter(source), CharacterRelationship.targetFilter(target)});
    }

    public CharacterRelationship updateLevel(int level, int type, WorldTime updatedTime) {
        return new CharacterRelationship(this.source, this.target, level, type, updatedTime);
    }

    public EntityId getSource() {
        return this.source;
    }

    public EntityId getTarget() {
        return this.target;
    }

    public EntityId getAdjacent(EntityId start) {
        if (start.getId() == this.target.getId()) {
            return this.source;
        }
        if (start.getId() == this.source.getId()) {
            return this.target;
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public int getType() {
        return this.type;
    }

    public WorldTime getUpdatedTime() {
        return new WorldTime(this.updatedTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("target", (Object)this.target).add("level", (int)this.level).add("type", (int)this.type).add("updatedTime", (Object)this.getUpdatedTime()).toString();
    }
}

