/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import mythruna.shell.CommandShell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellService<K> {
    static Logger log = LoggerFactory.getLogger(ShellService.class);
    private WeakHashMap<K, CommandShell> shells = new WeakHashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CommandShell globalShell = new CommandShell();

    public CommandShell getGlobalShell() {
        return this.globalShell;
    }

    public CommandShell createChildShell(K id) {
        return this.createChildShell(id, null);
    }

    public CommandShell createChildShell(K id, Consumer<String> output) {
        return this.createChildShell(id, null, output);
    }

    public CommandShell createChildShell(K id, Map<String, Object> variables, Consumer<String> output) {
        if (this.shells.get(id) != null) {
            throw new IllegalArgumentException("Key:" + id + " already has a shell");
        }
        CommandShell child = new CommandShell(this.globalShell, variables, output);
        this.setShell(id, child);
        return child;
    }

    public void setShell(K id, CommandShell shell) {
        this.lock.writeLock().lock();
        try {
            this.shells.put(id, shell);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CommandShell getShell(K id) {
        this.lock.readLock().lock();
        try {
            CommandShell commandShell = this.shells.get(id);
            return commandShell;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CommandShell removeShell(K id) {
        this.lock.writeLock().lock();
        try {
            CommandShell commandShell = this.shells.remove(id);
            return commandShell;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

