/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertInfo
implements Serializable {
    static Logger log = LoggerFactory.getLogger(InsertInfo.class);
    private static final long serialVersionUID = 42L;
    private String type;
    private byte facing;
    private Vec3i location;
    private Vec3i size;

    public InsertInfo(String type, Vec3i location, Vec3i size) {
        this(type, location, size, -1);
    }

    public InsertInfo(String type, Vec3i location, Vec3i size, int facing) {
        this.type = type;
        this.location = location;
        this.size = size;
        this.facing = (byte)facing;
    }

    public String getType() {
        return this.type;
    }

    public Vec3i getLocation() {
        return this.location;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public boolean contains(Vec3i location) {
        return this.contains(location.x, location.y, location.z);
    }

    public boolean contains(Vec3d location) {
        return this.contains(location.x, location.y, location.z);
    }

    public boolean contains(double x, double y, double z) {
        if (x < (double)this.location.x || z < (double)this.location.z) {
            return false;
        }
        if (x > (double)(this.location.x + this.size.x) || z > (double)(this.location.z + this.size.z)) {
            return false;
        }
        if (this.size.y == 0) {
            return true;
        }
        if (y < (double)this.location.y) {
            return false;
        }
        return !(y > (double)(this.location.y + this.size.y));
    }

    public boolean contains(Vec3d point, Vec3i size) {
        return this.contains(point.x, point.y, point.z, size.x, size.y, size.z);
    }

    public boolean contains(double x, double y, double z, double xSize, double ySize, double zSize) {
        if (x < (double)this.location.x || z < (double)this.location.z) {
            return false;
        }
        if (x + xSize > (double)(this.location.x + this.size.x) || z + zSize > (double)(this.location.z + this.size.z)) {
            return false;
        }
        if (this.size.y == 0) {
            return true;
        }
        if (y < (double)this.location.y) {
            return false;
        }
        return !(y + ySize > (double)(this.location.y + this.size.y));
    }

    public int getFacing() {
        return this.facing;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type:" + this.type + ", location:" + this.location + ", size:" + this.size + ", facing:" + this.facing + "]";
    }
}

