/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimLayer;
import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.jme.AttachmentControl;
import com.simsilica.crig.jme.VariationHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimComposerRig
implements CharacterRig {
    static Logger log = LoggerFactory.getLogger(AnimComposerRig.class);
    private AnimComposer anim;
    private AttachmentControl attachments;
    private double originalSpeed;
    private Map<String, String> layerActions = new HashMap<String, String>();
    private Map<String, Double> mixValues = new HashMap<String, Double>();
    private Map<String, Integer> variationValues = new HashMap<String, Integer>();

    public AnimComposerRig(AnimComposer anim, AttachmentControl attachments) {
        this.anim = anim;
        this.attachments = attachments;
        this.originalSpeed = anim.getGlobalSpeed();
        anim.setGlobalSpeed(0.0f);
    }

    public static AnimComposerRig createRig(Spatial s) {
        AnimComposer anim = AnimComposerRig.findControl(s, AnimComposer.class);
        if (anim == null) {
            throw new IllegalArgumentException("Spatial has no AnimComposer:" + s);
        }
        return new AnimComposerRig(anim, AnimComposerRig.findControl(s, AttachmentControl.class));
    }

    public static <T extends Control> T findControl(Spatial s, Class<T> type) {
        return AnimComposerRig.findControl("", s, type);
    }

    public static <T extends Control> T findControl(String indent, Spatial s, Class<T> type) {
        Object result = s.getControl(type);
        if (log.isTraceEnabled()) {
            log.trace(indent + "Spatial:" + s + "  result:" + result);
        }
        if (result != null) {
            return (T)result;
        }
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                result = AnimComposerRig.findControl(indent + "    ", child, type);
                if (result == null) continue;
                return (T)result;
            }
        }
        return null;
    }

    public AnimComposer getAnimComposer() {
        return this.anim;
    }

    public void release() {
        this.anim.setGlobalSpeed((float)this.originalSpeed);
    }

    @Override
    public void setMix(String blendId, double value) {
        Action action = this.anim.getAction(blendId);
        if (action == null) {
            log.warn("No action for blendId:" + blendId);
            return;
        }
        if (!(action instanceof BlendAction)) {
            log.warn("Action is not a blend action for blendId:" + blendId + " action:" + action);
            return;
        }
        ((BlendAction)action).getBlendSpace().setValue((float)value);
        this.mixValues.put(blendId, value);
    }

    @Override
    public double getMix(String blendId) {
        Double val = this.mixValues.get(blendId);
        return val == null ? -1.0 : val;
    }

    @Override
    public void setTime(String layerId, double time) {
        AnimLayer layer;
        if (layerId == null) {
            layerId = "Default";
        }
        if ((layer = this.anim.getLayer(layerId)).getCurrentAction() != null) {
            layer.setTime(time);
        } else {
            log.warn("No current action for layer:" + layerId);
        }
    }

    @Override
    public double getTime(String layerId) {
        AnimLayer layer;
        if (layerId == null) {
            layerId = "Default";
        }
        return (layer = this.anim.getLayer(layerId)) == null ? -1.0 : layer.getTime();
    }

    @Override
    public void setLayerAction(String layerId, String actionId) {
        if (layerId == null) {
            layerId = "Default";
        }
        if (actionId == null) {
            this.anim.removeCurrentAction(layerId);
            this.layerActions.remove(layerId);
        } else {
            if (!this.anim.hasAction(actionId) && !this.anim.hasAnimClip(actionId)) {
                log.error("Rig does not have action:" + actionId + " rig:" + this);
                return;
            }
            Action temp = this.anim.setCurrentAction(actionId, layerId);
            if (log.isTraceEnabled()) {
                log.trace("animAction:" + temp);
                AnimLayer layer = this.anim.getLayer(layerId);
                log.trace("current action:" + layer.getCurrentAction());
            }
            this.layerActions.put(layerId, actionId);
        }
    }

    @Override
    public String getLayerAction(String layerId) {
        if (layerId == null) {
            layerId = "Default";
        }
        return this.layerActions.get(layerId);
    }

    @Override
    public boolean hasAction(String action) {
        if (this.anim.hasAction(action)) {
            return true;
        }
        return this.anim.hasAnimClip(action);
    }

    @Override
    public double getLayerDuration(String layerId) {
        if (layerId == null) {
            layerId = "Default";
        }
        AnimLayer layer = this.anim.getLayer(layerId);
        if (log.isTraceEnabled()) {
            log.trace("getLayerDuration(" + layerId + ") layer:" + layer);
            log.trace("current action:" + layer.getCurrentAction());
        }
        if (layer.getCurrentAction() == null) {
            return 0.0;
        }
        return layer.getCurrentAction().getLength();
    }

    @Override
    public AttachmentPoint getAttachmentPoint(String name) {
        return this.attachments == null ? null : this.attachments.getAttachment(name);
    }

    @Override
    public boolean setVariation(String type, int index) {
        Integer existing = this.variationValues.put(type, index);
        if (existing != null && existing == index) {
            return false;
        }
        if (this.attachments == null) {
            log.error("Can't find rig type for:" + this + "  animComposer:" + this.anim);
            return false;
        }
        VariationHandler handler = this.attachments.getRigType().getVariationHandler(type);
        if (handler == null) {
            log.warn("No handler for type:" + type);
            return false;
        }
        return handler.setVariationType(this, type, index);
    }

    @Override
    public int getVariation(String type) {
        Integer existing = this.variationValues.get(type);
        return existing == null ? -1 : existing;
    }
}

