/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.SimTime;

public abstract class AbstractGameSystem
implements GameSystem {
    private GameSystemManager parent;
    private boolean initialized = false;

    protected AbstractGameSystem() {
    }

    protected GameSystemManager getManager() {
        return this.parent;
    }

    protected <T> T getSystem(Class<T> type) {
        return this.getSystem(type, false);
    }

    protected <T> T getSystem(Class<T> type, boolean failOnMiss) {
        T result = this.parent.get(type);
        if (result == null && failOnMiss) {
            throw new IllegalArgumentException("System not found for:" + type);
        }
        return result;
    }

    @Override
    public final void initialize(GameSystemManager parent) {
        if (this.initialized) {
            return;
        }
        this.parent = parent;
        this.initialize();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final void terminate(GameSystemManager parent) {
        if (!this.initialized) {
            return;
        }
        this.terminate();
        this.initialized = false;
    }

    protected abstract void initialize();

    protected abstract void terminate();

    @Override
    public void start() {
    }

    @Override
    public void update(SimTime time) {
    }

    @Override
    public void stop() {
    }
}

