/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.DetailedProfiler;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.profile.AppStep;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DetailedProfilerState
extends BaseAppState {
    private static final int PANEL_WIDTH = 400;
    private static final int PADDING = 10;
    private static final int LINE_HEIGHT = 12;
    private static final int HEADER_HEIGHT = 100;
    private static final float REFRESH_TIME = 1.0f;
    private static final String TOGGLE_KEY = "Toggle_Detailed_Profiler";
    private static final String CLICK_KEY = "Click_Detailed_Profiler";
    private static final String INSIGNIFICANT = "Hide insignificant stat";
    private final DetailedProfiler prof = new DetailedProfiler();
    private float time = 0.0f;
    private BitmapFont font;
    private BitmapFont bigFont;
    private final Node ui = new Node("Stats ui");
    private final Map<String, StatLineView> lines = new HashMap<String, StatLineView>();
    private double totalTimeCpu;
    private double totalTimeGpu;
    private int maxLevel = 0;
    private BitmapText frameTimeValue;
    private BitmapText frameCpuTimeValue;
    private BitmapText frameGpuTimeValue;
    private BitmapText hideInsignificantField;
    private BitmapText selectedField;
    private double selectedValueCpu = 0.0;
    private double selectedValueGpu = 0.0;
    private boolean hideInsignificant = false;
    private StatLineView rootLine;
    private int height = 0;
    private final DecimalFormat df = new DecimalFormat("##0.00", new DecimalFormatSymbols(Locale.US));
    private final ColorRGBA dimmedWhite = ColorRGBA.White.mult(0.7f);
    private final ColorRGBA dimmedGreen = ColorRGBA.Green.mult(0.7f);
    private final ColorRGBA dimmedOrange = ColorRGBA.Orange.mult(0.7f);
    private final ColorRGBA dimmedRed = ColorRGBA.Red.mult(0.7f);
    private final ProfilerInputListener inputListener = new ProfilerInputListener();

    @Override
    protected void initialize(Application app) {
        Material mat = new Material(app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Geometry darkenStats = new Geometry("StatsDarken", new Quad(400.0f, app.getCamera().getHeight()));
        darkenStats.setMaterial(mat);
        darkenStats.setLocalTranslation(0.0f, -app.getCamera().getHeight(), -1.0f);
        this.ui.attachChild(darkenStats);
        this.ui.setLocalTranslation(app.getCamera().getWidth() - 400, app.getCamera().getHeight(), 0.0f);
        this.font = app.getAssetManager().loadFont("Interface/Fonts/Console.fnt");
        this.bigFont = app.getAssetManager().loadFont("Interface/Fonts/Default.fnt");
        this.prof.setRenderer(app.getRenderer());
        this.rootLine = new StatLineView("Frame");
        this.rootLine.attachTo(this.ui);
        BitmapText frameLabel = new BitmapText(this.bigFont);
        frameLabel.setText("Total Frame Time: ");
        this.ui.attachChild(frameLabel);
        frameLabel.setLocalTranslation(new Vector3f(200.0f - this.bigFont.getLineWidth(frameLabel.getText()), -10.0f, 0.0f));
        BitmapText cpuLabel = new BitmapText(this.bigFont);
        cpuLabel.setText("CPU");
        this.ui.attachChild(cpuLabel);
        cpuLabel.setLocalTranslation(100.0f - this.bigFont.getLineWidth(cpuLabel.getText()) / 2.0f, -40.0f, 0.0f);
        BitmapText gpuLabel = new BitmapText(this.bigFont);
        gpuLabel.setText("GPU");
        this.ui.attachChild(gpuLabel);
        gpuLabel.setLocalTranslation(300.0f - this.bigFont.getLineWidth(gpuLabel.getText()) / 2.0f, -40.0f, 0.0f);
        this.frameTimeValue = new BitmapText(this.bigFont);
        this.frameCpuTimeValue = new BitmapText(this.bigFont);
        this.frameGpuTimeValue = new BitmapText(this.bigFont);
        this.selectedField = new BitmapText(this.font);
        this.selectedField.setText("Selected: ");
        this.selectedField.setLocalTranslation(200.0f, -85.0f, 0.0f);
        this.selectedField.setColor(ColorRGBA.Yellow);
        this.ui.attachChild(this.frameTimeValue);
        this.ui.attachChild(this.frameCpuTimeValue);
        this.ui.attachChild(this.frameGpuTimeValue);
        this.ui.attachChild(this.selectedField);
        this.hideInsignificantField = new BitmapText(this.font);
        this.hideInsignificantField.setText("O Hide insignificant stat");
        this.hideInsignificantField.setLocalTranslation(10.0f, -85.0f, 0.0f);
        this.ui.attachChild(this.hideInsignificantField);
        InputManager inputManager = app.getInputManager();
        if (inputManager != null) {
            inputManager.addMapping(TOGGLE_KEY, new KeyTrigger(64));
            inputManager.addMapping(CLICK_KEY, new MouseButtonTrigger(0));
            inputManager.addListener(this.inputListener, TOGGLE_KEY, CLICK_KEY);
        }
    }

    @Override
    protected void cleanup(Application app) {
        this.ui.detachAllChildren();
        InputManager manager = this.getApplication().getInputManager();
        manager.deleteMapping(TOGGLE_KEY);
        manager.deleteMapping(CLICK_KEY);
        manager.removeListener(this.inputListener);
    }

    @Override
    public void update(float tpf) {
        this.time += tpf;
    }

    private void displayData(Map<String, DetailedProfiler.StatLine> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        for (StatLineView statLine : this.lines.values()) {
            statLine.reset();
            statLine.removeFromParent();
        }
        this.rootLine.reset();
        this.maxLevel = 0;
        for (String path : data.keySet()) {
            if (path.equals("EndFrame")) continue;
            this.maxLevel = Math.max(this.maxLevel, path.split("/").length);
            StatLineView line = this.getStatLineView(path);
            DetailedProfiler.StatLine statLine = data.get(path);
            line.updateValues(statLine.getAverageCpu(), statLine.getAverageGpu());
            String parent = this.getParent(path);
            while (parent != null) {
                StatLineView parentView = this.getStatLineView(parent);
                parentView.updateValues(statLine.getAverageCpu(), statLine.getAverageGpu());
                parentView.children.add(line);
                line.attachTo(this.ui);
                line = parentView;
                parent = this.getParent(parent);
            }
            this.rootLine.children.add(line);
            line.attachTo(this.ui);
            this.rootLine.updateValues(statLine.getAverageCpu(), statLine.getAverageGpu());
        }
        this.totalTimeCpu = this.rootLine.cpuValue;
        this.totalTimeGpu = this.rootLine.gpuValue + data.get("EndFrame").getAverageGpu();
        this.layout();
    }

    private void layout() {
        this.height = 0;
        this.selectedValueCpu = 0.0;
        this.selectedValueGpu = 0.0;
        this.rootLine.layout(0);
        this.frameTimeValue.setText(this.df.format(this.getMsFromNs(this.prof.getAverageFrameTime())) + "ms");
        this.frameTimeValue.setLocalTranslation(200.0f, -10.0f, 0.0f);
        this.setColor(this.frameTimeValue, this.prof.getAverageFrameTime(), this.totalTimeCpu, false, false);
        this.frameCpuTimeValue.setText(this.df.format(this.getMsFromNs(this.totalTimeCpu)) + "ms");
        this.frameCpuTimeValue.setLocalTranslation(new Vector3f(100.0f - this.bigFont.getLineWidth(this.frameCpuTimeValue.getText()) / 2.0f, -60.0f, 0.0f));
        this.setColor(this.frameCpuTimeValue, this.totalTimeCpu, this.totalTimeCpu, false, false);
        this.frameGpuTimeValue.setText(this.df.format(this.getMsFromNs(this.totalTimeGpu)) + "ms");
        this.frameGpuTimeValue.setLocalTranslation(new Vector3f(300.0f - this.bigFont.getLineWidth(this.frameGpuTimeValue.getText()) / 2.0f, -60.0f, 0.0f));
        this.setColor(this.frameGpuTimeValue, this.totalTimeGpu, this.totalTimeGpu, false, false);
        this.selectedField.setText("Selected: " + this.df.format(this.getMsFromNs(this.selectedValueCpu)) + "ms / " + this.df.format(this.getMsFromNs(this.selectedValueGpu)) + "ms");
        this.selectedField.setLocalTranslation(300.0f - this.font.getLineWidth(this.selectedField.getText()) / 2.0f, -85.0f, 0.0f);
    }

    private StatLineView getStatLineView(String path) {
        StatLineView line = this.lines.get(path);
        if (line == null) {
            line = new StatLineView(this.getLeaf(path));
            this.lines.put(path, line);
            line.attachTo(this.ui);
        }
        return line;
    }

    private String getLeaf(String path) {
        int idx = path.lastIndexOf("/");
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    private String getParent(String path) {
        int idx = path.lastIndexOf("/");
        return idx >= 0 ? path.substring(0, idx) : null;
    }

    @Override
    public void postRender() {
        if (this.time > 1.0f) {
            this.prof.appStep(AppStep.EndFrame);
            Map<String, DetailedProfiler.StatLine> data = this.prof.getStats();
            this.displayData(data);
            this.time = 0.0f;
        }
    }

    public Node getUiNode() {
        return this.ui;
    }

    private double getMsFromNs(double time) {
        return time / 1000000.0;
    }

    @Override
    protected void onEnable() {
        this.getApplication().setAppProfiler(this.prof);
        ((SimpleApplication)this.getApplication()).getGuiNode().attachChild(this.ui);
    }

    @Override
    protected void onDisable() {
        this.getApplication().setAppProfiler(null);
        this.ui.removeFromParent();
    }

    public boolean setColor(BitmapText t, double value, double totalTime, boolean isParent, boolean expended) {
        boolean dimmed = isParent && expended;
        boolean insignificant = false;
        if (value > 3.3333333333333332E7) {
            t.setColor(dimmed ? this.dimmedRed : ColorRGBA.Red);
        } else if (value > 1.6666666666666666E7) {
            t.setColor(dimmed ? this.dimmedOrange : ColorRGBA.Orange);
        } else if (value > totalTime / 3.0) {
            t.setColor(dimmed ? this.dimmedGreen : ColorRGBA.Green);
        } else if (value < 30000.0) {
            t.setColor(ColorRGBA.DarkGray);
            insignificant = true;
        } else {
            t.setColor(dimmed ? this.dimmedWhite : ColorRGBA.White);
        }
        return insignificant;
    }

    private void handleClick(Vector2f pos) {
        Vector3f lp = this.hideInsignificantField.getWorldTranslation();
        float width = this.font.getLineWidth(this.hideInsignificantField.getText());
        if (pos.x > lp.x && pos.x < lp.x + width && pos.y < lp.y && pos.y > lp.y - 12.0f) {
            this.hideInsignificant = !this.hideInsignificant;
            this.hideInsignificantField.setText((this.hideInsignificant ? "X " : "O ") + INSIGNIFICANT);
            if (!this.hideInsignificant) {
                this.rootLine.setExpended(true);
            }
        }
        this.rootLine.onClick(pos);
        for (StatLineView statLineView : this.lines.values()) {
            statLineView.onClick(pos);
        }
        this.layout();
    }

    private class ProfilerInputListener
    implements ActionListener {
        private ProfilerInputListener() {
        }

        @Override
        public void onAction(String name, boolean isPressed, float tpf) {
            if (name.equals(DetailedProfilerState.TOGGLE_KEY) && isPressed) {
                DetailedProfilerState.this.setEnabled(!DetailedProfilerState.this.isEnabled());
            }
            if (DetailedProfilerState.this.isEnabled() && name.equals(DetailedProfilerState.CLICK_KEY) && isPressed) {
                DetailedProfilerState.this.handleClick(DetailedProfilerState.this.getApplication().getInputManager().getCursorPosition());
            }
        }
    }

    private class StatLineView {
        BitmapText label;
        BitmapText cpuText;
        BitmapText gpuText;
        BitmapText checkBox;
        double cpuValue;
        double gpuValue;
        private boolean expended = true;
        private boolean visible = true;
        private boolean selected = false;
        String text;
        Set<StatLineView> children = new LinkedHashSet<StatLineView>();

        public StatLineView(String label) {
            this.text = label;
            this.label = new BitmapText(DetailedProfilerState.this.font);
            this.checkBox = new BitmapText(DetailedProfilerState.this.font);
            this.checkBox.setText("O");
            this.label.setText("- " + label);
            this.cpuText = new BitmapText(DetailedProfilerState.this.font);
            this.gpuText = new BitmapText(DetailedProfilerState.this.font);
        }

        public void onClick(Vector2f pos) {
            if (!this.visible) {
                return;
            }
            Vector3f lp = this.label.getWorldTranslation();
            Vector3f cp = this.checkBox.getWorldTranslation();
            if (pos.x > cp.x && pos.y < lp.y && pos.y > lp.y - 12.0f) {
                float width = DetailedProfilerState.this.font.getLineWidth(this.checkBox.getText());
                if (pos.x >= cp.x && pos.x <= cp.x + width) {
                    boolean bl = this.selected = !this.selected;
                    if (this.selected) {
                        this.checkBox.setText("X");
                    } else {
                        this.checkBox.setText("O");
                    }
                } else {
                    this.setExpended(!this.expended);
                }
            }
        }

        public void setExpended(boolean expended) {
            this.expended = expended;
            if (expended) {
                this.label.setText("- " + this.text);
            } else {
                this.label.setText("+ " + this.text);
            }
            for (StatLineView child : this.children) {
                child.setVisible(expended);
            }
        }

        public void layout(int indent) {
            this.cpuText.setText(DetailedProfilerState.this.df.format(DetailedProfilerState.this.getMsFromNs(this.cpuValue)) + "ms /");
            boolean insignificant = DetailedProfilerState.this.setColor(this.cpuText, this.cpuValue, DetailedProfilerState.this.totalTimeCpu, !this.children.isEmpty(), this.expended);
            this.gpuText.setText(" " + DetailedProfilerState.this.df.format(DetailedProfilerState.this.getMsFromNs(this.gpuValue)) + "ms");
            if ((insignificant &= DetailedProfilerState.this.setColor(this.gpuText, this.gpuValue, DetailedProfilerState.this.totalTimeGpu, !this.children.isEmpty(), this.expended)) && DetailedProfilerState.this.hideInsignificant) {
                this.setVisible(false);
            }
            if (!this.visible) {
                return;
            }
            if (this.selected) {
                this.label.setColor(ColorRGBA.Yellow);
                DetailedProfilerState.this.selectedValueCpu = DetailedProfilerState.this.selectedValueCpu + this.cpuValue;
                DetailedProfilerState.this.selectedValueGpu = DetailedProfilerState.this.selectedValueGpu + this.gpuValue;
            } else {
                this.label.setColor(ColorRGBA.White);
            }
            int y = -(DetailedProfilerState.this.height * 12 + 100);
            this.label.setLocalTranslation(10 + indent * 10, y, 0.0f);
            float gpuPos = 400.0f - DetailedProfilerState.this.font.getLineWidth(this.gpuText.getText()) - (float)(10 * (DetailedProfilerState.this.maxLevel - indent + 1));
            this.cpuText.setLocalTranslation(gpuPos - DetailedProfilerState.this.font.getLineWidth(this.cpuText.getText()), y, 0.0f);
            this.gpuText.setLocalTranslation(gpuPos, y, 0.0f);
            this.checkBox.setLocalTranslation(3.0f, y, 0.0f);
            DetailedProfilerState.this.height++;
            for (StatLineView child : this.children) {
                child.layout(indent + 1);
            }
        }

        public void updateValues(double cpu, double gpu) {
            this.cpuValue += cpu;
            this.gpuValue += gpu;
        }

        public void attachTo(Node node) {
            node.attachChild(this.label);
            node.attachChild(this.cpuText);
            node.attachChild(this.gpuText);
            node.attachChild(this.checkBox);
        }

        public void removeFromParent() {
            this.label.removeFromParent();
            this.cpuText.removeFromParent();
            this.gpuText.removeFromParent();
            this.checkBox.removeFromParent();
        }

        public void reset() {
            this.children.clear();
            this.cpuValue = 0.0;
            this.gpuValue = 0.0;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            this.label.setCullHint(visible ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
            this.cpuText.setCullHint(visible ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
            this.gpuText.setCullHint(visible ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
            this.checkBox.setCullHint(visible ? Spatial.CullHint.Dynamic : Spatial.CullHint.Always);
            for (StatLineView child : this.children) {
                child.setVisible(visible && this.expended);
            }
        }

        public String toString() {
            return this.label.getText() + " - " + DetailedProfilerState.this.df.format(DetailedProfilerState.this.getMsFromNs(this.cpuValue)) + "ms / " + DetailedProfilerState.this.df.format(DetailedProfilerState.this.getMsFromNs(this.gpuValue)) + "ms";
        }
    }
}

