/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyMorphologyFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(ApplyMorphologyFunction.class);

    @Override
    public void accept(Tile tile) {
        MorphologyLayer layer = tile.get(MorphologyLayer.class);
        if (log.isTraceEnabled()) {
            log.trace("accept(" + tile + ")  layer:" + layer);
        }
        TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        if (terrain.getVersion().getLoadVersion() >= 0L && fluid.getVersion().getLoadVersion() >= 0L) {
            if (log.isTraceEnabled()) {
                log.trace("terrain was already generated, tile:" + tile.getTileId().getWorld(null) + ", res:" + (Object)((Object)tile.getResolution()));
            }
            return;
        }
        if (layer.apply(tile)) {
            if (!terrain.getVersion().isChanged()) {
                terrain.getVersion().markChanged();
            }
            if (!fluid.getVersion().isChanged()) {
                fluid.getVersion().markChanged();
            }
        }
    }
}

