/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.core;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import com.simsilica.lemur.core.GuiMaterial;

public class LightingMaterialAdapter
implements GuiMaterial {
    private Material material;
    private ColorRGBA color;
    private Texture texture;

    public LightingMaterialAdapter(Material mat) {
        this.material = mat;
    }

    @Override
    public LightingMaterialAdapter clone() {
        try {
            LightingMaterialAdapter result = (LightingMaterialAdapter)super.clone();
            result.material = this.material.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public void setColor(ColorRGBA color) {
        this.color = color;
        if (color == null) {
            this.material.clearParam("Diffuse");
        } else {
            this.material.setColor("Diffuse", color);
        }
        this.material.setBoolean("UseMaterialColors", color != null);
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    public void setTexture(Texture t) {
        this.texture = t;
        if (this.texture == null) {
            this.material.clearParam("DiffuseMap");
        } else {
            this.material.setTexture("DiffuseMap", this.texture);
        }
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.material + "]";
    }
}

