/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.SafeArrayList;
import com.simsilica.mod.FileModPack;
import com.simsilica.mod.ModManager;
import com.simsilica.state.GameSystemsState;
import java.io.File;
import mythruna.client.GameSessionState;
import mythruna.client.view.EnvironmentState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.input.ShellState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientModManagerState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClientModManagerState.class);
    private File modRoot = new File("client-mods");
    private ModManager modManager;
    private SafeArrayList<FileModPack> fileMods = new SafeArrayList(FileModPack.class);
    private float refreshInterval = 1.0f;
    private float nextUpdate;

    public ClientModManagerState() {
        this.modManager = new ModManager();
    }

    public ModManager getModManager() {
        return this.modManager;
    }

    protected void loadModFiles() {
        for (File f : this.modRoot.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".mod.json")) continue;
            this.fileMods.add((Object)this.modManager.loadModPack(f));
        }
    }

    protected void initialize(Application app) {
        GameSessionState session = (GameSessionState)this.getState(GameSessionState.class, true);
        this.modManager.loadFromResource("/mythruna/base-includes.json");
        this.modManager.loadFromResource("/mythruna/base-apis.json");
        this.modManager.loadFromResource("/mythruna/base-time-api.json");
        this.modManager.loadFromResource("/mythruna/logging/client-log.json");
        this.modManager.loadFromResource("/mythruna/shell/base-shell.json");
        this.modManager.loadFromResource("/client-mods/standard-environment.json");
        if (this.modRoot.exists()) {
            this.loadModFiles();
        }
        this.modManager.setGlobalBinding("gameSession", (Object)session.getGameSession());
        this.modManager.setGlobalBinding("world", (Object)session.getWorld());
        this.modManager.setGlobalBinding("entityData", (Object)session.getEntityData());
        this.modManager.setGlobalBinding("timeSettings", (Object)session.getTimeSettings());
        this.modManager.setGlobalBinding("gameSystems", (Object)((GameSystemsState)this.getState(GameSystemsState.class, true)).getGameSystemManager());
        this.modManager.setGlobalBinding("env", (Object)this.getState(EnvironmentState.class, true));
        this.modManager.setGlobalBinding("worldTime", (Object)this.getState(WorldTimeState.class, true));
        this.modManager.setGlobalBinding("clientShell", (Object)((ShellState)this.getState(ShellState.class, true)).getClientShell());
        this.modManager.setGlobalBinding("stateManager", (Object)app.getStateManager());
        this.modManager.initialize();
    }

    protected void cleanup(Application app) {
        this.modManager.terminate();
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        this.nextUpdate += tpf;
        if (this.nextUpdate > this.refreshInterval) {
            this.nextUpdate = 0.0f;
            this.checkMods();
        }
    }

    protected void checkMods() {
        for (FileModPack mod : (FileModPack[])this.fileMods.getArray()) {
            if (!mod.hasChanged()) continue;
            log.info("Reloading:" + mod);
            try {
                mod.reload();
            }
            catch (Exception e) {
                log.error("Error reloading:" + mod, (Throwable)e);
            }
        }
    }
}

