/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.post.filters.ColorOverlayFilter;
import com.jme3.post.filters.DepthOfFieldFilter;
import com.jme3.post.filters.RadialBlurFilter;
import com.jme3.system.AppSettings;
import com.simsilica.fx.shadow.DropShadowFilter;
import mythruna.client.post.ClippedDepthOfFieldFilter;
import mythruna.client.post.UnderwaterFilter;
import mythruna.client.view.DepthOfField;

public class PostProcessingState
extends BaseAppState {
    private FilterPostProcessor fpp;
    private BloomFilter bloom;
    private DropShadowFilter shadows;
    private DepthOfFieldFilter depthOfField;
    private RadialBlurFilter radialBlur;
    private ColorOverlayFilter colorOverlay;
    private UnderwaterFilter underwater;
    private ClippedDepthOfFieldFilter clippedBlur;

    public DropShadowFilter getDropShadows() {
        return this.shadows;
    }

    public DepthOfFieldFilter getDepthOfFieldFilter() {
        return this.depthOfField;
    }

    public BloomFilter getBloomFilter() {
        return this.bloom;
    }

    public RadialBlurFilter getRadialBlurFilter() {
        return this.radialBlur;
    }

    public ColorOverlayFilter getColorOverlayFilter() {
        return this.colorOverlay;
    }

    public UnderwaterFilter getUnderwaterFilter() {
        return this.underwater;
    }

    public ClippedDepthOfFieldFilter getClippedBlurFilter() {
        return this.clippedBlur;
    }

    public void setWaterLevel(double waterLevel) {
        if (waterLevel <= 0.0) {
            this.underwater.setEnabled(false);
            this.clippedBlur.setEnabled(false);
        } else {
            this.underwater.setEnabled(true);
            this.clippedBlur.setEnabled(true);
            this.underwater.setWaterLevel((float)waterLevel);
            this.clippedBlur.setYClip((float)waterLevel);
        }
    }

    public void setDepthOfField(DepthOfField dof) {
        if (dof == null) {
            this.depthOfField.setEnabled(false);
        } else {
            dof.apply(this.depthOfField);
            this.depthOfField.setEnabled(true);
        }
    }

    protected void initialize(Application app) {
        AssetManager assets = app.getAssetManager();
        this.fpp = new FilterPostProcessor(assets);
        AppSettings appSettings = app.getContext().getSettings();
        if (appSettings.getSamples() != 0) {
            this.fpp.setNumSamples(appSettings.getSamples());
        }
        this.shadows = new DropShadowFilter();
        this.shadows.setEnabled(true);
        this.fpp.addFilter((Filter)this.shadows);
        this.bloom = new BloomFilter();
        this.bloom.setEnabled(true);
        this.bloom.setDownSamplingFactor(4.0f);
        this.bloom.setBlurScale(1.0f);
        this.bloom.setExposurePower(10.0f);
        this.bloom.setExposureCutOff(0.2f);
        this.bloom.setBloomIntensity(0.3f);
        this.fpp.addFilter((Filter)this.bloom);
        this.colorOverlay = new ColorOverlayFilter(new ColorRGBA(0.5f, 0.7f, 1.0f, 1.0f));
        this.colorOverlay.setEnabled(false);
        this.fpp.addFilter((Filter)this.colorOverlay);
        this.underwater = new UnderwaterFilter();
        this.underwater.setEnabled(false);
        this.fpp.addFilter((Filter)this.underwater);
        this.clippedBlur = new ClippedDepthOfFieldFilter();
        this.clippedBlur.setEnabled(false);
        this.clippedBlur.setFocusDistance(1.0f);
        this.clippedBlur.setFocusRange(15.0f);
        this.clippedBlur.setBlurScale(2.0f);
        this.clippedBlur.setBlurThreshold(0.1f);
        this.fpp.addFilter((Filter)this.clippedBlur);
        this.depthOfField = new DepthOfFieldFilter();
        this.depthOfField.setEnabled(false);
        this.depthOfField.setFocusDistance(1.0f);
        this.depthOfField.setFocusRange(15.0f);
        this.depthOfField.setBlurScale(2.0f);
        this.depthOfField.setBlurThreshold(0.1f);
        this.fpp.addFilter((Filter)this.depthOfField);
        this.radialBlur = new RadialBlurFilter();
        this.radialBlur.setEnabled(false);
        this.radialBlur.setSampleStrength(1.5f);
        this.radialBlur.setSampleDistance(0.3f);
        this.fpp.addFilter((Filter)this.radialBlur);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().getViewPort().addProcessor((SceneProcessor)this.fpp);
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        this.getApplication().getViewPort().removeProcessor((SceneProcessor)this.fpp);
    }
}

