/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.assembly;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.MatParamOverride;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Quad;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.CellUtils;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.io.BlockObject;
import com.simsilica.mblock.io.BlockTypeData;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockShape;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.assembly.Joint;
import mythruna.assembly.Subassembly;
import mythruna.assembly.TargetName;
import mythruna.assembly.io.SubassemblyJson;
import mythruna.assembly.io.SubassemblyProtocol;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.assembly.AssemblyFileSelectorDialog;
import mythruna.client.ui.assembly.AssemblyFunctions;
import mythruna.client.ui.assembly.AssemblySelectorState;
import mythruna.client.ui.assembly.CreateJointDialog;
import mythruna.client.ui.assembly.JointDurationEditor;
import mythruna.client.ui.assembly.JointEditor;
import mythruna.client.ui.assembly.SubassemblyEditor;
import mythruna.client.view.geom.MythrunaGeometryFactory;
import mythruna.es.BlueprintInfo;
import mythruna.es.ObjectName;
import mythruna.net.AssemblyBlueprintData;
import mythruna.net.BlueprintData;
import mythruna.shape.ShapeName;
import mythruna.shape.ShapeRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyEditorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(AssemblyEditorState.class);
    public static final ColorRGBA DEFAULT_HAIR_COLOR = new ColorRGBA(0.29803923f, 0.08627451f, 0.03529412f, 1.0f);
    public static final ColorRGBA DEFAULT_SKIN_COLOR = new ColorRGBA(0.6313726f, 0.4745098f, 0.28235295f, 1.0f);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private Node rootNode = new Node("assemblyRoot");
    private Spatial background;
    private Node platform = new Node("platform");
    private Vector2f screenSize = new Vector2f();
    private Vector2f center = new Vector2f();
    private Node assemblyNode = new Node("assembly");
    private InputHandler inputHandler = new InputHandler();
    private float zoom = 250.0f;
    private float maxZoom = 750.0f;
    private float yaw = 0.0f;
    private float pitch = 0.4f;
    private float minPitch = 0.0f;
    private float maxPitch = 1.4137167f;
    private float yOffset = -200.0f;
    private MouseHandler mouseHandler = new MouseHandler();
    private GeometryFactory geomFactory;
    private Container objectSettings;
    private TextField designName;
    private TextField objectName;
    private Container sidebar;
    private BlueprintContainer blueprintsContainer;
    private VersionedList<Blueprint> blueprintList = new VersionedList();
    private Container blueprintDialog;
    private ListBox<Blueprint> blueprints;
    private AssemblyBlueprintData design;
    private Subassembly mainAssembly;
    private Map<Spatial, PartView> viewIndex = new HashMap<Spatial, PartView>();
    private PartView baseGroup;
    private Container groupWindow;
    private VersionedList<PartView> groupList = new VersionedList();
    private ListBox<PartView> groups;
    private VersionedReference<Integer> selectedGroupRef;
    private Multimap<PartView, PartView> groupIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    private Container partSelectionWindow;
    private VersionedList<PartView> partList = new VersionedList();
    private ListBox<PartView> partSelection;
    private VersionedReference<Integer> selectedPartRef;
    private Container partEditorWindow;
    private SubassemblyEditor subassemblyEditor;
    private VersionedReference<Subassembly> subassemblyRef;
    private JointEditor jointEditor;
    private VersionedReference<Joint> jointRef;
    private JointDurationEditor jointDurationEditor;
    private VersionedReference<Double> mixRef;
    private boolean developmentMode;
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private PartView editedView;
    private Geometry selectionBoxTemplate;
    private ColorRGBA selectionColor = new ColorRGBA(0.25f, 2.0f, 2.0f, 1.0f);
    private Spatial crosshairTemplate;
    private CreateJointDialog createJointDialog;
    private Label spacer;
    private float time = 0.0f;

    public AssemblyEditorState() {
        this(false);
    }

    public AssemblyEditorState(boolean enabled) {
        this.setEnabled(enabled);
    }

    public void editDesign(AssemblyBlueprintData design) {
        if (!Objects.equals(this.design, design)) {
            this.design = design;
            if (design.subassembly == null) {
                log.error("Design subassembly is null:" + design);
                ((GuiState)this.getState(GuiState.class)).showError("Invalid Design", "Design data is missing.");
                return;
            }
            Subassembly clone = SubassemblyProtocol.fromBytes((byte[])SubassemblyProtocol.toBytes((Subassembly)design.subassembly));
            this.setAssembly(clone);
            this.designName.setText(design.name);
            this.objectName.setText(design.objectName);
        }
        log.info("setting enabled true");
        this.setEnabled(true);
        ((AssemblySelectorState)this.getState(AssemblySelectorState.class)).hide();
    }

    protected void save() {
        this.design.name = this.designName.getText();
        this.design.objectName = this.objectName.getText();
        this.design.subassembly = SubassemblyProtocol.fromBytes((byte[])SubassemblyProtocol.toBytes((Subassembly)this.mainAssembly));
        ((AssemblySelectorState)this.getState(AssemblySelectorState.class)).saveEdit(this.design, true);
    }

    protected void back() {
        ((OptionPanelState)this.getState(OptionPanelState.class)).show("Abandon Changes?", "Really lose changes?  Or Save?", new Action[]{new CallMethodAction("Save Changes", (Object)this, "save"), new CallMethodAction("Discard Changes", (Object)this, "doBack"), new EmptyAction("Cancel")});
    }

    protected void doBack() {
        ((AssemblySelectorState)this.getState(AssemblySelectorState.class)).cancelEdit();
    }

    public void setAssembly(Subassembly sub) {
        if (Objects.equals(sub, this.mainAssembly)) {
            return;
        }
        this.mainAssembly = sub;
        this.resetEditor();
    }

    public Subassembly getAssembly() {
        return this.mainAssembly;
    }

    protected void addPart() {
        PartView group = (PartView)this.groups.getSelectedItem();
        if (group == null) {
            return;
        }
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.blueprintDialog);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.blueprintDialog);
    }

    protected void addJoint() {
        PartView group = (PartView)this.groups.getSelectedItem();
        if (group == null) {
            return;
        }
        int count = 1;
        for (PartView view : this.groupList) {
            if (!(view.part instanceof Joint)) continue;
            ++count;
        }
        this.createJointDialog.editJoint(new Joint("Joint " + count), joint -> this.addJoint((Joint)joint));
    }

    protected Joint findJoint(String name) {
        for (PartView view : this.groupList) {
            if (!(view.part instanceof Joint) || !Objects.equals(name, view.part.getName())) continue;
            return (Joint)view.part;
        }
        return null;
    }

    protected void addJoint(Joint joint) {
        log.info("addJoint(" + joint + ")");
        Joint existing = this.findJoint(joint.getName());
        if (existing != null) {
            this.createJointDialog.editJoint(joint, j -> this.addJoint((Joint)j));
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Joint Creation Error", "Joint names must be unique.", new Action[0]);
        }
        PartView group = (PartView)this.groups.getSelectedItem();
        group.part.addChild((Subassembly)joint);
        PartView view = new PartView(group, (Subassembly)joint);
        this.groupIndex.put((Object)group, (Object)view);
        this.groupList.add((Object)view);
        this.refreshParts();
        this.getApplication().enqueue(() -> this.selectView(view));
    }

    protected void removePart() {
        PartView part = (PartView)this.partSelection.getSelectedItem();
        if (part == null) {
            return;
        }
        part.parent.part.removeChild(part.part);
        this.groupIndex.values().remove(part);
        part.release();
        if (this.groupList.remove((Object)part)) {
            this.groupIndex.removeAll((Object)part);
        }
        this.refreshParts();
        Integer index = this.partSelection.getSelectionModel().getSelection();
        if (index != null) {
            this.partSelection.getSelectionModel().clear();
            this.partSelection.getSelectionModel().setSelection(index);
        }
    }

    protected void selectBlueprint() {
        Blueprint selected = (Blueprint)this.blueprints.getSelectedItem();
        if (selected == null) {
            return;
        }
        PartView group = (PartView)this.groups.getSelectedItem();
        Subassembly part = new Subassembly(selected.name, ShapeName.parse((String)selected.resourceName));
        part.setScale(0.25);
        group.part.addChild(part);
        PartView view = new PartView(group, part);
        view.center();
        this.groupIndex.put((Object)group, (Object)view);
        this.refreshParts();
        this.blueprintDialog.removeFromParent();
        this.getApplication().enqueue(() -> this.selectView(view));
    }

    protected void cancelBlueprint() {
        this.blueprintDialog.removeFromParent();
    }

    protected void initialize(Application app) {
        boolean bl = this.developmentMode = this.getState(GameSessionState.class) == null;
        if (!this.developmentMode) {
            this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
            this.player = this.sessionState.getGameSession().getAvatar();
            this.ed = this.sessionState.getEntityData();
            this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
            this.mainAssembly = new Subassembly("base", null);
            this.blueprintsContainer = new BlueprintContainer(this.player, this.ed);
        } else {
            try {
                BlockTypeData global = BlockTypeData.load((String)"/blocks.bset");
                BlockTypeIndex.reset();
                BlockTypeIndex.initialize((BlockTypeData)global);
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/materials.mset");
                if (in == null) {
                    throw new RuntimeException("Resource /materials.mset not found");
                }
                Map materials = MaterialRegistry.loadCompiledMaterials((AssetManager)this.getApplication().getAssetManager(), (InputStream)in);
                this.geomFactory = new MythrunaGeometryFactory(true, materials);
                this.shapeFactory = ShapeRegistryBuilder.createRegistry(null, id -> null, id -> null);
                this.blueprintList.add((Object)new Blueprint("Chest Bottom", "/Models/objects/sm-chest1-bottom.blocks"));
                this.blueprintList.add((Object)new Blueprint("Chest Top", "/Models/objects/sm-chest1-top.blocks"));
                this.blueprintList.add((Object)new Blueprint("Door Frame", "/Models/objects/wood-door-frame.blocks"));
                this.blueprintList.add((Object)new Blueprint("Door", "/Models/objects/wood-door1.carved.blocks"));
                this.blueprintList.add((Object)new Blueprint("Desk", "/Models/objects/desk.carved.blocks"));
                this.blueprintList.add((Object)new Blueprint("Drawer", "/Models/objects/drawer1.blocks"));
                this.blueprintList.add((Object)new Blueprint("Cabinet Bottom", "/Models/objects/wood-cabinet-bottom.blocks"));
                this.blueprintList.add((Object)new Blueprint("Door Left", "/Models/objects/wood-door-2x3-left.blocks"));
                this.blueprintList.add((Object)new Blueprint("Door Right", "/Models/objects/wood-door-2x3-right.blocks"));
                this.blueprintList.add((Object)new Blueprint("Cabinet Ring", "/Models/objects/wood-ring.blocks"));
                File existing = new File("test.assembly");
                if (existing.exists()) {
                    Subassembly loaded = SubassemblyJson.load((File)existing);
                    if (loaded.getShapeName() != null) {
                        this.mainAssembly = new Subassembly();
                        this.mainAssembly.setName("base");
                        this.mainAssembly.addChild(loaded);
                    } else {
                        this.mainAssembly = loaded;
                    }
                } else {
                    this.mainAssembly = new Subassembly();
                    this.mainAssembly.setName("base");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting up dev mode", e);
            }
        }
        this.fixBadJoints(this.mainAssembly);
        this.screenSize.set(((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize());
        this.center.set(this.screenSize).multLocal(0.5f);
        log.info("center:" + this.center);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        AssemblyFunctions.initializeDefaultMappings(inputMapper);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{AssemblyFunctions.F_PAN, AssemblyFunctions.F_CRANE, AssemblyFunctions.F_ZOOM});
        inputMapper.addStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{AssemblyFunctions.F_UNDO, AssemblyFunctions.F_REDO, AssemblyFunctions.F_IMPORT, AssemblyFunctions.F_EXPORT});
        this.createJointDialog = new CreateJointDialog();
        this.objectSettings = new Container(new ElementId("window"));
        this.objectSettings.addChild((Node)new Label("Design Settings:", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.objectSettings.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[0]);
        properties.addChild((Node)new Label("Design Name:"), new Object[0]);
        this.designName = (TextField)properties.addChild((Node)new TextField("Unnamed"), new Object[]{1});
        properties.addChild((Node)new Label("Object Name:"), new Object[0]);
        this.objectName = (TextField)properties.addChild((Node)new TextField("Object"), new Object[]{1});
        Container buttons = (Container)this.objectSettings.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "save")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "back")), new Object[0]);
        this.sidebar = new Container();
        float minWidth = 300.0f;
        this.groupWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.groupWindow.setInsets(new Insets3f(0.0f, 0.0f, 20.0f, 0.0f));
        Label label = (Label)this.groupWindow.addChild((Node)new Label("Part Groups", new ElementId("window.title")), new Object[0]);
        Vector3f pref = label.getPreferredSize();
        pref.x = Math.max(minWidth, pref.x);
        label.setPreferredSize(pref);
        this.groups = (ListBox)this.groupWindow.addChild((Node)new ListBox(this.groupList), new Object[0]);
        this.groups.getSelectionModel().setSelection(Integer.valueOf(0));
        this.selectedGroupRef = this.groups.getSelectionModel().createSelectionReference();
        this.partSelectionWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.partSelectionWindow.addChild((Node)new Label("Parts", new ElementId("window.title")), new Object[0]);
        this.partSelection = (ListBox)this.partSelectionWindow.addChild((Node)new ListBox(this.partList), new Object[0]);
        this.selectedPartRef = this.partSelection.getSelectionModel().createSelectionReference();
        buttons = (Container)this.partSelectionWindow.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Add Part", (Object)this, "addPart")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Add Joint", (Object)this, "addJoint")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "removePart")), new Object[0]);
        this.blueprintDialog = new Container(new ElementId("window"));
        this.blueprintDialog.addChild((Node)new Label("Select Blueprint", new ElementId("window.title")), new Object[0]);
        this.blueprints = (ListBox)this.blueprintDialog.addChild((Node)new ListBox(this.blueprintList), new Object[0]);
        buttons = (Container)this.blueprintDialog.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Select", (Object)this, "selectBlueprint")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancelBlueprint")), new Object[0]);
        this.partEditorWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.subassemblyEditor = new SubassemblyEditor();
        this.subassemblyRef = this.subassemblyEditor.createReference();
        this.jointEditor = new JointEditor();
        this.jointRef = this.jointEditor.createReference();
        this.jointDurationEditor = new JointDurationEditor();
        this.mixRef = this.jointDurationEditor.createMixReference();
        this.spacer = (Label)this.sidebar.addChild((Node)new Label(""), new Object[0]);
        pref = this.spacer.getPreferredSize();
        pref.x = Math.max(400.0f, pref.x);
        this.spacer.setPreferredSize(pref);
        this.background = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).createVignette();
        this.rootNode.attachChild(this.background);
        this.rootNode.attachChild((Spatial)this.platform);
        float percent = 0.8f;
        float scale = this.screenSize.y * percent * 0.5f;
        this.platform.setLocalScale(scale);
        this.platform.attachChild((Spatial)this.assemblyNode);
        this.assemblyNode.move(0.0f, -0.3f, 0.0f);
        CursorEventControl.addListenersToSpatial((Spatial)this.assemblyNode, (CursorListener[])new CursorListener[]{this.mouseHandler});
        CellArray cells = this.loadResource("/Models/objects/workbench1.carved.blocks");
        Node bench = new Node("bench");
        this.geomFactory.generateBlocks(bench, cells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        bench.move(-0.875f, -1.125f, -0.5625f);
        bench.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        Texture oldPaper = this.getApplication().getAssetManager().loadTexture("Interface/old-paper-flattened.png");
        Texture grid = this.getApplication().getAssetManager().loadTexture("Interface/DrawnGridx8.png");
        grid.setWrap(Texture.WrapMode.Repeat);
        Quad mesh = new Quad(6.5f, 2.5f);
        Geometry paper = new Geometry("paper", (Mesh)mesh);
        paper.setMaterial(GuiGlobals.getInstance().createMaterial(oldPaper, true).getMaterial());
        paper.rotate(-1.5707964f, 0.0f, 0.0f);
        paper.move(0.25f, 3.31f, 3.75f);
        paper.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        paper.setQueueBucket(RenderQueue.Bucket.Transparent);
        LayerComparator.setLayer((Spatial)paper, (int)1);
        bench.attachChild((Spatial)paper);
        mesh = new Quad(6.0f, 2.0f);
        mesh.scaleTextureCoordinates(new Vector2f(6.0f, 2.0f));
        paper = new Geometry("paper-grid", (Mesh)mesh);
        paper.setMaterial(GuiGlobals.getInstance().createMaterial(grid, true).getMaterial());
        paper.rotate(-1.5707964f, 0.0f, 0.0f);
        paper.move(0.5f, 3.315f, 3.5f);
        paper.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        paper.setQueueBucket(RenderQueue.Bucket.Transparent);
        LayerComparator.setLayer((Spatial)paper, (int)2);
        bench.attachChild((Spatial)paper);
        bench.setLocalScale(0.25f);
        this.platform.attachChild((Spatial)bench);
        this.selectionBoxTemplate = new Geometry(this, "selectionBox", (Mesh)new Box(1.0f, 1.0f, 1.0f)){

            public int collideWith(Collidable other, CollisionResults results) {
                return 0;
            }
        };
        Texture drawnBox = this.getApplication().getAssetManager().loadTexture("Interface/DrawnGridx8-border.png");
        drawnBox.setWrap(Texture.WrapMode.Repeat);
        this.selectionBoxTemplate.setMaterial(GuiGlobals.getInstance().createMaterial(drawnBox, false).getMaterial());
        this.selectionBoxTemplate.getMaterial().setColor("Color", this.selectionColor);
        this.selectionBoxTemplate.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.selectionBoxTemplate.setQueueBucket(RenderQueue.Bucket.Transparent);
        LayerComparator.setLayer((Spatial)this.selectionBoxTemplate, (int)3);
        this.crosshairTemplate = this.getApplication().getAssetManager().loadModel("Interface/axes.gltf.j3o");
        this.crosshairTemplate.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Green, true).getMaterial());
        this.crosshairTemplate.setLocalScale(0.25f);
        this.resetEditor();
    }

    protected void resetEditor() {
        this.setEditedView(null);
        this.assemblyNode.detachAllChildren();
        this.viewIndex.clear();
        this.groupList.clear();
        this.groups.getSelectionModel().clear();
        this.partList.clear();
        this.partSelection.getSelectionModel().clear();
        this.baseGroup = new PartView(null, this.mainAssembly);
        this.baseGroup.applyChanges();
        this.assemblyNode.attachChild((Spatial)this.baseGroup.view);
        if (this.mainAssembly.hasChildren()) {
            this.addChildren(this.baseGroup, this.mainAssembly);
        } else {
            this.groupList.add((Object)this.baseGroup);
        }
        this.refreshParts();
        this.groups.getSelectionModel().setSelection(Integer.valueOf(0));
    }

    protected void addChildren(PartView parent, Subassembly sub) {
        if (!sub.hasChildren()) {
            return;
        }
        this.groupList.add((Object)parent);
        for (Subassembly child : sub) {
            PartView view = new PartView(parent, child);
            view.applyChanges();
            this.groupIndex.put((Object)parent, (Object)view);
            this.addChildren(view, child);
        }
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{AssemblyFunctions.F_PAN, AssemblyFunctions.F_CRANE, AssemblyFunctions.F_ZOOM});
        inputMapper.removeStateListener((StateFunctionListener)this.inputHandler, new FunctionId[]{AssemblyFunctions.F_UNDO, AssemblyFunctions.F_REDO, AssemblyFunctions.F_IMPORT, AssemblyFunctions.F_EXPORT});
        if (this.developmentMode) {
            File file = new File("test.assembly");
            SubassemblyJson.store((Subassembly)this.mainAssembly, (File)file);
        }
    }

    protected void onEnable() {
        log.info("onEnable()");
        if (!this.developmentMode) {
            this.blueprintsContainer.start();
        }
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup("Assembly");
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.rootNode);
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.sidebar);
        this.updateLayout();
        if (!this.developmentMode) {
            Container playerMenuWindow = ((PlayerMenuState)this.getState(PlayerMenuState.class)).getWindow();
            ((AssemblySelectorState)this.getState(AssemblySelectorState.class)).hide();
            Vector3f pref = this.objectSettings.getPreferredSize();
            pref.x = Math.max(pref.x, 350.0f);
            this.objectSettings.setPreferredSize(pref);
            this.objectSettings.setLocalTranslation(playerMenuWindow.getLocalTranslation());
            this.objectSettings.move(0.0f, 0.0f, 100.0f);
            ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.objectSettings);
        }
        this.resetModel();
        if (this.groups.getSelectedItem() == null) {
            this.groups.getSelectionModel().setSelection(Integer.valueOf(0));
        }
    }

    protected boolean isCarved(Subassembly part) {
        if (part.getShapeName() == null) {
            return false;
        }
        if (part.getShapeName().getName().startsWith("c_")) {
            return true;
        }
        return part.getShapeName().getName().endsWith(".carved");
    }

    protected void resetModel() {
        log.info("resetModel()");
        this.updateRotation();
    }

    protected void updateLayout() {
        float x = this.screenSize.x * 0.95f;
        float y = this.screenSize.y * 0.95f;
        Vector3f pref = this.sidebar.getPreferredSize();
        this.sidebar.setLocalTranslation(x - pref.x, y, 0.0f);
    }

    protected CellArray loadCells(ShapeName name) {
        if ("ca".equals(name.getType())) {
            String ca = name.getName();
            if (ca.startsWith("c_")) {
                ca = ca.substring(2);
            }
            CellArrayId id = CellArrayId.fromString((String)ca);
            return this.sessionState.getGameSession().getCellArray(id);
        }
        return this.loadResource(name.getFullName());
    }

    protected CellArray loadResource(String name) {
        try {
            log.info("loading:" + ((Object)((Object)this)).getClass().getResource(name));
            return BlocksFileFormat.loadCellArray((String)name);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading block resource:" + name, e);
        }
    }

    public void update(float tpf) {
        if (this.developmentMode || this.blueprintsContainer.update()) {
            // empty if block
        }
        if (this.selectedGroupRef.update()) {
            this.partSelection.getSelectionModel().clear();
            this.refreshParts();
        }
        if (this.selectedPartRef.update()) {
            this.setEditedView((PartView)this.partSelection.getSelectedItem());
        }
        if (this.subassemblyRef.update() && this.editedView != null) {
            this.editedView.applyChanges();
        }
        if (this.jointRef.update() && this.editedView != null) {
            this.editedView.applyChanges();
        }
        if (this.mixRef.update() && this.editedView != null && this.editedView.part instanceof Joint) {
            String verb = ((Joint)this.editedView.part).getTargetState().getVerb();
            this.setMix(verb, this.smoothStep((Double)this.mixRef.get() / 100.0));
        }
        this.time += tpf * 2.0f;
        if (this.time > (float)Math.PI * 2) {
            this.time -= (float)Math.PI * 2;
        }
        this.selectionColor.a = 0.2f + FastMath.abs((float)FastMath.cos((float)this.time)) * 0.8f;
    }

    protected void onDisable() {
        log.info("onDisable()", new Throwable("stack trace"));
        if (!this.developmentMode) {
            this.blueprintsContainer.stop();
        }
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup("Assembly");
        this.rootNode.removeFromParent();
        this.sidebar.removeFromParent();
        this.objectSettings.removeFromParent();
        ((AssemblySelectorState)this.getState(AssemblySelectorState.class)).show();
    }

    protected void updateRotation() {
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        this.platform.setLocalRotation(rot);
        this.platform.setLocalTranslation(this.center.x, this.center.y, this.zoom);
    }

    protected void refreshParts() {
        this.partList.clear();
        PartView group = (PartView)this.groups.getSelectedItem();
        PartView currentSelection = (PartView)this.partSelection.getSelectedItem();
        for (PartView view : this.groupIndex.get((Object)group)) {
            this.partList.add((Object)view);
        }
        if (currentSelection != null && this.partList.indexOf((Object)currentSelection) >= 0) {
            this.partSelection.setSelectedItem((Object)currentSelection);
        }
        this.refreshJoints();
    }

    protected void refreshJoints() {
        ArrayList<Joint> joints = new ArrayList<Joint>();
        if (this.editedView != null && this.editedView.part instanceof Joint) {
            String verb = ((Joint)this.editedView.part).getTargetState().getVerb();
            for (PartView view : this.groupIndex.values()) {
                Joint joint;
                if (!(view.part instanceof Joint) || !(joint = (Joint)view.part).matchesVerb(verb)) continue;
                joints.add(joint);
            }
        }
        this.jointDurationEditor.setJoints(joints);
    }

    protected PartView findGroup(PartView view) {
        for (Map.Entry e : this.groupIndex.entries()) {
            if (e.getValue() != view) continue;
            return (PartView)e.getKey();
        }
        return null;
    }

    protected void selectView(PartView view) {
        log.info("selectView(" + view + ")");
        PartView group = this.findGroup(view);
        if (group == null) {
            log.warn("No group found for view:" + view);
            return;
        }
        if (this.groups.getSelectedItem() != group) {
            this.groups.setSelectedItem((Object)group);
            this.refreshParts();
        }
        this.partSelection.getSelectionModel().clear();
        this.getApplication().enqueue(() -> this.partSelection.setSelectedItem((Object)view));
    }

    protected void setEditedView(PartView view) {
        log.info("setEditedView(" + view + ")");
        if (this.editedView == view) {
            return;
        }
        if (this.editedView != null) {
            this.editedView.setShowSelection(false);
            this.partEditorWindow.clearChildren();
        }
        this.editedView = view;
        if (this.editedView != null) {
            this.editedView.setShowSelection(true);
            log.info("setting selected part to:" + view.part + " @" + System.identityHashCode(view.part));
            if (view.part instanceof Joint) {
                this.jointEditor.setJoint((Joint)view.part);
                this.partEditorWindow.addChild((Node)this.jointEditor, new Object[0]);
                this.partEditorWindow.addChild((Node)this.jointDurationEditor, new Object[0]);
            } else {
                this.subassemblyEditor.setSubassembly(view.part);
                this.partEditorWindow.addChild((Node)this.subassemblyEditor, new Object[0]);
            }
            this.refreshJoints();
        }
    }

    protected double smoothStep(double t) {
        if (t < 0.0) {
            return 0.0;
        }
        if (t > 1.0) {
            return 1.0;
        }
        return t * t * (3.0 - 2.0 * t);
    }

    protected void setMix(String verb, double mix) {
        for (PartView view : this.groupIndex.values()) {
            Joint joint;
            if (!(view.part instanceof Joint) || !(joint = (Joint)view.part).matchesVerb(verb)) continue;
            view.setMix(mix);
        }
    }

    protected void fixBadJoints(Subassembly sub) {
        if (sub instanceof Joint) {
            Joint joint = (Joint)sub;
            if (joint.getRestingState() == null) {
                joint.setRestingState(new TargetName("Close", "Closed"));
            }
            if (joint.getTargetState() == null) {
                joint.setTargetState(new TargetName("Open"));
            }
        }
        for (Subassembly child : sub) {
            this.fixBadJoints(child);
        }
    }

    protected void exportCurrent() {
        String name = this.designName.getText() + "-" + this.objectName.getText() + ".assembly";
        log.info("Export current:" + name);
        try {
            File target = new File("assemblies", name);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            Subassembly clone = SubassemblyProtocol.fromBytes((byte[])SubassemblyProtocol.toBytes((Subassembly)this.mainAssembly));
            this.exportBlocks(clone);
            SubassemblyJson.store((Subassembly)clone, (File)target);
        }
        catch (Exception e) {
            log.error("Error writing:" + name, (Throwable)e);
        }
    }

    protected void selectImport() {
        AssemblyFileSelectorDialog dialog = new AssemblyFileSelectorDialog(new File("assemblies"), file -> this.importFile((File)file));
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)dialog);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)dialog, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected void importFile(File f) {
        log.info("importFile(" + f + ")");
        try {
            Subassembly asm = SubassemblyJson.load((File)f);
            this.importBlocks(asm, new HashMap<ShapeName, ShapeName>());
            this.setAssembly(asm);
        }
        catch (Exception e) {
            log.error("Error reading:" + f, (Throwable)e);
        }
    }

    protected void exportBlocks(Subassembly sub) {
        ShapeName shape = sub.getShapeName();
        if (shape != null && "ca".equals(shape.getType())) {
            ShapeName newName;
            File target;
            Object name = sub.getName();
            name = name == null ? shape.getName() : (String)name + "-" + shape.getName();
            name = (String)name + ".ca";
            if (shape.getName().startsWith("c_")) {
                name = (String)name + ".carved";
            }
            if (!(target = new File("assemblies", (newName = new ShapeName("blocks", (String)name)).getFullName())).getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            CellArray cells = this.loadCells(shape);
            try {
                log.info("Writing:" + target);
                BlocksFileFormat.writeBlocks((BlockObject)new BlockObject(cells, new CellArray(20)), (File)target);
                sub.setShapeName(newName);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing:" + target, e);
            }
        }
        for (Subassembly child : sub) {
            this.exportBlocks(child);
        }
    }

    protected void importBlocks(Subassembly sub, Map<ShapeName, ShapeName> resolved) {
        ShapeName shape = sub.getShapeName();
        if (shape != null) {
            ShapeName newShape = resolved.get(shape);
            if (newShape == null) {
                newShape = this.importShape(sub, shape);
                resolved.put(shape, newShape);
            }
            sub.setShapeName(newShape);
        }
        for (Subassembly child : sub) {
            this.importBlocks(child, resolved);
        }
    }

    protected ShapeName importShape(Subassembly sub, ShapeName shape) {
        File source = new File("assemblies", shape.getFullName());
        if (!source.exists()) {
            log.info("Skipping unknown file:" + source);
            return shape;
        }
        try {
            BlockObject blocks = BlocksFileFormat.readBlocks((File)source, (boolean)false);
            String name = sub.getName();
            if (name == null) {
                name = shape.getName();
            }
            boolean carved = shape.getName().endsWith(".carved");
            String bpName = name + " Blueprint x" + Long.toHexString(System.currentTimeMillis());
            Vec3i[] range = CellUtils.calculateSize((CellArray)blocks.cells);
            Vec3i offset = range[0];
            BlueprintData bpData = new BlueprintData(null, bpName, name, 0.25, offset, blocks.cells, carved);
            log.info("Importing blueprint:" + bpName);
            this.sessionState.getGameSession().saveBlueprintData(bpData);
            ComponentFilter filter = BlueprintInfo.parentFilter((EntityId)this.player);
            for (EntityId id : this.ed.findEntities(filter, new Class[]{BlueprintInfo.class, ShapeInfo.class, ObjectName.class})) {
                BlueprintInfo bp = (BlueprintInfo)this.ed.getComponent(id, BlueprintInfo.class);
                log.info("bp id:" + id + "  name:" + bp.getName());
                ShapeInfo si = (ShapeInfo)this.ed.getComponent(id, ShapeInfo.class);
                if (!bpName.equals(bp.getName())) continue;
                String shapeId = si.getShapeName(this.ed);
                return ShapeName.parse((String)shapeId);
            }
            for (int i = 0; i < 5; ++i) {
                log.warn("Blueprint not found for:" + bpName);
                Thread.sleep(1000L);
                log.info("Trying again:" + (i + 1) + "/5");
                for (EntityId id : this.ed.findEntities(filter, new Class[]{BlueprintInfo.class, ShapeInfo.class, ObjectName.class})) {
                    BlueprintInfo bp = (BlueprintInfo)this.ed.getComponent(id, BlueprintInfo.class);
                    log.info("bp id:" + id + "  name:" + bp.getName());
                    ShapeInfo si = (ShapeInfo)this.ed.getComponent(id, ShapeInfo.class);
                    if (!bpName.equals(bp.getName())) continue;
                    String shapeId = si.getShapeName(this.ed);
                    return ShapeName.parse((String)shapeId);
                }
            }
            return shape;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error reading:" + source, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading:" + source, e);
        }
    }

    protected void undo() {
    }

    protected void redo() {
    }

    protected Node createView(Subassembly part, CellArray cells) {
        Node result = new Node("part:" + part.getShapeName().toCompositeString());
        this.geomFactory.generateBlocks(result, cells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        if (this.isCarved(part)) {
            float carveScale = (float)(1.0 / part.getScale());
            result.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(carveScale)));
        }
        result.setLocalScale((float)part.getScale());
        return result;
    }

    protected Vector3f getTopLeft(Panel p, Panel popup) {
        Vector3f pos = p.getWorldTranslation().clone();
        Vector3f scaled = GuiGlobals.getInstance().getPopupState().screenToGui(pos);
        Vector2f guiSize = GuiGlobals.getInstance().getPopupState().getGuiSize();
        Vector3f size = popup.getSize();
        if (size.x == 0.0f) {
            size = popup.getPreferredSize();
        }
        if (scaled.x + size.x > guiSize.x) {
            scaled.x = guiSize.x - size.x;
        }
        return scaled;
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
            boolean pressed;
            boolean bl = pressed = value == InputState.Positive;
            if (!pressed) {
                if (func == AssemblyFunctions.F_EXPORT) {
                    AssemblyEditorState.this.exportCurrent();
                } else if (func == AssemblyFunctions.F_IMPORT) {
                    AssemblyEditorState.this.selectImport();
                } else if (func == AssemblyFunctions.F_UNDO) {
                    AssemblyEditorState.this.undo();
                } else if (func == AssemblyFunctions.F_REDO) {
                    AssemblyEditorState.this.redo();
                }
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == AssemblyFunctions.F_PAN) {
                AssemblyEditorState.this.yaw = (float)((double)AssemblyEditorState.this.yaw + -value * tpf);
                if (AssemblyEditorState.this.yaw < 0.0f) {
                    AssemblyEditorState.this.yaw += (float)Math.PI * 2;
                } else if (AssemblyEditorState.this.yaw >= (float)Math.PI * 2) {
                    AssemblyEditorState.this.yaw -= (float)Math.PI * 2;
                }
                AssemblyEditorState.this.updateRotation();
            } else if (func == AssemblyFunctions.F_CRANE) {
                AssemblyEditorState.this.pitch = (float)((double)AssemblyEditorState.this.pitch + value * tpf);
                if (AssemblyEditorState.this.pitch < AssemblyEditorState.this.minPitch) {
                    AssemblyEditorState.this.pitch = AssemblyEditorState.this.minPitch;
                } else if (AssemblyEditorState.this.pitch > AssemblyEditorState.this.maxPitch) {
                    AssemblyEditorState.this.pitch = AssemblyEditorState.this.maxPitch;
                }
                AssemblyEditorState.this.updateRotation();
            } else if (func == AssemblyFunctions.F_ZOOM) {
                AssemblyEditorState.this.zoom = (float)((double)AssemblyEditorState.this.zoom + value * tpf * 100.0);
                if (AssemblyEditorState.this.zoom < 0.0f) {
                    AssemblyEditorState.this.zoom = 0.0f;
                } else if (AssemblyEditorState.this.zoom > AssemblyEditorState.this.maxZoom) {
                    AssemblyEditorState.this.zoom = AssemblyEditorState.this.maxZoom;
                }
                AssemblyEditorState.this.updateRotation();
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    private class MouseHandler
    implements CursorListener {
        private CollisionResult lastCollision = null;

        private MouseHandler() {
        }

        protected PartView findView() {
            for (Geometry p = this.lastCollision.getGeometry(); p != null; p = p.getParent()) {
                PartView view = AssemblyEditorState.this.viewIndex.get(p);
                if (view == null) continue;
                return view;
            }
            return null;
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            PartView view = this.findView();
            if (view == null) {
                return;
            }
            if (event.isPressed()) {
                AssemblyEditorState.this.selectView(view);
            }
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.lastCollision = event.getCollision();
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
        }
    }

    private class PartView {
        PartView parent;
        Subassembly part;
        CellArray cells;
        Node view;
        Node model;
        Geometry selectionBox;
        double mix;

        public PartView(PartView parent, Subassembly part) {
            this.parent = parent;
            this.part = part;
            if (part.getShapeName() == null) {
                this.view = new Node("group:" + part.getName());
                this.model = (Node)AssemblyEditorState.this.crosshairTemplate.clone();
                if (part != AssemblyEditorState.this.mainAssembly) {
                    this.view.attachChild((Spatial)this.model);
                }
                this.selectionBox = AssemblyEditorState.this.selectionBoxTemplate.clone();
                float size = 0.15f;
                WireBox box = new WireBox(size, size, size);
                this.selectionBox.setMesh((Mesh)box);
            } else {
                this.cells = AssemblyEditorState.this.loadCells(part.getShapeName());
                this.model = AssemblyEditorState.this.createView(part, this.cells);
                this.view = new Node("part:" + part.getName());
                this.view.attachChild((Spatial)this.model);
                this.selectionBox = AssemblyEditorState.this.selectionBoxTemplate.clone();
                Vector3f offset = new Vector3f(0.01f, 0.01f, 0.01f);
                Box box = new Box(new Vector3f().subtractLocal(offset), this.cells.getSize().toVector3f().addLocal(offset));
                this.selectionBox.setMesh((Mesh)box);
            }
            if (parent != null) {
                parent.view.attachChild((Spatial)this.view);
            }
            AssemblyEditorState.this.viewIndex.put((Spatial)this.view, this);
        }

        public void center() {
            if (this.cells == null) {
                return;
            }
            Vec3d half = this.cells.getSize().toVec3d().mult(-0.5).mult(this.part.getScale());
            half.y = 0.0;
            this.setLocation(half);
        }

        public void setLocation(Vec3d pos) {
            this.part.setLocation(pos);
            this.view.setLocalTranslation(pos.toVector3f());
        }

        public void release() {
            this.view.removeFromParent();
            AssemblyEditorState.this.viewIndex.remove(this.view, this);
        }

        public void setShowSelection(boolean showSelection) {
            boolean selected;
            boolean bl = selected = this.selectionBox.getParent() != null;
            if (selected && showSelection) {
                return;
            }
            if (showSelection) {
                if (this.model != null) {
                    this.model.attachChild((Spatial)this.selectionBox);
                } else {
                    this.view.attachChild((Spatial)this.selectionBox);
                }
            } else {
                this.selectionBox.removeFromParent();
            }
        }

        public void setMix(double mix) {
            if (this.mix == mix) {
                return;
            }
            this.mix = mix;
            this.applyChanges();
        }

        protected Vec3d getLocation() {
            if (this.part instanceof Joint) {
                Joint joint = (Joint)this.part;
                Vec3d loc = this.part.getLocation().clone();
                loc.interpolateLocal(joint.getLocation(), joint.getTargetLocation(), this.mix);
                return loc;
            }
            return this.part.getLocation();
        }

        protected Quatd getOrientation() {
            if (this.part instanceof Joint) {
                Joint joint = (Joint)this.part;
                Quatd rot = this.part.getOrientation().clone();
                rot.slerpLocal(joint.getOrientation(), joint.getTargetOrientation(), this.mix);
                rot.normalizeLocal();
                return rot;
            }
            return this.part.getOrientation();
        }

        public void applyChanges() {
            this.view.setLocalTranslation(this.getLocation().toVector3f());
            this.view.setLocalRotation(this.getOrientation().toQuaternion());
            if (this.part.getShapeName() != null && (double)this.model.getLocalScale().x != this.part.getScale()) {
                this.model.setLocalScale((float)this.part.getScale());
                if (AssemblyEditorState.this.isCarved(this.part)) {
                    float carveScale = (float)(1.0 / this.part.getScale());
                    this.model.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(carveScale)));
                }
            }
        }

        public String toString() {
            if (this.part.getName() != null) {
                return this.part.getName();
            }
            if (this.part.getShapeName() != null) {
                return this.part.getShapeName().getFullName();
            }
            return "Unknown";
        }
    }

    private class Blueprint {
        private Entity entity;
        private String name;
        private String resourceName;

        public Blueprint(Entity entity) {
            this.entity = entity;
        }

        public Blueprint(String name, String resourceName) {
            this.name = name;
            this.resourceName = resourceName;
        }

        public void update() {
            BlueprintInfo info = (BlueprintInfo)this.entity.get(BlueprintInfo.class);
            this.name = info.getName();
            ShapeInfo shape = (ShapeInfo)this.entity.get(ShapeInfo.class);
            this.resourceName = shape.getShapeName(AssemblyEditorState.this.ed);
        }

        public String toString() {
            return this.name;
        }
    }

    private class BlueprintContainer
    extends EntityContainer<Blueprint> {
        private Comparator<? super Blueprint> comparator;

        public BlueprintContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{BlueprintInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            this.setFilter(BlueprintInfo.parentFilter((EntityId)player));
        }

        protected Blueprint addObject(Entity e) {
            log.info("addObject(" + e + ")");
            Blueprint object = new Blueprint(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(AssemblyEditorState.this.blueprintList, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                AssemblyEditorState.this.blueprintList.add(index, (Object)object);
            } else {
                AssemblyEditorState.this.blueprintList.add((Object)object);
            }
            return object;
        }

        protected void updateObject(Blueprint object, Entity e) {
            object.update();
        }

        protected void removeObject(Blueprint object, Entity e) {
            AssemblyEditorState.this.blueprintList.remove((Object)object);
        }
    }
}

