/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.CellDataStack;
import com.simsilica.mworld.ColumnChangeListener;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.LeafChangeListenerSupport;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnLightData;
import com.simsilica.mworld.db.ColumnNeighborhood;
import com.simsilica.mworld.db.ObservableColumnDb;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageManager;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.TileManager;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.pc.PointCloudManager;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.transaction.WorldEdits;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorld
implements World {
    static Logger log = LoggerFactory.getLogger(DefaultWorld.class);
    private boolean initialized;
    private boolean terminated;
    private ColumnDb colDb;
    private int yMax;
    private List<CellChangeListener> cellListeners = new ArrayList<CellChangeListener>();
    private CellChangeListener[] cellListenerArray;
    private CellChangeListener[] emptyCellListenerArray = new CellChangeListener[0];
    private LeafChangeListenerSupport leafListeners = new LeafChangeListenerSupport();
    private TileManager tileManager;
    private TerrainImageManager terrainImageManager;
    private PointCloudManager pointCloudManager;

    public DefaultWorld(ColumnDb colDb, TileManager tileManager, TerrainImageManager terrainImageManager, PointCloudManager pointCloudManager, int yMax) {
        this.colDb = colDb;
        this.tileManager = tileManager;
        this.terrainImageManager = terrainImageManager;
        this.pointCloudManager = pointCloudManager;
        this.yMax = yMax;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.colDb.initialize();
        this.tileManager.initialize();
        if (this.terrainImageManager != null) {
            this.terrainImageManager.initialize();
        }
        if (this.pointCloudManager != null) {
            this.pointCloudManager.initialize();
        }
        this.initialized = true;
        this.terminated = false;
    }

    public void terminate() {
        if (this.terminated) {
            throw new IllegalStateException("Already termintated");
        }
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.pointCloudManager != null) {
            this.pointCloudManager.terminate();
        }
        if (this.terrainImageManager != null) {
            this.terrainImageManager.terminate();
        }
        this.tileManager.terminate();
        this.colDb.terminate();
        this.initialized = false;
        this.terminated = true;
    }

    @Override
    public void addCellChangeListener(CellChangeListener l) {
        this.cellListeners.add(l);
        this.cellListenerArray = null;
    }

    @Override
    public void removeCellChangeListener(CellChangeListener l) {
        this.cellListeners.remove(l);
        this.cellListenerArray = null;
    }

    protected CellChangeListener[] getCellListenerArray() {
        if (this.cellListenerArray == null) {
            this.cellListenerArray = this.cellListeners.toArray(this.emptyCellListenerArray);
        }
        return this.cellListenerArray;
    }

    @Override
    public void addLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.add(l);
    }

    @Override
    public void removeLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.remove(l);
    }

    @Override
    public void addColumnChangeListener(ColumnChangeListener l) {
        if (!(this.colDb instanceof ObservableColumnDb)) {
            throw new IllegalArgumentException("Column DB is not observable");
        }
        ((ObservableColumnDb)this.colDb).addColumnChangeListener(l);
    }

    @Override
    public void removeColumnChangeListener(ColumnChangeListener l) {
        if (!(this.colDb instanceof ObservableColumnDb)) {
            throw new IllegalArgumentException("Column DB is not observable");
        }
        ((ObservableColumnDb)this.colDb).removeColumnChangeListener(l);
    }

    protected void fireCellChanged(CellChangeEvent event) {
        for (CellChangeListener l : this.getCellListenerArray()) {
            l.cellChanged(event);
        }
    }

    @Override
    public int getMaxY() {
        return this.yMax;
    }

    @Override
    public int setWorldCell(Vec3d world, int type) {
        if (!log.isTraceEnabled()) {
            log.trace("setWorldCell(" + world + ", " + type + ")");
        }
        WorldEdits worldEdits = new WorldEdits();
        int result = this.setWorldCell(world, type, worldEdits);
        this.deliverEvents(worldEdits);
        return result;
    }

    public int setWorldCell(Vec3d world, int type, WorldEdits worldEdits) {
        if (log.isTraceEnabled()) {
            log.trace("setWorldCell(" + world + ", " + type + ")");
        }
        if (world.y == 0.0) {
            log.warn("Cannot remove 'bedrock'");
            return -1;
        }
        ColumnId colId = ColumnId.fromWorld(world);
        if (log.isTraceEnabled()) {
            log.trace("colId:" + colId + "  world:" + colId.getWorld(null));
        }
        ColumnData col = this.colDb.getColumn(colId);
        LeafData leaf = col.getLeafData((int)world.y);
        if (log.isTraceEnabled()) {
            log.trace("leaf:" + leaf);
        }
        if (leaf == null) {
            return -1;
        }
        if (log.isTraceEnabled()) {
            log.trace("modifying:" + colId);
        }
        int x = Coordinates.worldToCell(world.x);
        int y = Coordinates.worldToCell(world.y);
        int z = Coordinates.worldToCell(world.z);
        Vec3i origin = colId.getWorld(null);
        ColumnNeighborhood data = new ColumnNeighborhood(this.colDb, col, worldEdits);
        int cx = x - origin.x;
        int cy = y - origin.y;
        int cz = z - origin.z;
        int originalValue = data.getCell(cx, cy, cz);
        if (type == originalValue) {
            return originalValue;
        }
        int originalType = MaskUtils.getType((int)originalValue);
        if (originalType == type) {
            return originalValue;
        }
        int originalLight = data.getLight(cx, cy, cz, 0);
        int newType = MaskUtils.getType((int)type);
        BlockType bOld = BlockTypeIndex.get((int)originalType);
        BlockType bNew = BlockTypeIndex.get((int)newType);
        int newLight = 0;
        if (bNew != null) {
            if (bNew.getLight() != 0) {
                newLight = bNew.getLight();
            } else if (bNew.isSolid() && !bNew.isTransparent()) {
                newLight = -65536;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("original light:" + Integer.toHexString(originalLight) + "  new:" + Integer.toHexString(newLight));
        }
        CellData light = data.getLightingCellData();
        boolean propagationChanged = this.lightPropagationChanged(bOld, bNew);
        boolean subtractLight = propagationChanged;
        if (!subtractLight && originalLight != newLight && LightUtils.isDecreasing((int)originalLight, (int)newLight)) {
            short bOldLight = bOld == null ? (short)0 : bOld.getLight();
            subtractLight = LightUtils.anyMatch((int)bOldLight, (int)originalLight);
        }
        if (log.isTraceEnabled()) {
            log.trace("Subtract light:" + subtractLight);
        }
        List removed = null;
        if (subtractLight) {
            light = data.getLightingCellData();
            removed = LightUtils.subtractLight((CellData)data, (CellData)light, (int)cx, (int)cy, (int)cz, (int)originalLight);
        }
        data.setCell(cx, cy, cz, type);
        MaskUtils.recalculateSideMasks((CellData)data, (int)cx, (int)cy, (int)cz, (int)-1);
        int newValue = data.getCell(cx, cy, cz);
        if (removed != null) {
            LinkedList<LightUtils.LightSeed> seeds = new LinkedList<LightUtils.LightSeed>();
            for (Vec3i v : removed) {
                LightUtils.LightSeed seed = LightUtils.calculateSeed((CellData)data, (CellData)light, (int)v.x, (int)v.y, (int)v.z, (int)0, (int)0);
                if (seed == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("  suck:" + seed);
                }
                seeds.add(seed);
            }
            int n = LightUtils.propagateSeeds((CellData)data, (CellData)light, seeds, (boolean)false);
        }
        if (originalLight != newLight || propagationChanged) {
            if (light == null) {
                light = data.getLightingCellData();
            }
            LightUtils.LightSeed seed = LightUtils.calculateSeed((CellData)data, (CellData)light, (int)cx, (int)cy, (int)cz, (int)originalLight, (int)newLight);
            if (log.isTraceEnabled()) {
                log.trace("Seed:" + seed);
            }
            if (seed != null) {
                LinkedList<LightUtils.LightSeed> seeds = new LinkedList<LightUtils.LightSeed>();
                seeds.add(seed);
                int n = LightUtils.propagateSeeds((CellData)data, (CellData)light, seeds, (boolean)false);
            }
        }
        FluidUtils.recalculateSideMasks((CellData)data.getFluidCellData(), (CellData)data, (int)cx, (int)cy, (int)cz, (int)-1);
        return newValue;
    }

    public int debugSetWorldLight(Vec3d world, int light) {
        log.info("debugSetWorldLight(" + world + ", " + light + ")");
        WorldEdits worldEdits = new WorldEdits();
        int result = this.debugSetWorldLight(world, light, worldEdits);
        this.deliverEvents(worldEdits);
        return result;
    }

    public int debugSetWorldLight(Vec3d world, int light, WorldEdits worldEdits) {
        log.info("debugSetWorldLight(" + world + ", " + light + ")");
        if (world.y == 0.0) {
            log.warn("Cannot edit 'bedrock'");
            return -1;
        }
        ColumnId colId = ColumnId.fromWorld(world);
        if (log.isTraceEnabled()) {
            log.trace("colId:" + colId + "  world:" + colId.getWorld(null));
        }
        ColumnData col = this.colDb.getColumn(colId);
        LightData leaf = col.getLightData((int)world.y);
        if (log.isTraceEnabled()) {
            log.trace("leaf:" + leaf);
        }
        if (leaf == null) {
            return -1;
        }
        if (log.isTraceEnabled()) {
            log.trace("modifying:" + colId);
        }
        int x = Coordinates.worldToCell(world.x);
        int y = Coordinates.worldToCell(world.y);
        int z = Coordinates.worldToCell(world.z);
        Vec3i origin = colId.getWorld(null);
        int cx = x - origin.x;
        int cy = y - origin.y;
        int cz = z - origin.z;
        ColumnNeighborhood data = new ColumnNeighborhood(this.colDb, col, worldEdits);
        int originalValue = data.getLight(cx, cy, cz, -1);
        data.setLight(cx, cy, cz, light);
        return light;
    }

    public void deliverEvents(WorldEdits worldEdits) {
        for (ColumnData cd : worldEdits.getModifiedColumns()) {
            cd.getVersion().markChanged();
            this.colDb.markChanged(cd);
        }
        for (LeafId id : worldEdits.getModifiedLeafIds()) {
            DataVersion version = worldEdits.getColumnData(id).getVersion();
            if (log.isTraceEnabled()) {
                log.trace("fireLeafChanged(" + id + ")  leaf loc:" + id.getWorld(null));
            }
            this.leafListeners.fireLeafChanged(id, version.getVersion(), false);
        }
        for (CellChangeEvent event : worldEdits.createCellChangeEvents()) {
            this.fireCellChanged(event);
        }
    }

    protected boolean lightPropagationChanged(BlockType oldType, BlockType newType) {
        boolean newCheck;
        if (oldType == newType) {
            return false;
        }
        boolean oldCheck = oldType == null ? true : oldType.isTransparent();
        boolean bl = newCheck = newType == null ? true : newType.isTransparent();
        if (log.isTraceEnabled()) {
            log.trace("old is transparent:" + oldCheck + "  new:" + newCheck);
        }
        if (oldCheck && newCheck) {
            return true;
        }
        if (oldCheck != newCheck) {
            return true;
        }
        oldCheck = oldType == null ? false : oldType.isSolid();
        boolean bl2 = newCheck = newType == null ? false : newType.isSolid();
        if (log.isTraceEnabled()) {
            log.trace("old is solid:" + oldCheck + "  new:" + newCheck);
        }
        return oldCheck != newCheck;
    }

    @Override
    public int getWorldCell(Vec3d world) {
        ColumnId colId = ColumnId.fromWorld(world);
        ColumnData col = this.colDb.getColumn(colId);
        LeafData leaf = col.getLeafData((int)world.y);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell(world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell(world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell(world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    @Override
    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld(worldLocation));
    }

    @Override
    public LeafData getLeaf(LeafId leafId) {
        ColumnId colId = leafId.getColumnId();
        ColumnData col = this.colDb.getColumn(colId);
        Vec3i world = leafId.getWorld(null);
        return col.getLeafData(world.y);
    }

    @Override
    public LightData getLight(LeafId leafId) {
        ColumnId colId = leafId.getColumnId();
        ColumnData col = this.colDb.getColumn(colId);
        Vec3i world = leafId.getWorld(null);
        return col.getLightData(world.y);
    }

    @Override
    public FluidData getFluid(LeafId leafId) {
        ColumnId colId = leafId.getColumnId();
        ColumnData col = this.colDb.getColumn(colId);
        Vec3i world = leafId.getWorld(null);
        return col.getFluidData(world.y);
    }

    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        return this.terrainImageManager == null ? null : this.terrainImageManager.getTerrainImage(id, type, res);
    }

    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        Tile tile = this.tileManager.getTile(id, res);
        return tile.get(TreeLayer.class);
    }

    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        return this.pointCloudManager == null ? null : this.pointCloudManager.getPointCloud(id, res);
    }

    @Override
    public void addTileListener(TileListener l) {
        if (this.terrainImageManager != null) {
            this.terrainImageManager.addTileListener(l);
        }
        if (this.pointCloudManager != null) {
            this.pointCloudManager.addTileListener(l);
        }
    }

    @Override
    public void removeTileListener(TileListener l) {
        if (this.terrainImageManager != null) {
            this.terrainImageManager.addTileListener(l);
        }
        if (this.pointCloudManager != null) {
            this.pointCloudManager.removeTileListener(l);
        }
    }

    public void recalculateLighting(ColumnId colId) {
        int top;
        ColumnData col = this.colDb.getColumn(colId);
        LeafData[] leafs = col.getLeafs();
        LightData[] light = col.getLighting();
        int size = leafs.length;
        boolean lit = true;
        int clearValue = LightUtils.DIRECT_SUN;
        for (int i = size - 1; i >= 0; --i) {
            if (lit && !leafs[i].isEmpty()) {
                lit = false;
                clearValue = -65536;
            }
            light[i].clear(clearValue);
        }
        CellDataStack blocks = new CellDataStack(32, col.getLeafs());
        CellDataStack lighting = new CellDataStack(32, col.getLighting());
        long start = System.nanoTime();
        LightUtils.resetLighting((int)LightUtils.DIRECT_SUN, (CellData)blocks, (CellData)lighting, (int)0, (int)0, (int)0, (int)32, (int)lighting.getMaxY(), (int)32);
        long end = System.nanoTime();
        log.info(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
        for (top = leafs.length - 1; top >= 0 && leafs[top].isEmpty(); --top) {
        }
        int yTop = top * 32 + 32;
        if (log.isTraceEnabled()) {
            log.trace("Highest y value:" + yTop);
        }
        WorldEdits worldEdits = new WorldEdits();
        ColumnNeighborhood cellData = new ColumnNeighborhood(this.colDb, col, worldEdits);
        ColumnLightData lightData = ColumnLightData.loadNeighborhood(this.colDb, col, true);
        LightUtils.recalculateLighting((CellData)cellData, (CellData)lightData, (int)0, (int)0, (int)0, (int)32, (int)yTop, (int)32);
        lightData = cellData.getLightingCellData();
        int count = LightUtils.propagateBorders((CellData)cellData, (CellData)lightData, (int)0, (int)0, (int)0, (int)32, (int)col.getCeiling(), (int)32);
        for (ColumnData it : worldEdits.getModifiedColumns()) {
            if (log.isTraceEnabled()) {
                log.trace("Changed:" + it.getColumnId());
            }
            this.colDb.markChanged(it);
        }
        this.colDb.markChanged(col);
        if (log.isTraceEnabled()) {
            log.trace("Post iterations:" + count);
        }
        FluidUtils.calculateSideMasks((CellData)cellData.getFluidCellData(), (CellData)cellData, (int)0, (int)0, (int)0, (int)32, (int)256, (int)32);
        FluidUtils.calculateFluidSlopes((CellData)cellData.getFluidCellData(), (CellData)cellData, (int)0, (int)0, (int)0, (int)32, (int)256, (int)32);
        this.deliverEvents(worldEdits);
    }
}

