/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterNameGenerator {
    static Logger log = LoggerFactory.getLogger(CharacterNameGenerator.class);
    public static final String HUMAN_NAMES = "races/human-name-stems.txt";
    private Map<String, NameGenerator> raceIndex = new HashMap<String, NameGenerator>();

    private CharacterNameGenerator() {
    }

    public String[] generateName(String race, Random rand) {
        NameGenerator ng = this.raceIndex.get(race);
        return ng.generateName(rand);
    }

    public static CharacterNameGenerator create(Function<String, String> textFunc) {
        CharacterNameGenerator result = new CharacterNameGenerator();
        NameGenerator[] humans = CharacterNameGenerator.parseGenerator(textFunc.apply(HUMAN_NAMES));
        result.raceIndex.put("human-male", humans[0]);
        result.raceIndex.put("human-female", humans[1]);
        result.raceIndex.put("elf-male", humans[0]);
        result.raceIndex.put("elf-female", humans[1]);
        return result;
    }

    private static NameGenerator[] parseGenerator(String text) {
        String[] lines = text.split("\\n");
        Iterator<String> it = Arrays.asList(lines).iterator();
        Stems first1 = new Stems();
        Stems first2 = new Stems();
        while (it.hasNext()) {
            String f;
            String m;
            int split;
            boolean suffix;
            String line = it.next();
            if (".first".equals(line = line.trim())) continue;
            if (".last".equals(line)) break;
            boolean bl = suffix = line.charAt(0) == '-';
            if (suffix) {
                line = line.substring(1);
            }
            if ((split = line.indexOf(47)) >= 0) {
                m = line.substring(0, split);
                f = line.substring(split + 1);
            } else {
                m = line;
                f = line;
            }
            if (suffix) {
                first1.suffixes.add(m);
                first2.suffixes.add(f);
                continue;
            }
            first1.prefixes.add(m);
            first2.prefixes.add(f);
        }
        Stems last = new Stems();
        while (it.hasNext()) {
            String line = it.next();
            if ((line = line.trim()).charAt(0) == '-') {
                last.suffixes.add(line.substring(1));
                continue;
            }
            last.prefixes.add(line);
        }
        return new NameGenerator[]{new NameGenerator(first1, last), new NameGenerator(first2, last)};
    }

    public static String removeDumbStuff(String s) {
        s = s.replace("aea", "ae");
        s = s.replace("ssh", "sh");
        s = s.replace("oonn", "oon");
        s = s.replace("thth", "th");
        s = s.replace("lalala", "lala");
        s = s.replace("nnd", "nd");
        s = s.replace("eaa", "ea");
        s = s.replace("eau", "au");
        s = s.replace("thnd", "thd");
        s = s.replace("thne", "ne");
        s = s.replace("thdl", "thl");
        s = s.replace("thtl", "thl");
        s = s.replace("nnn", "nn");
        s = s.replace("snd", "nd");
        s = s.replace("rnn", "rn");
        s = s.replace("rntl", "rnt");
        s = s.replace("eaelr", "aer");
        s = s.replace("sseelr", "sseer");
        s = s.replace("quiu", "qui");
        return s;
    }

    private static class NameGenerator {
        Stems first;
        Stems last;

        public NameGenerator(Stems first, Stems last) {
            this.first = first;
            this.last = last;
        }

        public String[] generateName(Random rand) {
            String f = this.first.generate(rand);
            String l = this.last.generate(rand);
            return new String[]{f, l};
        }
    }

    private static class Stems {
        List<String> prefixes = new ArrayList<String>();
        List<String> suffixes = new ArrayList<String>();

        private Stems() {
        }

        public String generate(Random rand) {
            String p = this.prefixes.get(rand.nextInt(this.prefixes.size()));
            String s = this.suffixes.get(rand.nextInt(this.suffixes.size()));
            String result = CharacterNameGenerator.removeDumbStuff(p + s);
            return Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
    }
}

