/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolSystem
extends AbstractGameSystem
implements Executor {
    static Logger log = LoggerFactory.getLogger(ThreadPoolSystem.class);
    private ThreadPoolExecutor pool;

    public ThreadPoolSystem(int poolSize, int maxQueueSize) {
        log.info("Initializing thread pool");
        this.pool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize));
        this.pool.setThreadFactory(new ThreadFactoryBuilder().setNameFormat("pool-%d").build());
    }

    @Override
    public void execute(Runnable command) {
        this.pool.execute(command);
    }

    protected void initialize() {
    }

    protected void terminate() {
        log.info("Shutting down thread pool");
        this.pool.shutdownNow();
    }

    public void start() {
    }

    public void update(SimTime time) {
    }

    public void stop() {
    }
}

