/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.util.AbstractColumnIndex;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironment {
    static Logger log = LoggerFactory.getLogger(LocalEnvironment.class);
    public static final double DISTANCE_EPSILON = 1.0E-4;
    public static final double DISTANCE_EPSILON_SQ = 1.0E-8;
    private World world;
    private WorldObserver worldObserver = new WorldObserver();
    private Vec3d pos = new Vec3d();
    private Vec3i cell = new Vec3i();
    private Vec3d look = new Vec3d();
    private boolean locationInvalid = true;
    private volatile LeafId leafId;
    private Vec3i leafOrigin;
    private volatile boolean leafInvalid = true;
    private LightData lightData;
    private FluidData fluidData;
    private boolean columnIdInvalid = true;
    private ColumnId columnId;
    private NeighborIndex neighbors = new NeighborIndex(1);
    private boolean lightInvalid = true;
    private int lightValue = -1;
    private volatile boolean fluidInvalid = true;
    private int fluidValue = -1;
    private double yFluid = -1.0;
    private Vec3i nearestTree;
    private Vec3d audibleCentroid;
    private int audibleCount;
    private Vec3d treeCentroid;
    private int treeCount;
    private double forestFactor = 0.0;
    private Vec3d forestDirection = new Vec3d(0.0, 0.0, 0.0);
    private double underwaterFactor = 0.0;

    public LocalEnvironment(World world) {
        this.world = world;
        world.addCellChangeListener((CellChangeListener)this.worldObserver);
        world.addLeafChangeListener((LeafChangeListener)this.worldObserver);
    }

    public void release() {
        this.world.removeCellChangeListener((CellChangeListener)this.worldObserver);
        this.world.removeLeafChangeListener((LeafChangeListener)this.worldObserver);
    }

    public void setPosition(Vec3d pos) {
        if (pos.distanceSq(this.pos) > 1.0E-8) {
            this.fluidInvalid = true;
        }
        this.pos.set(pos);
        Vec3i v = pos.floor();
        if (v.equals((Object)this.cell)) {
            return;
        }
        this.cell.set(v);
        this.locationInvalid = true;
    }

    public Vec3d getPosition() {
        return this.pos;
    }

    public Vec3i getCell() {
        return this.cell;
    }

    public void setLook(Vec3d look) {
        if (look.equals((Object)this.look)) {
            return;
        }
        this.look.set(look);
        this.fluidInvalid = true;
    }

    public Vec3d getLook() {
        return this.look;
    }

    public int getSun() {
        return LightUtils.sun((int)this.lightValue);
    }

    public int getLocalLight() {
        return LightUtils.localLight((int)this.lightValue);
    }

    public int getLight() {
        return LightUtils.getLight((int)this.lightValue);
    }

    public double getForestFactor() {
        return this.forestFactor;
    }

    public double getUnderwaterFactor() {
        return this.underwaterFactor;
    }

    public boolean update() {
        long start = System.nanoTime();
        boolean changed = false;
        if (this.validatePosition()) {
            changed = true;
        }
        if (this.validateColumn()) {
            changed = true;
        }
        if (this.validateLeaf()) {
            changed = true;
        }
        if (this.validateLight()) {
            changed = true;
        }
        if (this.validateFluid()) {
            changed = true;
        }
        if (changed) {
            this.recalculateAmbientEffects();
        }
        long end = System.nanoTime();
        if (changed && end - start > 1000000L) {
            log.info("validated in:" + (double)(end - start) / 1000000.0 + " ms");
        }
        return changed;
    }

    protected boolean setLeafId(LeafId leafId) {
        if (Objects.equals(this.leafId, leafId)) {
            return false;
        }
        this.leafId = leafId;
        this.leafOrigin = leafId == null ? null : leafId.getWorld(null);
        this.leafInvalid = true;
        return true;
    }

    protected boolean setColumnId(ColumnId columnId) {
        if (Objects.equals(this.columnId, columnId)) {
            return false;
        }
        this.columnId = columnId;
        this.columnIdInvalid = true;
        return true;
    }

    protected boolean validatePosition() {
        if (!this.locationInvalid) {
            return false;
        }
        this.locationInvalid = false;
        this.lightInvalid = true;
        this.fluidInvalid = true;
        if (this.cell.y >= 0) {
            LeafId id = LeafId.fromWorld((int)this.cell.x, (int)this.cell.y, (int)this.cell.z);
            this.setLeafId(id);
            this.setColumnId(id.getColumnId());
        }
        return true;
    }

    protected boolean validateLeaf() {
        if (!this.leafInvalid) {
            return false;
        }
        this.leafInvalid = false;
        this.lightData = this.world.getLight(this.leafId);
        this.fluidData = this.world.getFluid(this.leafId);
        this.lightInvalid = true;
        this.fluidInvalid = true;
        return true;
    }

    protected boolean validateColumn() {
        if (!this.columnIdInvalid) {
            return false;
        }
        this.columnIdInvalid = false;
        if (log.isTraceEnabled()) {
            log.trace("Reloading neighbors...");
        }
        this.neighbors.setCenterColumnId(this.columnId);
        this.recalculateAmbientEffects();
        return true;
    }

    protected boolean validateLight() {
        if (!this.lightInvalid) {
            return false;
        }
        this.lightInvalid = false;
        if (this.cell.y >= this.world.getMaxY()) {
            return false;
        }
        if (this.leafOrigin == null) {
            return false;
        }
        Vec3i origin = this.leafOrigin;
        int i = this.cell.x - origin.x;
        int j = this.cell.y - origin.y;
        if (j < 0) {
            return false;
        }
        int k = this.cell.z - origin.z;
        this.lightValue = this.lightData.getCell(i, j, k);
        int sun = LightUtils.sun((int)this.lightValue);
        int local = LightUtils.localLight((int)this.lightValue);
        return true;
    }

    protected boolean validateFluid() {
        if (!this.fluidInvalid) {
            return false;
        }
        this.fluidInvalid = false;
        if (this.cell.y >= this.world.getMaxY()) {
            return false;
        }
        if (this.leafOrigin == null) {
            return false;
        }
        Vec3i origin = this.leafOrigin;
        int i = this.cell.x - origin.x;
        int j = this.cell.y - origin.y;
        if (j < 0) {
            return false;
        }
        int k = this.cell.z - origin.z;
        this.fluidValue = this.fluidData.getCell(i, j, k);
        int fluidType = FluidUtils.getType((int)this.fluidValue);
        if (fluidType == 0) {
            this.yFluid = 0.0;
            this.underwaterFactor = 0.0;
        } else {
            int fluidLevel = FluidUtils.getLevel((int)this.fluidValue);
            if (fluidLevel > 7) {
                this.underwaterFactor = 1.0;
                return false;
            }
            this.yFluid = (double)(fluidLevel - 1) / 7.0;
            if (this.yFluid == 0.0) {
                this.yFluid += 0.07142857142857142;
            }
            this.yFluid += (double)this.cell.y;
            double nearDist = 0.1;
            double yScreen = this.pos.y + this.look.y * nearDist;
            double delta = this.yFluid - yScreen;
            double svta = yScreen - this.yFluid;
            double lvta = Math.sqrt(this.look.x * this.look.x + this.look.z * this.look.z);
            if (lvta == 0.0) {
                this.underwaterFactor = svta > 0.0 ? 0.0 : 1.0;
                return false;
            }
            double scale = -svta / lvta;
            double max = 0.07;
            double min = -max;
            this.underwaterFactor = scale < min ? 0.0 : (scale > max ? 1.0 : (scale - min) / (max - min));
        }
        return false;
    }

    protected ColumnInfo loadColumnInfo(ColumnId id) {
        if (log.isTraceEnabled()) {
            log.trace("Loading column:" + id);
        }
        return new ColumnInfo(this, id);
    }

    protected void recalculateAmbientEffects() {
        this.nearestTree = null;
        double nearestDistSq = Double.MAX_VALUE;
        Vec3d earshotCentroid = new Vec3d();
        int earshotTotal = 0;
        double audibleDistance = 32.0;
        double startFalloff = 16.0;
        double audibleDistSq = audibleDistance * audibleDistance;
        Vec3d centroid = new Vec3d();
        int total = 0;
        for (ColumnInfo info : this.neighbors.getColumns()) {
            TileId tileId = info.id.getTileId();
            Vec3i origin = tileId.getWorld(null);
            for (Tree tree : info.trees) {
                Vec3i loc = origin.add((int)tree.x, (int)tree.y, (int)tree.z);
                centroid.addLocal(loc);
                ++total;
                double distSq = this.pos.distanceSq((double)loc.x, (double)loc.y, (double)loc.z);
                if (distSq <= audibleDistSq) {
                    earshotCentroid.addLocal(loc);
                    ++earshotTotal;
                }
                if (!(distSq < nearestDistSq)) continue;
                this.nearestTree = loc;
                nearestDistSq = distSq;
            }
        }
        if (total > 0) {
            centroid.divideLocal((double)total);
        }
        if (earshotTotal > 0) {
            earshotCentroid.divideLocal((double)earshotTotal);
        }
        Vec3d relative = earshotCentroid.subtract(this.pos);
        double earshotDistance = relative.length();
        this.forestDirection = relative.normalize();
        relative = centroid.subtract(this.pos);
        this.audibleCentroid = earshotCentroid;
        this.audibleCount = earshotTotal;
        this.treeCentroid = centroid;
        this.treeCount = total;
        double countFactor = this.audibleCount == 0 ? 0.0 : Math.min(1.0, (double)this.audibleCount / 10.0);
        double distanceFactor = 1.0;
        if (earshotDistance > startFalloff) {
            distanceFactor = Math.max(0.0, 1.0 - (earshotDistance - startFalloff) / (audibleDistance - startFalloff));
        }
        this.forestFactor = countFactor * distanceFactor;
        if (log.isTraceEnabled()) {
            log.trace("count factor:" + countFactor + "  distFactor:" + distanceFactor + "  forestFactor:" + this.forestFactor);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pos:" + this.pos + ", cell:" + this.cell + "]";
    }

    private class WorldObserver
    implements LeafChangeListener,
    CellChangeListener {
        private WorldObserver() {
        }

        public void cellChanged(CellChangeEvent event) {
            if (Objects.equals(LocalEnvironment.this.leafId, event.getLeafId())) {
                LocalEnvironment.this.leafInvalid = true;
            }
        }

        public void leafChanged(LeafChangeEvent event) {
            if (Objects.equals(LocalEnvironment.this.leafId, event.getLeafId())) {
                LocalEnvironment.this.leafInvalid = true;
            }
        }
    }

    private class NeighborIndex
    extends AbstractColumnIndex<ColumnInfo> {
        public NeighborIndex(int radius) {
            super(radius);
        }

        protected ColumnInfo loadColumn(ColumnId id) {
            return LocalEnvironment.this.loadColumnInfo(id);
        }

        protected void releaseColumn(ColumnId id, ColumnInfo column) {
            if (log.isTraceEnabled()) {
                log.trace("Releasing:" + column);
            }
        }
    }

    private class ColumnInfo {
        private ColumnId id;
        private TreeLayer treeLayer;
        private List<Tree> trees;

        public ColumnInfo(LocalEnvironment localEnvironment, ColumnId id) {
            this.id = id;
            this.treeLayer = localEnvironment.world.getTrees(id.getTileId(), null);
            this.trees = this.treeLayer.getTrees(id);
        }

        public String toString() {
            return "ColumnInfo[" + this.id + "]";
        }
    }
}

