/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.util.List;
import java.util.Objects;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.net.ConnectionState;
import mythruna.client.ui.MarkdownUtil;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.PromptListener;
import mythruna.client.ui.UserPromptState;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(JournalState.class);
    public static final String SUBMENU = "Journal";
    private EntityData ed;
    private EntityId avatarId;
    private GameSession session;
    private Container mainContainer;
    private Container left;
    private Container right;
    private JournalPromptListener journalListener = new JournalPromptListener();
    private SafeArrayList<PromptView> promptViews = new SafeArrayList(PromptView.class);
    private PromptView currentPrompt;
    private QuestView questView;
    private float maxTextWidth;

    public JournalState() {
        this.setEnabled(false);
    }

    protected void initialize(Application app) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu(SUBMENU, (AppState)this);
        this.mainContainer = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.None), new ElementId("popup"));
        this.mainContainer.setBackground((GuiComponent)new QuadBackgroundComponent(GuiGlobals.getInstance().loadTexture("Interface/book-pages.png", false, false)));
        this.mainContainer.setPreferredSize(new Vector3f(960.0f, 720.0f, 10.0f));
        this.left = (Container)this.mainContainer.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)), new Object[0]);
        this.left.setInsets(new Insets3f(30.0f, 30.0f, 30.0f, 30.0f));
        this.right = (Container)this.mainContainer.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Even)), new Object[0]);
        this.right.setInsets(new Insets3f(30.0f, 30.0f, 30.0f, 30.0f));
        this.maxTextWidth = 420.0f;
        this.promptViews.add((Object)new QuestListView());
        this.questView = new QuestView();
        this.promptViews.add((Object)this.questView);
        this.promptViews.add((Object)new DescriptionView());
        ((UserPromptState)this.getState(UserPromptState.class)).addPromptListener(this.journalListener);
    }

    protected void cleanup(Application app) {
        if (this.getState(UserPromptState.class) != null) {
            ((UserPromptState)this.getState(UserPromptState.class)).removePromptListener(this.journalListener);
        }
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.mainContainer);
        this.mainContainer.move(0.0f, 0.0f, 10.0f);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.mainContainer);
        this.session.runAction(this.avatarId, "getActiveQuests", new Object[]{0, 10});
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.mainContainer.removeFromParent();
    }

    public void update(float tpf) {
        for (PromptView view : (PromptView[])this.promptViews.getArray()) {
            view.update();
        }
    }

    private class JournalPromptListener
    implements PromptListener {
        private JournalPromptListener() {
        }

        @Override
        public boolean showPrompt(EntityId target, PromptType type, String prompt) {
            log.info("showPrompt(" + target + ", " + type + ", " + prompt + ")");
            if (!Objects.equals(target, JournalState.this.avatarId)) {
                return false;
            }
            for (PromptView view : JournalState.this.promptViews) {
                if (!view.showPrompt(prompt)) continue;
                JournalState.this.currentPrompt = view;
                return true;
            }
            JournalState.this.currentPrompt = null;
            log.warn("Unhandled prompt type:" + prompt);
            return false;
        }

        @Override
        public boolean showOptions(EntityId target, List<Option<EntityId>> options, Option<EntityId> closeOption) {
            log.info("showOptions(" + target + ", " + options + ")");
            if (!Objects.equals(target, JournalState.this.avatarId)) {
                return false;
            }
            if (JournalState.this.currentPrompt == null) {
                log.warn("No prompt view in effect for options:" + options);
                return false;
            }
            JournalState.this.currentPrompt.setOptions(options);
            return true;
        }
    }

    private static interface PromptView {
        public void update();

        public boolean showPrompt(String var1);

        public void setOptions(List<Option<EntityId>> var1);
    }

    private class QuestListView
    implements PromptView {
        private Label title;
        private VersionedList<Option<EntityId>> options = new VersionedList();
        private ListBox<Option<EntityId>> list;
        private VersionedReference<List<Option<EntityId>>> listRef;
        private VersionedReference<Integer> selectionRef;

        public QuestListView() {
            this.title = new Label("Active Quests", new ElementId("book.h1.label"));
            this.list = new ListBox(this.options);
            DefaultValueRenderer itemRenderer = new DefaultValueRenderer();
            itemRenderer.setStringTransform(item -> item.getDisplay());
            this.list.setCellRenderer((ValueRenderer)itemRenderer);
            this.list.setVisibleItems(10);
            this.listRef = this.list.getModel().createReference();
            this.selectionRef = this.list.getSelectionModel().createSelectionReference();
        }

        @Override
        public void update() {
            boolean selectionInvalid = false;
            if (this.selectionRef.update()) {
                selectionInvalid = true;
            }
            if (this.listRef.update()) {
                selectionInvalid = true;
            }
            if (selectionInvalid) {
                Option option = (Option)this.list.getSelectedItem();
                if (option != null) {
                    JournalState.this.session.runAction(JournalState.this.avatarId, option.getActionId(), option.getParameters());
                } else {
                    JournalState.this.questView.clear();
                    JournalState.this.questView.attach();
                }
            }
        }

        @Override
        public boolean showPrompt(String prompt) {
            if (prompt == null || !prompt.startsWith("Active Quests")) {
                return false;
            }
            if (this.list.getParent() == null) {
                JournalState.this.left.clearChildren();
                JournalState.this.left.addChild((Node)this.title, new Object[0]);
                JournalState.this.left.addChild(this.list, new Object[0]);
            }
            return true;
        }

        @Override
        public void setOptions(List<Option<EntityId>> options) {
            log.info("show active quests:" + options);
            this.options.clear();
            this.options.addAll(options);
        }
    }

    private class QuestView
    implements PromptView {
        private Container description = MarkdownUtil.createContainer(new ElementId("book.page"));
        private Container buttons = new Container();

        public void clear() {
            this.description.clearChildren();
            this.buttons.clearChildren();
        }

        @Override
        public void update() {
        }

        public void attach() {
            if (this.description.getParent() == null) {
                JournalState.this.right.clearChildren();
                JournalState.this.right.addChild((Node)this.description, new Object[0]);
                JournalState.this.right.addChild((Node)this.buttons, new Object[0]);
            }
        }

        @Override
        public boolean showPrompt(String prompt) {
            if (prompt == null || !prompt.startsWith("Quest:")) {
                return false;
            }
            prompt = prompt.substring("Quest:".length()).trim();
            log.info("Show quest info:" + prompt);
            MarkdownUtil.populateContainer(this.description, JournalState.this.maxTextWidth, prompt);
            this.attach();
            return true;
        }

        @Override
        public void setOptions(List<Option<EntityId>> options) {
            log.info("set quest options:" + options);
            this.buttons.clearChildren();
            for (Option<EntityId> option : options) {
                this.buttons.addChild((Node)new ActionButton((Action)new OptionAction(option)), new Object[0]);
            }
        }
    }

    private class DescriptionView
    implements PromptView {
        private Container description = MarkdownUtil.createContainer(new ElementId("book.page"));
        private Container buttons = new Container();

        @Override
        public void update() {
        }

        @Override
        public boolean showPrompt(String prompt) {
            if (prompt == null || !prompt.startsWith("Description:")) {
                return false;
            }
            prompt = prompt.substring("Description:".length()).trim();
            log.info("Show description info:" + prompt);
            if (this.description.getParent() == null) {
                JournalState.this.right.clearChildren();
                JournalState.this.right.addChild((Node)this.description, new Object[0]);
                JournalState.this.right.addChild((Node)this.buttons, new Object[0]);
            }
            MarkdownUtil.populateContainer(this.description, JournalState.this.maxTextWidth, prompt);
            this.buttons.clearChildren();
            this.buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Back", (Object)JournalState.this.questView, "attach")), new Object[0]);
            return true;
        }

        @Override
        public void setOptions(List<Option<EntityId>> options) {
            log.info("set description options:" + options);
            this.buttons.clearChildren();
            for (Option<EntityId> option : options) {
                this.buttons.addChild((Node)new ActionButton((Action)new OptionAction(option)), new Object[0]);
            }
            this.buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Back", (Object)JournalState.this.questView, "attach")), new Object[0]);
        }
    }

    private class OptionAction
    extends Action {
        private Option<EntityId> option;

        public OptionAction(Option<EntityId> option) {
            super(option.getDisplay());
            this.option = option;
        }

        public void execute(Button source) {
            JournalState.this.session.runAction(JournalState.this.avatarId, this.option.getActionId(), this.option.getParameters());
        }
    }
}

