/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.script;

import com.google.common.base.Charsets;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEnvironment {
    static Logger log = LoggerFactory.getLogger(ScriptEnvironment.class);
    private final String name;
    private final GroovyShell groovy;
    private final Binding context;
    private boolean initialized;
    private final List<Script> api = new ArrayList<Script>();

    public ScriptEnvironment(String name) {
        this.name = name;
        this.context = new Binding();
        this.groovy = new GroovyShell(this.context);
    }

    public ScriptEnvironment addApiResources(String ... resources) {
        for (String s : resources) {
            this.api.add(this.compileApiResource(s));
        }
        return this;
    }

    public ScriptEnvironment addAApiFiles(File ... files) {
        for (File f : files) {
            this.api.add(this.compileApiFile(f));
        }
        return this;
    }

    public void setBinding(String name, Object value) {
        this.context.setProperty(name, value);
    }

    public Object getBinding(String name) {
        return this.context.getProperty(name);
    }

    public void initializeApi() {
        if (this.initialized) {
            return;
        }
        for (Script script : this.api) {
            if (log.isDebugEnabled()) {
                log.debug("evaluating API script:" + script);
            }
            Object result = script.run();
            if (!log.isDebugEnabled()) continue;
            log.debug("result:" + result);
        }
    }

    protected Script compileApiResource(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new RuntimeException("Script resource not found for:" + resource);
        }
        return this.compile(in, resource);
    }

    protected Script compileApiFile(File file) {
        return this.compile(file);
    }

    protected Script compile(Reader in, String fileName) {
        if (fileName.indexOf(45) >= 0) {
            fileName = fileName.replaceAll("-", "_");
        }
        Script result = this.groovy.parse(in, fileName);
        return result;
    }

    protected Script compile(InputStream in, String fileName) {
        return this.compile(new InputStreamReader(in, Charsets.UTF_8), fileName);
    }

    protected Script compile(File f) {
        try {
            return this.compile(new FileReader(f), String.valueOf(f));
        }
        catch (IOException e) {
            throw new RuntimeException("Error compiling:" + f, e);
        }
    }

    public Object evalResource(String s) {
        InputStream is = this.getClass().getResourceAsStream(s);
        if (is == null) {
            throw new IllegalArgumentException("Script resource not found for:" + s);
        }
        return this.eval(is, s);
    }

    public Object eval(URL u) {
        try {
            return this.eval(u.openStream(), String.valueOf(u));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading:" + u, e);
        }
    }

    public Object eval(URI u) {
        try {
            return this.eval(u.toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Script URI error:" + u, e);
        }
    }

    public Object eval(File f) {
        return this.eval(f.toURI());
    }

    public Object eval(InputStream is, String s) {
        if (log.isDebugEnabled()) {
            log.debug("evaluating:" + s);
        }
        Script script = this.compile(is, s);
        int before = this.context.getVariables().size();
        Object result = script.run();
        if (log.isTraceEnabled()) {
            log.trace("result:" + result);
        }
        if (before != this.context.getVariables().size()) {
            log.warn("Binding count increased executing:" + s + "  keys:" + this.context.getVariables().keySet());
        }
        return result;
    }
}

