/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.bits;

public final class DoubleBits {
    private final double minValue;
    private final double maxValue;
    private final int bits;
    private final int resolution;
    private final long mask;
    private final double mult;
    private final double invMult;

    public DoubleBits(double minValue, double maxValue, int bits) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("Min value must be less than max value.");
        }
        if (bits == 0 || bits >= 64) {
            throw new IllegalArgumentException("Bits must be in the range 0 - 63");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.bits = bits;
        this.resolution = (int)Math.pow(2.0, bits);
        this.mask = -1L >>> 64 - bits;
        this.mult = (double)(this.resolution - 1) / (maxValue - minValue);
        this.invMult = (maxValue - minValue) / (double)(this.resolution - 1);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getBitSize() {
        return this.bits;
    }

    public long getMask() {
        return this.mask;
    }

    public double getDoubleResolution() {
        return this.invMult;
    }

    public long toBits(double value) {
        if (value < this.minValue) {
            System.out.println("!!!! DoubleBits *** underflow:" + value + "  under:" + this.minValue);
            return 0L;
        }
        if (value > this.maxValue) {
            System.out.println("!!!! DoubleBits *** overflow:" + value + "  over:" + this.maxValue);
            return this.resolution - 1;
        }
        double f = Math.round((value - this.minValue) * this.mult);
        return (long)f;
    }

    public double fromBits(long bits) {
        double f = (double)(bits &= this.mask) * this.invMult;
        return f += this.minValue;
    }

    public static void main(String ... args) {
        DoubleBits test1 = new DoubleBits(-35.6f, 35.6f, 8);
        DoubleBits test2 = new DoubleBits(-35.6f, 35.6f, 16);
        double loopMax = 10.0;
        for (double f = 0.0; f <= loopMax; f += (double)0.001f) {
            long bits1 = test1.toBits(f);
            long bits2 = test2.toBits(f);
            System.out.println("f:" + f + "  bits1:" + Long.toHexString(bits1) + "  rev1:" + test1.fromBits(bits1) + "  bits2:" + Long.toHexString(bits2) + "  rev2:" + test2.fromBits(bits2));
        }
        long bits1 = test1.toBits(loopMax);
        long bits2 = test2.toBits(loopMax);
        System.out.println("f:" + loopMax + "  bits1:" + Long.toHexString(bits1) + "  rev1:" + test1.fromBits(bits1) + "  bits2:" + Long.toHexString(bits2) + "  rev2:" + test2.fromBits(bits2));
    }
}

