/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.ColumnChangeListener;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.TileListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorld
implements World {
    static Logger log = LoggerFactory.getLogger(AbstractWorld.class);

    protected AbstractWorld() {
    }

    @Override
    public int getWorldCell(Vec3d world) {
        LeafId id = LeafId.fromWorld(world);
        LeafData leaf = this.getLeaf(id);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell(world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell(world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell(world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    @Override
    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld(worldLocation));
    }

    @Override
    public void addTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTileListener(TileListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLeafChangeListener(LeafChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLeafChangeListener(LeafChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCellChangeListener(CellChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCellChangeListener(CellChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumnChangeListener(ColumnChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeColumnChangeListener(ColumnChangeListener l) {
        throw new UnsupportedOperationException();
    }
}

