/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractNoiseElevationGenerator;

public class HeterogenousFractalElevations
extends AbstractNoiseElevationGenerator {
    private double fractalIncrement = 0.75;
    private double lacunarity = 3.09;
    private int octaves = 4;
    private double offset = 0.5;
    private int maxOctaves = 128;
    private double[] exponents = new double[this.maxOctaves];

    public HeterogenousFractalElevations() {
        super("Heterogenous Fractal");
        this.setFrequency(128);
    }

    @Override
    protected void reinitialize() {
        for (int i = 0; i < this.maxOctaves; ++i) {
            this.exponents[i] = Math.pow(this.lacunarity, (double)(-i) * this.fractalIncrement);
        }
    }

    public void setFractalIncrement(double d) {
        if (this.fractalIncrement == d) {
            return;
        }
        this.fractalIncrement = d;
        this.invalidate();
    }

    public double getFractalIncrement() {
        return this.fractalIncrement;
    }

    public void setLacunarity(double d) {
        if (this.lacunarity == d) {
            return;
        }
        this.lacunarity = d;
        this.invalidate();
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setOctaves(int d) {
        if (this.octaves == d) {
            return;
        }
        this.octaves = d;
        this.invalidate();
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOffset(double d) {
        if (this.offset == d) {
            return;
        }
        this.offset = d;
        this.invalidate();
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    protected double getElevation(double x, double y, double z) {
        int i;
        double value = this.noise.getNoise(x, y) + this.offset;
        x *= this.lacunarity;
        y *= this.lacunarity;
        z *= this.lacunarity;
        for (i = 1; i < this.octaves; ++i) {
            double increment = this.noise.getNoise(x, y) + this.offset;
            increment *= this.exponents[i];
            value += (increment *= value);
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        double remainder = this.octaves - this.octaves;
        if (remainder != 0.0) {
            double increment = this.noise.getNoise(x, y) + this.offset;
            value += remainder * (increment *= this.exponents[i]) * value;
        }
        return value;
    }
}

