/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import java.io.Serializable;
import java.util.Arrays;

public class CellArray
implements CellData,
Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private int[] array;

    public CellArray(int size) {
        this(size, size, size);
    }

    public CellArray(int xSize, int ySize, int zSize) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.array = new int[xSize * ySize * zSize];
    }

    public CellArray clone() {
        try {
            CellArray clone = (CellArray)super.clone();
            clone.array = new int[this.array.length];
            System.arraycopy(this.array, 0, clone.array, 0, this.array.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Checked exceptions are fun", e);
        }
    }

    public final void clear() {
        Arrays.fill(this.array, 0);
    }

    public final void clear(int value) {
        Arrays.fill(this.array, value);
    }

    public final void set(CellArray cells) {
        if (cells.xSize != this.xSize || cells.ySize != this.ySize || cells.zSize != this.zSize) {
            throw new IllegalArgumentException("Cell sizes do not match, this:" + this + " cells:" + cells);
        }
        System.arraycopy(cells.array, 0, this.array, 0, this.array.length);
    }

    public final int getSizeX() {
        return this.xSize;
    }

    public final int getSizeY() {
        return this.ySize;
    }

    public final int getSizeZ() {
        return this.zSize;
    }

    public Vec3i getSize() {
        return new Vec3i(this.xSize, this.ySize, this.zSize);
    }

    public final int[] getArray() {
        return this.array;
    }

    private int index(int x, int y, int z) {
        return x * this.ySize * this.zSize + z * this.ySize + y;
    }

    @Override
    public final int getCell(int x, int y, int z) {
        return this.array[this.index(x, y, z)];
    }

    @Override
    public final int getCell(int x, int y, int z, int defaultValue) {
        if (x < 0 || y < 0 || z < 0) {
            return defaultValue;
        }
        if (x >= this.xSize || y >= this.ySize || z >= this.zSize) {
            return defaultValue;
        }
        return this.getCell(x, y, z);
    }

    @Override
    public final int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    @Override
    public final void setCell(int x, int y, int z, int type) {
        this.array[this.index((int)x, (int)y, (int)z)] = type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("xSize", this.xSize).add("ySize", this.ySize).add("zSize", this.zSize).toString();
    }
}

