/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.event.ErrorEvent;
import com.simsilica.event.EventBus;
import com.simsilica.sim.Blackboard;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.SimEvent;
import com.simsilica.sim.SimTime;
import com.simsilica.sim.SystemTiming;
import com.simsilica.sim.TaskDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class GameSystemManager {
    static Logger log = LoggerFactory.getLogger(GameSystemManager.class);
    private State state = State.Terminated;
    private final Map<Class, Object> index = new HashMap<Class, Object>();
    private final List<GameSystem> systems = new ArrayList<GameSystem>();
    private GameSystem[] systemArray = null;
    private final SimTime stepTime = new SimTime();
    private final SimEvent simEvent = new SimEvent(this);
    private SystemTiming timing;
    private final List<GameSystem> initialized = new ArrayList<GameSystem>();
    private final List<GameSystem> started = new ArrayList<GameSystem>();

    public GameSystemManager() {
        this.register(TaskDispatcher.class, new TaskDispatcher());
        this.register(Blackboard.class, new Blackboard());
    }

    public void setSystemTiming(SystemTiming timing) {
        this.timing = timing;
    }

    public SystemTiming getSystemTiming() {
        return this.timing;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        TaskDispatcher dispatcher = this.get(TaskDispatcher.class);
        if (dispatcher == null) {
            throw new RuntimeException("No TaskDispatcher registered");
        }
        return dispatcher.enqueue(callable);
    }

    private GameSystem[] getArray() {
        if (this.systemArray != null) {
            return this.systemArray;
        }
        this.systemArray = this.systems.toArray(new GameSystem[this.systems.size()]);
        return this.systemArray;
    }

    public void initialize() {
        log.trace("initialize()");
        if (this.state != State.Terminated) {
            throw new RuntimeException("Already initialized.");
        }
        this.state = State.Initializing;
        EventBus.publish(SimEvent.simInitializing, this.simEvent);
        try {
            for (GameSystem sys : this.getArray()) {
                if (log.isTraceEnabled()) {
                    log.trace("initializing:" + sys);
                }
                sys.initialize(this);
                this.initialized.add(sys);
            }
            this.state = State.Initialized;
            EventBus.publish(SimEvent.simInitialized, this.simEvent);
        }
        catch (RuntimeException e) {
            EventBus.publish(SimEvent.simFailed, this.simEvent);
            if (!this.initialized.isEmpty()) {
                log.warn("Terminating " + this.initialized.size() + " initialized systems from partial initialization.");
                this.terminateSystems();
            }
            throw e;
        }
    }

    public boolean isInitialized() {
        switch (this.state) {
            case Initialized: 
            case Starting: 
            case Started: 
            case Stopping: 
            case Stopped: {
                return true;
            }
        }
        return false;
    }

    public boolean isStarted() {
        switch (this.state) {
            case Started: {
                return true;
            }
        }
        return false;
    }

    public void terminate() {
        log.trace("terminate()");
        if (!this.isInitialized()) {
            throw new RuntimeException("Not initialized.  State:" + (Object)((Object)this.state));
        }
        this.state = State.Terminating;
        EventBus.publish(SimEvent.simTerminating, this.simEvent);
        this.terminateSystems();
        this.state = State.Terminated;
        EventBus.publish(SimEvent.simTerminated, this.simEvent);
    }

    public void start() {
        log.trace("start()");
        if (!this.isInitialized()) {
            throw new RuntimeException("Not initialized");
        }
        if (this.isStarted()) {
            return;
        }
        this.updateTime();
        this.state = State.Starting;
        EventBus.publish(SimEvent.simStarting, this.simEvent);
        try {
            for (GameSystem sys : this.getArray()) {
                if (log.isTraceEnabled()) {
                    log.trace("starting:" + sys);
                }
                sys.start();
                this.started.add(sys);
            }
            this.state = State.Started;
            EventBus.publish(SimEvent.simStarted, this.simEvent);
        }
        catch (RuntimeException e) {
            log.error("Error starting systems", (Throwable)e);
            EventBus.publish(SimEvent.simFailed, this.simEvent);
            EventBus.publish(ErrorEvent.fatalError, new ErrorEvent(e));
            if (!this.started.isEmpty()) {
                log.warn("Stopping " + this.started.size() + " started systems from partial startup.");
                this.stopSystems();
            }
            if (!this.initialized.isEmpty()) {
                log.warn("Terminating " + this.initialized.size() + " initialized systems from partial startup.");
                this.terminateSystems();
            }
            throw e;
        }
    }

    public void stop() {
        log.trace("stop()");
        if (!this.isStarted()) {
            return;
        }
        this.state = State.Stopping;
        EventBus.publish(SimEvent.simStopping, this.simEvent);
        this.stopSystems();
        this.state = State.Stopped;
        EventBus.publish(SimEvent.simStopped, this.simEvent);
    }

    protected void terminateSystems() {
        for (GameSystem sys : this.initialized) {
            if (log.isTraceEnabled()) {
                log.trace("terminating:" + sys);
            }
            try {
                sys.terminate(this);
            }
            catch (Exception e) {
                this.onTerminateError(sys, e);
            }
        }
    }

    protected void stopSystems() {
        for (GameSystem sys : this.started) {
            if (log.isTraceEnabled()) {
                log.trace("stopping:" + sys);
            }
            try {
                sys.stop();
            }
            catch (Exception e) {
                this.onStopError(sys, e);
            }
        }
    }

    protected void onStopError(GameSystem sys, Throwable t) {
        log.error("Error stopping system:" + sys, t);
    }

    protected void onTerminateError(GameSystem sys, Throwable t) {
        log.error("Error terminating system:" + sys, t);
    }

    protected void attachSystem(GameSystem system) {
        this.systems.add(system);
        this.systemArray = null;
        if (this.isInitialized() || this.state == State.Initializing) {
            if (log.isTraceEnabled()) {
                log.trace("initializing:" + system);
            }
            system.initialize(this);
        }
        if (this.isStarted() || this.state == State.Starting) {
            if (log.isTraceEnabled()) {
                log.trace("starting:" + system);
            }
            system.start();
        }
    }

    protected void detachSystem(GameSystem system) {
        this.systems.remove(system);
        this.systemArray = null;
        if (this.isStarted() && this.state != State.Stopping) {
            if (log.isTraceEnabled()) {
                log.trace("stopping:" + system);
            }
            system.stop();
        }
        if (this.isInitialized() && this.state != State.Terminating) {
            if (log.isTraceEnabled()) {
                log.trace("terminating:" + system);
            }
            system.terminate(this);
        }
    }

    public void addSystem(GameSystem system) {
        this.attachSystem(system);
    }

    public void removeSystem(GameSystem system) {
        this.index.values().remove(system);
        this.detachSystem(system);
    }

    public <T> T get(Class<T> type) {
        return this.get(type, false);
    }

    public <T> T get(Class<T> type, boolean failOnMiss) {
        Object result = this.index.get(type);
        if (result == null && failOnMiss) {
            throw new IllegalArgumentException("System not found for:" + type);
        }
        return type.cast(result);
    }

    public <T, S extends T> T register(Class<T> type, S object) {
        Object previous = this.index.put(type, object);
        if (previous != null && previous instanceof GameSystem) {
            this.detachSystem((GameSystem)previous);
        }
        if (object instanceof GameSystem) {
            this.attachSystem((GameSystem)object);
        }
        return type.cast(object);
    }

    public void update() {
        try {
            this.updateTime();
            String frame = String.format("%06d", this.stepTime.getFrame());
            try (MDC.MDCCloseable temp = MDC.putCloseable((String)"frame", (String)frame);){
                if (this.timing != null) {
                    this.timing.startFrame();
                    for (GameSystem sys : this.getArray()) {
                        try (SystemTiming.TimingInfo info = this.timing.trackUpdate(sys);){
                            sys.update(this.stepTime);
                        }
                    }
                    this.timing.endFrame();
                } else {
                    for (GameSystem sys : this.getArray()) {
                        sys.update(this.stepTime);
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Error updating systems", t);
            EventBus.publish(ErrorEvent.fatalError, new ErrorEvent(t));
        }
    }

    protected void updateTime() {
        long time = System.nanoTime();
        this.stepTime.update(time);
    }

    public SimTime getStepTime() {
        return this.stepTime;
    }

    static enum State {
        Terminated,
        Initializing,
        Initialized,
        Starting,
        Started,
        Stopping,
        Stopped,
        Terminating;

    }
}

