/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.simsilica.ethereal.SharedObject;
import com.simsilica.ethereal.SharedObjectListener;
import com.simsilica.ethereal.net.FrameState;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SharedObjectSpace {
    private final ObjectStateProtocol objectProtocol;
    private final Map<Integer, SharedObject> objects = new HashMap<Integer, SharedObject>();
    private final ConcurrentLinkedQueue<SharedObjectListener> toAdd = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<SharedObjectListener> toRemove = new ConcurrentLinkedQueue();
    private final List<SharedObjectListener> listeners = new ArrayList<SharedObjectListener>();
    private SharedObjectListener[] listenerArray;

    public SharedObjectSpace(ObjectStateProtocol objectProtocol) {
        this.objectProtocol = objectProtocol;
    }

    public final ObjectStateProtocol getObjectProtocol() {
        return this.objectProtocol;
    }

    public SharedObject getObject(int networkId, Long entityId) {
        SharedObject result = this.objects.get(networkId);
        if (result == null) {
            result = new SharedObject(this, networkId, entityId);
            this.objects.put(networkId, result);
        }
        return result;
    }

    public SharedObject getObject(int networkId) {
        return this.objects.get(networkId);
    }

    public void removeObject(SharedObject so) {
        this.objects.remove(so.getNetworkId());
    }

    public Collection<SharedObject> objects() {
        return this.objects.values();
    }

    public void addObjectListener(SharedObjectListener l) {
        this.toAdd.add(l);
        this.toRemove.remove(l);
    }

    public void removeObjectListener(SharedObjectListener l) {
        this.toRemove.add(l);
        this.toAdd.remove(l);
    }

    private SharedObjectListener[] getListeners() {
        if (this.listenerArray == null) {
            this.listenerArray = new SharedObjectListener[this.listeners.size()];
            this.listenerArray = this.listeners.toArray(this.listenerArray);
        }
        return this.listenerArray;
    }

    public final void beginFrame(long time) {
        SharedObjectListener l;
        while (!this.toAdd.isEmpty()) {
            l = this.toAdd.poll();
            this.listeners.add(l);
            this.listenerArray = null;
        }
        while (!this.toRemove.isEmpty()) {
            l = this.toRemove.poll();
            this.listeners.remove(l);
            this.listenerArray = null;
        }
        for (SharedObjectListener l2 : this.getListeners()) {
            l2.beginFrame(time);
        }
    }

    protected final void objectUpdated(SharedObject obj) {
        for (SharedObjectListener l : this.getListeners()) {
            l.objectUpdated(obj);
        }
    }

    protected final void objectRemoved(SharedObject obj) {
        for (SharedObjectListener l : this.getListeners()) {
            l.objectRemoved(obj);
        }
    }

    public final void endFrame() {
        for (SharedObjectListener l : this.getListeners()) {
            l.endFrame();
        }
    }

    public void updateBaseline(List<FrameState> frames) {
        for (FrameState frame : frames) {
            for (ObjectState state : frame.states) {
                SharedObject so = this.getObject(state.networkId);
                if (so == null) continue;
                so.updateBaseline(frame.time, state);
            }
        }
    }
}

