/*
 * $Id$
 *
 * Copyright (c) 2023, Simsilica, LLC
 * All rights reserved.
 */

def markObjectTypeName = "!mark"
def markObjectType = ObjectTypeInfo.create(markObjectTypeName, entityData);
def markFilter = Filters.fieldEquals(ObjectTypeInfo.class, "typeId", markObjectType.typeId);

if( true ) {
    // See if we need to fix marks.
    def rootEntities = findEntities(ContainedIn.rootFilter(worldManager.worldEntity),
                                    ContainedIn.class, ObjectTypeInfo.class, Name.class, SpawnPosition.class);
    def markEntity = rootEntities.find{ markFilter.evaluate(it[ObjectTypeInfo.class]) };
    log.info("markEntity:" + markEntity);
    if( !markEntity ) {
        def allMarks = findEntities(markFilter, Name.class, ObjectTypeInfo.class, SpawnPosition.class);
        allMarks.each { mark ->
            if( mark[ContainedIn] == null ) {
                log.info("Migrating mark:" + mark[Name]);
                mark << new ContainedIn(worldManager.worldEntity, worldManager.worldEntity,
                                        0, 0, ContainedIn.TYPE_SPECIAL, 0);
            }
        }
    }
}

getMarks = { EntityId owner ->
    def owned = findEntities(ContainedIn.rootTypeFilter(owner, ContainedIn.TYPE_SPECIAL),
                             ContainedIn.class, ObjectTypeInfo.class, Name.class, SpawnPosition.class);
    return owned.findAll { markFilter.evaluate(it[ObjectTypeInfo.class]) };
    //return findEntities(markFilter, Name.class, ObjectTypeInfo.class, SpawnPosition.class);
}

setMark = { EntityId owner, String name, SpawnPosition pos ->
    log.info("setMark(" + name+ ", " + pos + ")");
    // See if there already is an entity with this name
    def mark = getMark(owner, name);
    if( mark ) {
        mark << pos
    } else {
        mark = createEntity(
            new Name(name),
            markObjectType,
            pos,
            new ContainedIn(owner, owner, 0, 0, ContainedIn.TYPE_SPECIAL, 0)
        );
    }
    return mark;
}

getMark = { EntityId owner, String name ->
    for( def mark : getMarks(owner) ) {
        if( name == mark.name ) {
            return mark;
        }
    }
    return null;
}

removeMark = { EntityId owner, String name ->
    def mark = getMark(owner, name);
    if( mark ) {
        entityData.removeEntity(mark);
        return mark;
    } else {
        return null;
    }
}

transferMark = { EntityId mark, EntityId to ->
    mark << new ContainedIn(to, to, 0, 0, ContainedIn.TYPE_SPECIAL, 0)
}

