/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.Filters;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMapLine
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(CustomMapLine.class);
    public static final int INDEX_TILE = 0;
    public static final int INDEX_SEDECTILE = 1;
    private Vec3d end1;
    private Vec3d end2;
    private int patternId;
    @IndexedField
    private long tileId1;
    @IndexedField
    private long tileId2;

    private CustomMapLine() {
    }

    public CustomMapLine(Vec3d end1, Vec3d end2, int patternId) {
        this.end1 = end1;
        this.end2 = end2;
        this.patternId = patternId;
        this.tileId1 = TileId.fromWorld((Vec3d)end1).getId();
        this.tileId2 = TileId.fromWorld((Vec3d)end2).getId();
    }

    public static CustomMapLine create(Vec3d end1, Vec3d end2, String pattern, EntityData ed) {
        int id = ed.getStrings().getStringId(pattern, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(pattern, true);
        }
        return new CustomMapLine(end1, end2, id);
    }

    public static ComponentFilter<CustomMapLine> filterTileId(long tileId) {
        ComponentFilter f1 = Filters.fieldEquals(CustomMapLine.class, (String)"tileId1", (Object)tileId);
        ComponentFilter f2 = Filters.fieldEquals(CustomMapLine.class, (String)"tileId2", (Object)tileId);
        return Filters.or(CustomMapLine.class, (ComponentFilter[])new ComponentFilter[]{f1, f2});
    }

    public CustomMapLine move(Vec3d end1, Vec3d end2) {
        return new CustomMapLine(end1, end2, this.patternId);
    }

    public Vec3d getEnd1() {
        return this.end1;
    }

    public Vec3d getEnd2() {
        return this.end2;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public String getPatternName(EntityData ed) {
        if (this.patternId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.patternId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.patternId) : this.getPatternName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("end1", (Object)this.end1).add("end2", (Object)this.end2).add("patternId", (Object)s).toString();
    }
}

