/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.google.common.base.Strings;
import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mythruna.character.RaceType;
import mythruna.character.RaceTypeIndex;
import mythruna.client.net.character.AbstractCharacterPage;
import mythruna.client.net.character.CharacterEditor;
import mythruna.client.ui.MarkdownUtil;
import mythruna.es.Race;
import mythruna.text.md.MarkdownBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaceSelectorPage
extends AbstractCharacterPage {
    static Logger log = LoggerFactory.getLogger(RaceSelectorPage.class);
    public static final String DEFAULT_THUMBNAIL = "Interface/human-thumb1.jpg";
    private RaceTypeIndex raceIndex;
    private VersionedList<String> raceList = new VersionedList();
    private Selector<String> race;
    private VersionedReference<String> currentRaceRef;
    private Container raceDescription;
    private Label view;
    private Map<String, MarkdownBuffer> raceText = new HashMap<String, MarkdownBuffer>();
    private Map<String, MarkdownBuffer> subtypeText = new HashMap<String, MarkdownBuffer>();
    private Map<String, String> thumbnails = new HashMap<String, String>();
    private int maxTextWidth = 720;

    public RaceSelectorPage() {
        super("Select a Race");
        this.view = new Label("");
        IconComponent icon = new IconComponent(DEFAULT_THUMBNAIL);
        icon.setIconSize(new Vector2f(300.0f, 600.0f));
        this.view.setIcon((GuiComponent)icon);
        Container props = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None)), new Object[0]);
        props.addChild((Node)new Label("Race:"), new Object[0]);
        this.race = (Selector)props.addChild((Node)new Selector(this.raceList), new Object[]{1});
        props.setInsets(new Insets3f(5.0f, 5.0f, 10.0f, 5.0f));
        this.currentRaceRef = this.race.createSelectedItemReference();
        this.raceDescription = (Container)this.addChild((Node)new Container(new ElementId("book.page")), new Object[0]);
    }

    @Override
    protected void onInitialize(CharacterEditor parent) {
        this.raceIndex = parent.getRaces();
        this.resetRaces();
    }

    @Override
    protected boolean onSetCharacter(Entity character) {
        Race race = this.getBaseComponent(Race.class);
        log.info("race:" + race);
        return character != null && race == null;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.currentRaceRef.update()) {
            this.resetRaceInfo();
        }
    }

    @Override
    public Panel getView() {
        return this.view;
    }

    protected void resetRaces() {
        this.raceList.clear();
        this.raceText.clear();
        this.thumbnails.clear();
        this.subtypeText.clear();
        for (RaceType race : this.raceIndex.getRaces()) {
            String description;
            MarkdownBuffer text;
            String name = race.getName();
            if (this.raceList.indexOf((Object)name) < 0) {
                this.raceList.add((Object)name);
            }
            if ((text = this.raceText.get(name)) == null) {
                text = new MarkdownBuffer();
                this.raceText.put(name, text);
            }
            if (!Strings.isNullOrEmpty((String)(description = race.getDescription()))) {
                text.append(description);
            }
            String subtype = race.getSubtype();
            String subtypeDesc = race.getSubtypeDescription();
            if (subtypeDesc != null) {
                this.subtypeText.put(name + "-" + subtype, new MarkdownBuffer(subtypeDesc));
            }
            if (Strings.isNullOrEmpty((String)race.getImageId())) continue;
            this.thumbnails.put(name, race.getImageId());
        }
    }

    protected void resetRaceInfo() {
        String name = (String)this.race.getSelectedItem();
        String imageId = this.thumbnails.get(name);
        if (imageId == null) {
            imageId = DEFAULT_THUMBNAIL;
        }
        IconComponent icon = new IconComponent(imageId);
        icon.setIconSize(new Vector2f(300.0f, 600.0f));
        this.view.setIcon((GuiComponent)icon);
        MarkdownBuffer md = this.raceText.get(name);
        MarkdownUtil.populateContainer(this.raceDescription, (float)this.maxTextWidth, md);
        ArrayList<SelectSubtypeAction> actions = new ArrayList<SelectSubtypeAction>();
        LinkedHashMap<String, MarkdownBuffer> nested = new LinkedHashMap<String, MarkdownBuffer>();
        for (RaceType race : this.raceIndex.getRaces()) {
            String raceName = race.getName();
            if (!name.equals(raceName)) continue;
            String type = race.getSubtype();
            actions.add(new SelectSubtypeAction(race.getBaseId(), name, type));
            MarkdownBuffer sub = this.subtypeText.get(name + "-" + type);
            if (sub == null) continue;
            nested.put(type, sub);
        }
        if (!nested.isEmpty()) {
            TabbedPanel tabs = new TabbedPanel(new ElementId("book.tabbedPanel"), null);
            for (Map.Entry e : nested.entrySet()) {
                Container tab = MarkdownUtil.createContainer(new ElementId("book.page"));
                MarkdownUtil.populateContainer(tab, (float)this.maxTextWidth, (MarkdownBuffer)e.getValue());
                tabs.addTab((String)e.getKey(), (Panel)tab);
            }
            this.raceDescription.addChild((Node)tabs, new Object[0]);
        }
        this.setNextActions(actions.toArray(new Action[0]));
        this.getCharacterEditor().resetButtons();
    }

    protected void saveRaceAndType(String baseId) {
        log.info("saveRaceAndType(" + baseId + ")");
        this.setComponent((EntityComponent)Race.create((String)baseId, (EntityData)this.getEntityData()));
        this.getCharacterEditor().nextPage();
    }

    protected class SelectSubtypeAction
    extends EmptyAction {
        private String baseId;
        private String race;
        private String subtype;

        public SelectSubtypeAction(String baseId, String race, String subtype) {
            super("Select:" + race + " - " + subtype);
            this.baseId = baseId;
            this.race = race;
            this.subtype = subtype;
        }

        public void execute(Button source) {
            RaceSelectorPage.this.saveRaceAndType(this.baseId);
        }
    }
}

