/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jme3.scene.Spatial;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.phys.MBlockShape;
import java.util.Objects;
import mythruna.client.view.object.SpatialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialCache {
    static Logger log = LoggerFactory.getLogger(SpatialCache.class);
    private ShapeFactory<MBlockShape> shapeFactory;
    private SpatialFactory spatialFactory;
    private LoadingCache<SpatialKey, CloneMaster> cache;

    public SpatialCache(ShapeFactory<MBlockShape> shapeFactory, SpatialFactory spatialFactory) {
        this.shapeFactory = shapeFactory;
        this.spatialFactory = spatialFactory;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<SpatialKey, CloneMaster>(){

            public CloneMaster load(SpatialKey key) {
                return SpatialCache.this.createMaster(key);
            }
        });
    }

    public Spatial createSpatial(String name, double scale) {
        return ((CloneMaster)this.cache.getUnchecked((Object)new SpatialKey(this, name, scale))).cloneSpatial();
    }

    protected CloneMaster createMaster(SpatialKey key) {
        MBlockShape shape = (MBlockShape)this.shapeFactory.createShape(key.name, key.scale, null);
        return new CloneMaster(this, this.spatialFactory.createSpatial(shape));
    }

    private class SpatialKey {
        String name;
        double scale;

        public SpatialKey(SpatialCache spatialCache, String name, double scale) {
            this.name = name;
            this.scale = scale;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            SpatialKey other = (SpatialKey)o;
            if (other.scale != this.scale) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.scale);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name + ":" + this.scale + "]";
        }
    }

    private class CloneMaster {
        private Spatial master;

        public CloneMaster(SpatialCache spatialCache, Spatial master) {
            this.master = master;
        }

        public Spatial cloneSpatial() {
            return this.master.clone();
        }
    }
}

