/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3d;
import java.util.function.Consumer;
import mythruna.client.ui.map.IconSet;
import mythruna.es.CustomMapMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMapMarkerEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(CustomMapMarkerEditor.class);
    private EntityId toolId;
    private VersionedList<IconSet.Icon> icons;
    private EntityId editing;
    private Selector<IconSet.Icon> iconSelector;
    private TextField name;
    private Spinner<Double> size;
    private Spinner<Double> pinSize;
    private Vec3d world;
    private Container buttons;
    private ActionButton save;
    private ActionButton delete;
    private ActionButton cancel;
    private Consumer<CustomMapMarkerEditor> saveCallback;
    private Consumer<CustomMapMarkerEditor> deleteCallback;

    public CustomMapMarkerEditor(EntityId toolId, VersionedList<IconSet.Icon> icons) {
        super((GuiLayout)new BorderLayout(), new ElementId("window"));
        this.toolId = toolId;
        this.icons = icons;
        this.addChild((Node)new Label("Custom Marker Editor", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        Container contents = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[]{BorderLayout.Position.Center});
        contents.addChild((Node)new Label("Icon:"), new Object[0]);
        this.iconSelector = new Selector(icons);
        this.iconSelector.setValueRenderer((ValueRenderer)new DefaultValueRenderer<IconSet.Icon>(this){

            public Panel getView(IconSet.Icon value, boolean selected, Panel existing) {
                return value.getName();
            }
        });
        contents.addChild(this.iconSelector, new Object[]{1});
        contents.addChild((Node)new Label("Name:"), new Object[0]);
        this.name = (TextField)contents.addChild((Node)new TextField(""), new Object[]{1});
        contents.addChild((Node)new Label("Size:"), new Object[0]);
        this.size = (Spinner)contents.addChild((Node)new Spinner(SequenceModels.doubleSequence((double)16.0, (double)1.0, (double)1.0)), new Object[]{1});
        contents.addChild((Node)new Label("Pin Size:"), new Object[0]);
        DefaultRangedValueModel pinSizeModel = new DefaultRangedValueModel(0.0, 10.0, 0.0);
        this.pinSize = (Spinner)contents.addChild((Node)new Spinner(SequenceModels.rangedSequence((RangedValueModel)pinSizeModel, (double)1.0, (double)1.0)), new Object[]{1});
        this.buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        this.save = new ActionButton((Action)new CallMethodAction("Save", (Object)this, "save"));
        this.delete = new ActionButton((Action)new CallMethodAction("Delete", (Object)this, "delete"));
        this.cancel = new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancel"));
    }

    protected void resetButtons() {
        this.buttons.clearChildren();
        this.buttons.addChild((Node)this.save, new Object[0]);
        if (this.editing != null) {
            this.save.setText("Save");
            this.buttons.addChild((Node)this.delete, new Object[0]);
        } else {
            this.save.setText("Create");
        }
        this.buttons.addChild((Node)this.cancel, new Object[0]);
    }

    public EntityId getEditing() {
        return this.editing;
    }

    public Vec3d getWorld() {
        return this.world;
    }

    public String getName() {
        return this.name.getText();
    }

    public IconSet.Icon getIcon() {
        return (IconSet.Icon)this.iconSelector.getSelectedItem();
    }

    public int getMarkerSize() {
        return (int)Math.round((Double)this.size.getValue());
    }

    public int getPinSize() {
        return (int)Math.round((Double)this.pinSize.getValue());
    }

    public void create(EntityId toolId, Vec3d world, Consumer<CustomMapMarkerEditor> saveCallback) {
        this.toolId = toolId;
        this.world = world;
        this.editing = null;
        this.saveCallback = saveCallback;
        this.deleteCallback = null;
        this.resetButtons();
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this);
    }

    public void edit(EntityId toolId, Entity entity, Consumer<CustomMapMarkerEditor> saveCallback, Consumer<CustomMapMarkerEditor> deleteCallback) {
        this.toolId = toolId;
        this.editing = entity.getId();
        this.world = ((SpawnPosition)entity.get(SpawnPosition.class)).getLocation();
        this.saveCallback = saveCallback;
        this.deleteCallback = deleteCallback;
        this.name.setText(((Name)entity.get(Name.class)).getName());
        CustomMapMarker cm = (CustomMapMarker)entity.get(CustomMapMarker.class);
        this.size.setValue((Object)cm.getSize());
        this.pinSize.setValue((Object)cm.getPinSize());
        for (IconSet.Icon icon : this.icons) {
            if (icon.getIconId() != cm.getIconId()) continue;
            this.iconSelector.setSelectedItem((Object)icon);
            break;
        }
        this.resetButtons();
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this);
    }

    protected void save() {
        if (this.editing != null) {
            // empty if block
        }
        this.saveCallback.accept(this);
        this.removeFromParent();
    }

    protected void delete() {
        this.deleteCallback.accept(this);
        this.removeFromParent();
    }

    protected void cancel() {
        this.removeFromParent();
    }
}

