/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.state.DebugHudState;
import com.simsilica.thread.JobState;
import mythruna.SystemInfo;
import mythruna.client.GuiState;
import mythruna.client.MainGameFunctions;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.WorldViewState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudStatsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HudStatsState.class);
    private WorldTimeState timeState;
    private VersionedHolder<String> posText;
    private VersionedHolder<String> colText;
    private VersionedHolder<String> tileText;
    private VersionedHolder<String> xTileText;
    private VersionedHolder<String> velText;
    private VersionedHolder<String> timeOfDayText2;
    private VersionedHolder<String> hostTimeOfDayText;
    private VersionedHolder<String> worldSeed;
    private Vec3d lastPos = new Vec3d();
    private VersionedReference<Vec3d> posRef;
    private JobsTracker regularJobs;
    private JobsTracker priorityJobs;
    private JobsTracker backgroundJobs;
    private double lastAverageVelocity;
    private double averageVelocity;
    private int samples = 10;
    private long lastTime = -1L;
    private long lastHostTime = -1L;
    private Label tempHeader;

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void initialize(Application app) {
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(this.isEnabled());
        this.timeState = (WorldTimeState)this.getState(WorldTimeState.class, true);
        this.posText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Pos", DebugHudState.Location.Right);
        this.colText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Col", DebugHudState.Location.Right);
        this.tileText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Tile", DebugHudState.Location.Right);
        this.xTileText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("xTile", DebugHudState.Location.Right);
        this.worldSeed = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Seed", DebugHudState.Location.Right);
        this.velText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("Vel", DebugHudState.Location.Right);
        this.timeOfDayText2 = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("View GToD", DebugHudState.Location.Right);
        if (this.timeState.getHostTimeSource() != null) {
            this.hostTimeOfDayText = ((DebugHudState)this.getState(DebugHudState.class)).createDebugValue("World GToD", DebugHudState.Location.Right);
        }
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.regularJobs = new JobsTracker(this, "Regular", "regularWorkers");
        this.priorityJobs = new JobsTracker(this, "High", "priorityWorkers");
        this.backgroundJobs = new JobsTracker(this, "Low", "backgroundWorkers");
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(this.isEnabled());
        String buildDate = SystemInfo.getInstance().getBuildDate();
        this.tempHeader = new Label("Engine Test Build v" + buildDate + " - Graphics do not represent final quality.  <Press F1 for help>", new ElementId("hud.label"));
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainGameFunctions.F_DEBUG_HUD, (Object)this, "toggleEnabled");
    }

    protected void cleanup(Application app) {
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(true);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(MainGameFunctions.F_DEBUG_HUD, (Object)this, "toggleEnabled");
    }

    protected void onEnable() {
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(this.isEnabled());
        Node gui = ((GuiState)this.getState(GuiState.class, true)).getGuiRoot();
        gui.attachChild((Spatial)this.tempHeader);
        log.info("screenSize:" + ((GuiState)this.getState(GuiState.class, true)).getGuiSize());
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.tempHeader);
        this.tempHeader.getLocalTranslation().y = 900.0f;
        this.tempHeader.setLocalTranslation(this.tempHeader.getLocalTranslation());
        this.worldSeed.updateObject((Object)String.valueOf(((WorldViewState)this.getState(WorldViewState.class)).getWorldSeed()));
    }

    protected void onDisable() {
        ((DebugHudState)this.getState(DebugHudState.class)).setEnabled(this.isEnabled());
        this.tempHeader.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            Vec3d pos = (Vec3d)this.posRef.get();
            this.posText.updateObject((Object)String.format("%.1f, %.1f, %.1f", pos.x, pos.y, pos.z));
            ColumnId colId = ColumnId.fromWorld((Vec3d)pos);
            this.colText.updateObject((Object)String.valueOf(colId.getWorld(null)));
            TileId tileId = TileId.fromWorld((Vec3d)pos);
            this.tileText.updateObject((Object)String.valueOf(tileId.getWorld(null)));
            SedectileId sedectileId = SedectileId.fromWorld((Vec3d)pos);
            this.xTileText.updateObject((Object)String.valueOf(sedectileId.getWorld(null)));
        }
        double dist = ((Vec3d)this.posRef.get()).distanceSq(this.lastPos);
        this.lastPos.set((Vec3d)this.posRef.get());
        double vel = 0.0;
        if (dist > 0.0) {
            vel = Math.sqrt(dist) / (double)tpf;
        }
        this.averageVelocity = (this.averageVelocity * (double)this.samples + vel) / (double)(this.samples + 1);
        if (Math.abs(this.lastAverageVelocity - this.averageVelocity) > 0.001) {
            this.velText.updateObject((Object)String.format("%.02f", this.averageVelocity));
            this.lastAverageVelocity = this.averageVelocity;
        }
        this.regularJobs.update();
        this.priorityJobs.update();
        this.backgroundJobs.update();
        long gameMinutes = (long)this.timeState.getTotalGameMinutes();
        if (gameMinutes != this.lastTime) {
            this.lastTime = gameMinutes;
            this.timeOfDayText2.updateObject((Object)this.timeState.getWorldTime().asFullString());
        }
        if (this.hostTimeOfDayText != null && (gameMinutes = (long)this.timeState.getTotalGameMinutes()) != this.lastHostTime) {
            this.hostTimeOfDayText.updateObject((Object)this.timeState.getHostWorldTime().asFullString());
        }
    }

    public static String timeToString(double time) {
        int minutes = (int)(time * 12.0 * 60.0);
        return String.format("%02d:%02d", minutes / 60, minutes % 60);
    }

    private class JobsTracker {
        VersionedHolder<String> jobsText;
        VersionedReference<Integer> queuedRef;
        VersionedReference<Integer> activeRef;

        public JobsTracker(HudStatsState hudStatsState, String name, String poolId) {
            this.jobsText = ((DebugHudState)hudStatsState.getState(DebugHudState.class)).createDebugValue(name, DebugHudState.Location.Right);
            JobState jobs = (JobState)hudStatsState.getState(poolId, JobState.class);
            this.queuedRef = jobs.createQueuedCountReference();
            this.activeRef = jobs.createActiveCountReference();
        }

        public void update() {
            if (this.queuedRef.update() || this.activeRef.update()) {
                this.jobsText.updateObject((Object)("Queued:" + this.queuedRef.get() + " Active:" + this.activeRef.get()));
            }
        }
    }
}

