/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly.db;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.assembly.db.SubassemblyStorage;
import mythruna.assembly.io.SubassemblyProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubassemblyStorage
implements SubassemblyStorage {
    static Logger log = LoggerFactory.getLogger(DefaultSubassemblyStorage.class);
    private File root;
    private HashFunction crc32 = Hashing.crc32();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultSubassemblyStorage(File root) {
        this.root = root;
    }

    protected File idToFile(long id) {
        String name = String.format("%016x", id);
        String prefix = "" + name.charAt(0) + name.charAt(1) + "/" + name.charAt(2) + name.charAt(3);
        return new File(this.root, prefix + "/" + name + ".asm");
    }

    @Override
    public Subassembly apply(SubassemblyId id) {
        return this.get(id);
    }

    @Override
    public Subassembly get(SubassemblyId id) {
        File f = this.idToFile(id.getId());
        if (!f.exists()) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            Subassembly subassembly = this.readSubassembly(f);
            return subassembly;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + id, e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean exists(SubassemblyId id) {
        File f = this.idToFile(id.getId());
        return f.exists();
    }

    protected long calculateBaseId(byte[] bytes, Subassembly array) {
        HashCode hash = this.crc32.hashBytes(bytes);
        long hashId = (long)hash.asInt() & 0xFFFFFFFFL;
        long baseId = hashId << 31;
        return baseId;
    }

    protected boolean regurgitation(byte[] bytes, Subassembly data) {
        Subassembly test = SubassemblyProtocol.fromBytes(bytes);
        return data.isSimilar(test, 1.0E-4, 1.0E-4);
    }

    @Override
    public SubassemblyId store(Subassembly data) {
        if (data == null) {
            throw new IllegalArgumentException("Subassembly cannot be null");
        }
        byte[] bytes = SubassemblyProtocol.toBytes(data);
        assert (this.regurgitation(bytes, data));
        long baseId = this.calculateBaseId(bytes, data);
        this.lock.writeLock().lock();
        try {
            long actualId = this.storeBytes(baseId, bytes);
            SubassemblyId subassemblyId = new SubassemblyId(actualId);
            return subassemblyId;
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing subassembly:" + data, e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void logBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0 && i % 32 == 0) {
                sb.append("\n");
            } else if (i > 0) {
                sb.append(" ");
            }
            sb.append(String.format("%x", bytes[i]));
        }
        log.info(sb.toString());
    }

    protected long storeBytes(long baseId, byte[] bytes) throws IOException {
        long result = baseId;
        int attempts = 0;
        while (attempts >= 0) {
            File f = this.idToFile(result);
            if (!f.exists()) {
                File dir = f.getParentFile();
                if (!dir.exists()) {
                    log.info("Making dirs:" + dir);
                    dir.mkdirs();
                }
                log.info("Writing:" + f + "  length:" + bytes.length);
                Files.write((byte[])bytes, (File)f);
                return result;
            }
            byte[] existing = Files.toByteArray((File)f);
            if (Arrays.equals(bytes, existing)) {
                log.info("array already stored:" + f + "  length:" + existing.length);
                return result;
            }
            log.info(String.format("collision:%x", result));
            ++result;
        }
        throw new IOException("Exceeded maximum collisions for content ID:" + baseId);
    }

    protected Subassembly readSubassembly(File f) throws IOException {
        byte[] array = Files.toByteArray((File)f);
        return SubassemblyProtocol.fromBytes(array);
    }
}

