/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.PersistentComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapToolType
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(MapToolType.class);
    private int typeId;
    private int iconId;

    private MapToolType() {
    }

    public MapToolType(int typeId, int iconId) {
        this.typeId = typeId;
        this.iconId = iconId;
    }

    public static MapToolType create(String type, String icon, EntityData ed) {
        int id2;
        int id1 = ed.getStrings().getStringId(type, false);
        if (id1 < 0) {
            id1 = ed.getStrings().getStringId(type, true);
        }
        if ((id2 = ed.getStrings().getStringId(icon, false)) < 0) {
            id2 = ed.getStrings().getStringId(icon, true);
        }
        return new MapToolType(id1, id2);
    }

    public int getIconId() {
        return this.iconId;
    }

    public String getIconName(EntityData ed) {
        if (this.iconId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.iconId);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String typeName = ed == null ? String.valueOf(this.typeId) : this.getIconName(ed);
        String iconName = ed == null ? String.valueOf(this.iconId) : this.getIconName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("typeId", (Object)typeName).add("iconId", (Object)iconName).toString();
    }
}

