/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import java.io.Serializable;
import mythruna.world.BioInfo;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedectileData
implements Serializable {
    static Logger log = LoggerFactory.getLogger(SedectileData.class);
    public static final int GENERATION_NONE = 0;
    public static final int GENERATION_SAMPLES = 1;
    public static final int GENERATION_REGIONS = 2;
    public static final int GENERATION_SEA_COSTS = 3;
    private static final long serialVersionUID = 42L;
    public static final int SIZE = 128;
    public static final int SPREAD = 128;
    private SedectileId id;
    private Vec3i origin;
    private short[] elevation = new short[16384];
    private int[] metaData = new int[this.elevation.length];
    private int[] seaDistances = new int[this.elevation.length];
    private double[] seaCosts = new double[this.elevation.length];
    private int generationLevel;

    public SedectileData(SedectileId id) {
        this.id = id;
        this.origin = id.getWorld(null);
    }

    public int getSize() {
        return 128;
    }

    public int getSpread() {
        return 128;
    }

    public void setGenerationLevel(int generationLevel) {
        this.generationLevel = generationLevel;
    }

    public int getGenerationLevel() {
        return this.generationLevel;
    }

    public short getElevation(int x, int z) {
        int index = this.index(x, z);
        return this.elevation[index];
    }

    public int getMetaData(int x, int z) {
        int index = this.index(x, z);
        return this.metaData[index];
    }

    public int getSeaDistance(int x, int z) {
        return this.seaDistances[this.index(x, z)];
    }

    public double getSeaCost(int x, int z) {
        return this.seaCosts[this.index(x, z)];
    }

    public boolean resetSeaCosts(int x, int z) {
        boolean changed = false;
        int index = this.index(x, z);
        if (this.seaDistances[index] != Integer.MAX_VALUE) {
            this.seaDistances[index] = Integer.MAX_VALUE;
            changed = true;
        }
        if (this.seaCosts[index] != Double.POSITIVE_INFINITY) {
            this.seaCosts[index] = Double.POSITIVE_INFINITY;
            changed = true;
        }
        return changed;
    }

    public boolean updateSeaCosts(int x, int z, int distance, double cost) {
        boolean changed = false;
        int index = this.index(x, z);
        if (this.seaCosts[index] > cost) {
            this.seaCosts[index] = cost;
            this.seaDistances[index] = distance;
            changed = true;
        }
        return changed;
    }

    public double getTemperature(int metaData) {
        return (double)(metaData >> 24 & 0xFF) / 255.0;
    }

    public double getPrecipitation(int metaData) {
        return (double)(metaData >> 16 & 0xFF) / 255.0;
    }

    public double getSoilQuality(int metaData) {
        return (double)(metaData >> 8 & 0xFF) / 255.0;
    }

    public double getVegetationLevel(int metaData) {
        return (double)(metaData & 0xFF) / 255.0;
    }

    public static int toMetaData(BioInfo info) {
        return SedectileData.toMetaData(info.temperature, info.precipitation, info.soilQuality, info.vegetationLevel);
    }

    public static int toMetaData(double temperature, double precipitation, double soil, double vegetation) {
        int v;
        int s;
        int p;
        int t = (int)(temperature * 255.0);
        if (t < 0) {
            t = 0;
        }
        if ((p = (int)(precipitation * 255.0)) < 0) {
            p = 0;
        }
        if ((s = (int)(soil * 255.0)) < 0) {
            s = 0;
        }
        if ((v = (int)(vegetation * 255.0)) < 0) {
            v = 0;
        }
        int result = t & 0xFF;
        result = result << 8 | p & 0xFF;
        result = result << 8 | s & 0xFF;
        result = result << 8 | v & 0xFF;
        return result;
    }

    private int index(int x, int z) {
        return z * 128 + x;
    }

    public void initialize(WorldFractal fractal) {
        BioInfo info = new BioInfo();
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                double x = this.origin.x + i * 128;
                double z = this.origin.z + j * 128;
                double y = fractal.getElevation(x, z);
                fractal.getBioInfo(x, y, z, info);
                int index = this.index(i, j);
                this.elevation[index] = (short)y;
                this.metaData[index] = SedectileData.toMetaData(info);
                this.seaDistances[index] = Integer.MAX_VALUE;
                this.seaCosts[index] = Double.POSITIVE_INFINITY;
            }
        }
    }
}

