/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.audio.Listener;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;

public class AudioListenerState
extends BaseAppState {
    private Listener listener;
    private Camera camera;
    private float lastTpf;

    @Override
    protected void initialize(Application app) {
        this.camera = app.getCamera();
        this.listener = app.getListener();
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    public void update(float tpf) {
        this.lastTpf = tpf;
    }

    @Override
    public void render(RenderManager rm) {
        if (!this.isEnabled() || this.listener == null) {
            return;
        }
        Vector3f lastLocation = this.listener.getLocation();
        Vector3f currentLocation = this.camera.getLocation();
        Vector3f velocity = this.listener.getVelocity();
        if (!lastLocation.equals(currentLocation)) {
            velocity.set(currentLocation).subtractLocal(lastLocation);
            velocity.multLocal(1.0f / this.lastTpf);
            this.listener.setLocation(currentLocation);
            this.listener.setVelocity(velocity);
        } else if (!velocity.equals(Vector3f.ZERO)) {
            this.listener.setVelocity(Vector3f.ZERO);
        }
        Quaternion lastRotation = this.listener.getRotation();
        Quaternion currentRotation = this.camera.getRotation();
        if (!lastRotation.equals(currentRotation)) {
            this.listener.setRotation(currentRotation);
        }
    }

    @Override
    protected void onEnable() {
    }

    @Override
    protected void onDisable() {
    }
}

