/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.RigidBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallJoint<K, S extends AbstractShape>
implements Joint<K, S> {
    static Logger log = LoggerFactory.getLogger(BallJoint.class);
    K id;
    RigidBody<K, S> altBody;
    Vec3d altOffset;
    RigidBody<K, S> mainBody;
    Vec3d mainOffset;
    Quatd relativeRotation;
    double damping;
    double test1;
    private Contact<K, S> contact = new Contact();

    public BallJoint(K id, RigidBody<K, S> mainBody, Vec3d mainOffset, RigidBody<K, S> altBody, Vec3d altOffset, Quatd relativeRotation, double damping, double test1) {
        this.id = id;
        this.altBody = altBody;
        this.altOffset = altOffset;
        this.mainBody = mainBody;
        this.mainOffset = mainOffset;
        this.relativeRotation = relativeRotation;
        this.damping = damping;
        this.test1 = test1;
        this.contact.setBodies(mainBody, altBody);
        this.contact.friction = -0.7;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public RigidBody<K, S> getMainBody() {
        return this.mainBody;
    }

    @Override
    public RigidBody<K, S> getAltBody() {
        return this.altBody;
    }

    @Override
    public RigidBody<K, S> getOtherBody(RigidBody<K, S> body) {
        if (this.mainBody == body) {
            return this.altBody;
        }
        if (this.altBody == body) {
            return this.mainBody;
        }
        throw new IllegalArgumentException("Specified body:" + body.id + " is not part of this joint:" + this.id);
    }

    @Override
    public boolean isSleepy() {
        if (Math.abs(this.contact.penetration) > 1.0E-5) {
            return false;
        }
        return this.mainBody.isSleepy() && (this.altBody == null || this.altBody.isSleepy());
    }

    @Override
    public void calculateInternals(double step) {
        if (this.altBody == null) {
            this.calculateInternalsUnconstrained(step);
        } else {
            this.calculateInternalsUnconstrainedTwoBody(step);
        }
    }

    @Override
    public void calculatePositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2) {
        this.contact.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact.penetration);
    }

    @Override
    public void calculateVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
        this.contact.calculateVelocityChange(vDelta1, vDelta2, rotDelta1, rotDelta2);
        if (this.damping == 0.0) {
            return;
        }
        double slow = this.damping;
        Vec3d rot = this.mainBody.getRotationalVelocity();
        rotDelta1.addLocal(rot.add(rotDelta1).multLocal(-slow));
        if (this.altBody != null) {
            rot = this.altBody.getRotationalVelocity();
            rotDelta2.addLocal(rot.add(rotDelta2).multLocal(-slow));
        }
    }

    private void calculateInternalsUnconstrained(double step) {
        Vec3d world1 = this.altOffset;
        Vec3d world2 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d delta = world1.subtract(world2);
        Vec3d normal = null;
        double length = delta.length();
        normal = length != 0.0 ? delta.mult(1.0 / length) : new Vec3d(0.0, 1.0, 0.0);
        this.contact.setContactInfo(world2, normal, length);
        this.contact.calculateInternals(step);
    }

    private void calculateInternalsUnconstrainedTwoBody(double step) {
        Vec3d world1 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d world2 = this.altBody.localToWorld(this.altOffset);
        Vec3d delta = world2.subtract(world1);
        Vec3d normal = null;
        double length = delta.length();
        normal = length != 0.0 ? delta.mult(1.0 / length) : new Vec3d(0.0, 1.0, 0.0);
        Vec3d cp = world1.add(world2).multLocal(0.5);
        this.contact.setContactInfo(cp, normal, delta.length());
        this.contact.matchLocalTemperature();
        this.contact.calculateInternals(step);
    }

    @Override
    public void resolve(double step) {
        this.calculateInternals(step);
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.calculatePositionChange(linear1, linear2, angular1, angular2);
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        this.mainBody.calculateDerivedData();
        if (this.altBody != null) {
            this.altBody.position.addLocal(linear2);
            this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
            this.altBody.calculateDerivedData();
        }
        this.calculateVelocityChange(linear1, linear2, angular1, angular2);
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular1);
        if (this.altBody != null) {
            this.altBody.addLinearVelocity(linear2);
            this.altBody.addRotationalVelocity(angular2);
        }
    }

    public void resolveUnconstrained(double step) {
        Vec3d world1 = this.altOffset;
        Vec3d world2 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d delta = world1.subtract(world2);
        double length = delta.length();
        if (length == 0.0) {
            return;
        }
        Vec3d normal = delta.mult(1.0 / length);
        double linVelSq = this.mainBody.getLinearVelocity().lengthSq() / this.mainBody.getTemperature();
        double rotVelSq = this.mainBody.getRotationalVelocity().lengthSq() / this.mainBody.getTemperature();
        this.contact.setContactInfo(world2, normal, delta.length());
        this.contact.calculateInternals(step);
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.contact.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact.penetration);
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        this.mainBody.calculateDerivedData();
        this.contact.calculateVelocityChange(linear1, linear2, angular1, angular2);
        double slow = this.damping;
        Vec3d rot = this.mainBody.getRotationalVelocity();
        angular1.addLocal(rot.add(angular1).multLocal(-slow));
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular1);
    }

    public void resolveUnconstrainedTwoBody(double step) {
        Vec3d world1 = this.mainBody.localToWorld(this.mainOffset);
        Vec3d world2 = this.altBody.localToWorld(this.altOffset);
        Vec3d delta = world2.subtract(world1);
        double length = delta.length();
        if (length == 0.0) {
            log.debug("  delta length:" + length);
            return;
        }
        Vec3d normal = delta.mult(1.0 / length);
        double linVelSq = this.mainBody.getLinearVelocity().lengthSq() / this.mainBody.getTemperature();
        double rotVelSq = this.mainBody.getRotationalVelocity().lengthSq() / this.mainBody.getTemperature();
        this.contact.setContactInfo(world1, normal, delta.length());
        this.contact.matchLocalTemperature();
        this.contact.calculateInternals(step);
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        this.contact.calculatePositionChange(linear1, linear2, angular1, angular2, this.contact.penetration);
        this.mainBody.position.addLocal(linear1);
        this.mainBody.orientation.addScaledVectorLocal(angular1, 1.0);
        this.mainBody.calculateDerivedData();
        this.altBody.position.addLocal(linear2);
        this.altBody.orientation.addScaledVectorLocal(angular2, 1.0);
        this.altBody.calculateDerivedData();
        this.contact.calculateVelocityChange(linear1, linear2, angular1, angular2);
        double slow = this.damping;
        Vec3d rot1 = this.mainBody.getRotationalVelocity();
        Vec3d rot2 = this.altBody.getRotationalVelocity();
        angular1.addLocal(rot1.add(angular1).multLocal(-slow));
        angular2.addLocal(rot2.add(angular2).multLocal(-slow));
        this.mainBody.addLinearVelocity(linear1);
        this.mainBody.addRotationalVelocity(angular1);
        this.altBody.addLinearVelocity(linear2);
        this.altBody.addRotationalVelocity(angular2);
    }
}

