/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;

public class ZoneKey {
    public ZoneGrid grid;
    public int x;
    public int y;
    public int z;
    public Vec3i origin;

    public ZoneKey(ZoneGrid grid, int x, int y, int z) {
        this.grid = grid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.origin = grid.zoneToWorld(x, y, z);
    }

    public Vec3d toWorld(Vec3d relative) {
        return this.toWorld(relative, new Vec3d());
    }

    public Vec3d toWorld(Vec3d relative, Vec3d store) {
        store.x = (double)this.origin.x + relative.x;
        store.y = (double)this.origin.y + relative.y;
        store.z = (double)this.origin.z + relative.z;
        return store;
    }

    public Vec3d toLocal(Vec3d world) {
        return this.toLocal(world, new Vec3d());
    }

    public Vec3d toLocal(Vec3d world, Vec3d store) {
        store.x = world.x - (double)this.origin.x;
        store.y = world.y - (double)this.origin.y;
        store.z = world.z - (double)this.origin.z;
        return store;
    }

    public long toLongId() {
        return this.grid.toLongId(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ZoneKey other = (ZoneKey)o;
        return other.x == this.x && other.y == this.y && other.z == this.z && other.grid == this.grid;
    }

    public int hashCode() {
        int hash = 37;
        hash += 37 * hash + this.x;
        hash += 37 * hash + this.y;
        hash += 37 * hash + this.z;
        return hash;
    }

    public String toString() {
        return this.x + ":" + this.y + ":" + this.z;
    }
}

