/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import com.simsilica.sim.SystemTiming;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LagDetectionSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(LagDetectionSystem.class);
    private final SystemTiming timing = new SystemTiming();
    private long lastTime = 0L;
    private long expectedFrameTime = 16666666L;
    private long expectedMultiplier = 2L;
    private long dumpMultiplier = 3L;

    public LagDetectionSystem() {
        this.timing.setTimingCheckThreshold(this.dumpMultiplier * this.expectedFrameTime / 1000000L);
    }

    protected void initialize() {
        this.getManager().setSystemTiming(this.timing);
    }

    protected void terminate() {
    }

    public void start() {
    }

    public void update(SimTime time) {
        long t = System.nanoTime();
        if (this.lastTime != 0L) {
            long delta = t - this.lastTime;
            if (delta > this.expectedFrameTime * this.expectedMultiplier) {
                log.warn(String.format("Detected frame lag, calculated: %.03f ms, sim tpf: %.03f s", (double)delta / 1000000.0, time.getTpf()));
            }
            if (delta > this.expectedFrameTime * this.dumpMultiplier) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry e : this.timing.getAllTimingInfo().entrySet()) {
                    if (e.getKey() == this) continue;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(e.getValue() + ":" + e.getKey());
                }
                log.warn("System timings:" + sb);
            }
        }
        this.lastTime = t;
    }

    public void stop() {
    }
}

