/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.base.Function;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mworld.World;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.lang.invoke.StringConcatFactory;
import java.util.Map;
import mythruna.es.MovementInput;
import mythruna.es.VehicleInput;
import mythruna.sim.AttachmentSystem;
import mythruna.sim.BodyAttachment;
import mythruna.sim.PlayerDriver;
import mythruna.sim.VehicleDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MovementSystem.class);
    private EntityData ed;
    private World world;
    private MPhysSystem<MBlockShape> physics;
    private PlayerContainer players;
    private VehicleContainer vehicles;
    private MovementBodyInitializer initializer = new MovementBodyInitializer();
    private PhysicsSpace<EntityId, MBlockShape> space;

    public RigidBody<EntityId, MBlockShape> getBody(EntityId id) {
        return this.space.getBinIndex().getRigidBody((Object)id);
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        if (this.ed == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires an EntityData object.");
        }
        this.world = (World)this.getSystem(World.class, true);
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class);
        if (this.physics == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " system requires the MPhysSystem system.");
        }
        this.space = this.physics.getPhysicsSpace();
        this.physics.getBodyFactory().addDynamicInitializer((Function)this.initializer);
    }

    protected void terminate() {
    }

    public void start() {
        this.players = new PlayerContainer(this.ed);
        this.vehicles = new VehicleContainer(this.ed);
        this.players.start();
        this.vehicles.start();
    }

    public void update(SimTime time) {
        this.players.update();
        this.vehicles.update();
    }

    public void stop() {
        this.players.stop();
        this.players = null;
        this.vehicles.stop();
        this.vehicles = null;
    }

    protected void updateAttachments(EntityId id, PlayerDriver driver) {
        for (Map.Entry<String, BodyAttachment> e : ((AttachmentSystem)((Object)this.getSystem(AttachmentSystem.class, true))).getAttachments(id).entrySet()) {
            driver.updateAttachment(e.getKey(), e.getValue());
        }
    }

    private class MovementBodyInitializer
    implements Function<RigidBody<EntityId, MBlockShape>, Void> {
        private MovementBodyInitializer() {
        }

        public Void apply(RigidBody<EntityId, MBlockShape> body) {
            PlayerDriver driver = (PlayerDriver)MovementSystem.this.players.getObject((EntityId)body.id);
            if (log.isTraceEnabled()) {
                log.trace("MovementBodyInitializer.apply(" + body.id + ")  driver:" + driver);
            }
            if (driver != null) {
                body.setControlDriver((ControlDriver)driver);
            }
            VehicleDriver driver2 = (VehicleDriver)((Object)MovementSystem.this.vehicles.getObject((EntityId)body.id));
            if (log.isTraceEnabled()) {
                log.trace("MovementBodyInitializer.apply(" + body.id + ")  driver2:" + driver2);
            }
            if (driver2 != null) {
                body.setControlDriver((ControlDriver)driver2);
            }
            return null;
        }
    }

    private class PlayerContainer
    extends EntityContainer<PlayerDriver> {
        public PlayerContainer(EntityData ed) {
            super(ed, new Class[]{MovementInput.class});
        }

        public PlayerDriver[] getArray() {
            return (PlayerDriver[])super.getArray();
        }

        protected PlayerDriver addObject(Entity e) {
            log.info("addObject(" + e + ")");
            PlayerDriver result = new PlayerDriver(MovementSystem.this.world, MovementSystem.this.ed, e.getId(), MovementSystem.this.physics);
            MovementSystem.this.updateAttachments(e.getId(), result);
            RigidBody body = MovementSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            if (body != null) {
                log.info("existing body:" + body.id);
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
            } else {
                log.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"existing body:null"})));
            }
            return result;
        }

        protected void updateObject(PlayerDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            MovementInput ms = (MovementInput)e.get(MovementInput.class);
            driver.applyMovementInput(ms);
        }

        protected void removeObject(PlayerDriver driver, Entity e) {
            log.info("removeObject(" + e + ")");
        }
    }

    private class VehicleContainer
    extends EntityContainer<VehicleDriver> {
        public VehicleContainer(EntityData ed) {
            super(ed, new Class[]{VehicleInput.class});
        }

        public VehicleDriver[] getArray() {
            return (VehicleDriver[])super.getArray();
        }

        protected VehicleDriver addObject(Entity e) {
            log.info("Vehicles.addObject(" + e + ")");
            VehicleDriver result = new VehicleDriver(MovementSystem.this.ed, e.getId());
            RigidBody body = MovementSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            if (body != null) {
                log.info("Vehicles.existing body:" + body.id);
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
            } else {
                log.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Vehicles.existing body:null"})));
            }
            return result;
        }

        protected void updateObject(VehicleDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            VehicleInput ms = (VehicleInput)e.get(VehicleInput.class);
            driver.applyVehicleInput(ms);
        }

        protected void removeObject(VehicleDriver driver, Entity e) {
            log.info("Vehicles.removeObject(" + e + ")");
        }
    }
}

